<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeSearchAdvanced StructType
 * @subpackage Structs
 */
class EmployeeSearchAdvanced extends SearchRecord
{
    /**
     * The criteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearch
     */
    public $criteria;
    /**
     * The columns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchRow
     */
    public $columns;
    /**
     * The savedSearchId
     * @var string
     */
    public $savedSearchId;
    /**
     * The savedSearchScriptId
     * @var string
     */
    public $savedSearchScriptId;
    /**
     * Constructor method for EmployeeSearchAdvanced
     * @uses EmployeeSearchAdvanced::setCriteria()
     * @uses EmployeeSearchAdvanced::setColumns()
     * @uses EmployeeSearchAdvanced::setSavedSearchId()
     * @uses EmployeeSearchAdvanced::setSavedSearchScriptId()
     * @param \StructType\EmployeeSearch $criteria
     * @param \StructType\EmployeeSearchRow $columns
     * @param string $savedSearchId
     * @param string $savedSearchScriptId
     */
    public function __construct(\StructType\EmployeeSearch $criteria = null, \StructType\EmployeeSearchRow $columns = null, $savedSearchId = null, $savedSearchScriptId = null)
    {
        $this
            ->setCriteria($criteria)
            ->setColumns($columns)
            ->setSavedSearchId($savedSearchId)
            ->setSavedSearchScriptId($savedSearchScriptId);
    }
    /**
     * Get criteria value
     * @return \StructType\EmployeeSearch|null
     */
    public function getCriteria()
    {
        return $this->criteria;
    }
    /**
     * Set criteria value
     * @param \StructType\EmployeeSearch $criteria
     * @return \StructType\EmployeeSearchAdvanced
     */
    public function setCriteria(\StructType\EmployeeSearch $criteria = null)
    {
        $this->criteria = $criteria;
        return $this;
    }
    /**
     * Get columns value
     * @return \StructType\EmployeeSearchRow|null
     */
    public function getColumns()
    {
        return $this->columns;
    }
    /**
     * Set columns value
     * @param \StructType\EmployeeSearchRow $columns
     * @return \StructType\EmployeeSearchAdvanced
     */
    public function setColumns(\StructType\EmployeeSearchRow $columns = null)
    {
        $this->columns = $columns;
        return $this;
    }
    /**
     * Get savedSearchId value
     * @return string|null
     */
    public function getSavedSearchId()
    {
        return $this->savedSearchId;
    }
    /**
     * Set savedSearchId value
     * @param string $savedSearchId
     * @return \StructType\EmployeeSearchAdvanced
     */
    public function setSavedSearchId($savedSearchId = null)
    {
        // validation for constraint: string
        if (!is_null($savedSearchId) && !is_string($savedSearchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($savedSearchId, true), gettype($savedSearchId)), __LINE__);
        }
        $this->savedSearchId = $savedSearchId;
        return $this;
    }
    /**
     * Get savedSearchScriptId value
     * @return string|null
     */
    public function getSavedSearchScriptId()
    {
        return $this->savedSearchScriptId;
    }
    /**
     * Set savedSearchScriptId value
     * @param string $savedSearchScriptId
     * @return \StructType\EmployeeSearchAdvanced
     */
    public function setSavedSearchScriptId($savedSearchScriptId = null)
    {
        // validation for constraint: string
        if (!is_null($savedSearchScriptId) && !is_string($savedSearchScriptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($savedSearchScriptId, true), gettype($savedSearchScriptId)), __LINE__);
        }
        $this->savedSearchScriptId = $savedSearchScriptId;
        return $this;
    }
}
