<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeHrEducation StructType
 * @subpackage Structs
 */
class EmployeeHrEducation extends AbstractStructBase
{
    /**
     * The education
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $education;
    /**
     * The degree
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $degree;
    /**
     * The degreeDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $degreeDate;
    /**
     * Constructor method for EmployeeHrEducation
     * @uses EmployeeHrEducation::setEducation()
     * @uses EmployeeHrEducation::setDegree()
     * @uses EmployeeHrEducation::setDegreeDate()
     * @param \StructType\RecordRef $education
     * @param string $degree
     * @param string $degreeDate
     */
    public function __construct(\StructType\RecordRef $education = null, $degree = null, $degreeDate = null)
    {
        $this
            ->setEducation($education)
            ->setDegree($degree)
            ->setDegreeDate($degreeDate);
    }
    /**
     * Get education value
     * @return \StructType\RecordRef|null
     */
    public function getEducation()
    {
        return $this->education;
    }
    /**
     * Set education value
     * @param \StructType\RecordRef $education
     * @return \StructType\EmployeeHrEducation
     */
    public function setEducation(\StructType\RecordRef $education = null)
    {
        $this->education = $education;
        return $this;
    }
    /**
     * Get degree value
     * @return string|null
     */
    public function getDegree()
    {
        return $this->degree;
    }
    /**
     * Set degree value
     * @param string $degree
     * @return \StructType\EmployeeHrEducation
     */
    public function setDegree($degree = null)
    {
        // validation for constraint: string
        if (!is_null($degree) && !is_string($degree)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($degree, true), gettype($degree)), __LINE__);
        }
        $this->degree = $degree;
        return $this;
    }
    /**
     * Get degreeDate value
     * @return string|null
     */
    public function getDegreeDate()
    {
        return $this->degreeDate;
    }
    /**
     * Set degreeDate value
     * @param string $degreeDate
     * @return \StructType\EmployeeHrEducation
     */
    public function setDegreeDate($degreeDate = null)
    {
        // validation for constraint: string
        if (!is_null($degreeDate) && !is_string($degreeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($degreeDate, true), gettype($degreeDate)), __LINE__);
        }
        $this->degreeDate = $degreeDate;
        return $this;
    }
}
