<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeHcmPosition StructType
 * @subpackage Structs
 */
class EmployeeHcmPosition extends AbstractStructBase
{
    /**
     * The position
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $position;
    /**
     * The primaryPosition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $primaryPosition;
    /**
     * The positionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $positionId;
    /**
     * The positionAllocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $positionAllocation;
    /**
     * The fullTimeEquivalent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $fullTimeEquivalent;
    /**
     * The employmentCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $employmentCategory;
    /**
     * The reportsTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $reportsTo;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * Constructor method for EmployeeHcmPosition
     * @uses EmployeeHcmPosition::setPosition()
     * @uses EmployeeHcmPosition::setPrimaryPosition()
     * @uses EmployeeHcmPosition::setPositionId()
     * @uses EmployeeHcmPosition::setPositionAllocation()
     * @uses EmployeeHcmPosition::setFullTimeEquivalent()
     * @uses EmployeeHcmPosition::setEmploymentCategory()
     * @uses EmployeeHcmPosition::setReportsTo()
     * @uses EmployeeHcmPosition::setSubsidiary()
     * @uses EmployeeHcmPosition::setLocation()
     * @param \StructType\RecordRef $position
     * @param bool $primaryPosition
     * @param string $positionId
     * @param float $positionAllocation
     * @param float $fullTimeEquivalent
     * @param \StructType\RecordRef $employmentCategory
     * @param \StructType\RecordRef $reportsTo
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $location
     */
    public function __construct(\StructType\RecordRef $position = null, $primaryPosition = null, $positionId = null, $positionAllocation = null, $fullTimeEquivalent = null, \StructType\RecordRef $employmentCategory = null, \StructType\RecordRef $reportsTo = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $location = null)
    {
        $this
            ->setPosition($position)
            ->setPrimaryPosition($primaryPosition)
            ->setPositionId($positionId)
            ->setPositionAllocation($positionAllocation)
            ->setFullTimeEquivalent($fullTimeEquivalent)
            ->setEmploymentCategory($employmentCategory)
            ->setReportsTo($reportsTo)
            ->setSubsidiary($subsidiary)
            ->setLocation($location);
    }
    /**
     * Get position value
     * @return \StructType\RecordRef|null
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * Set position value
     * @param \StructType\RecordRef $position
     * @return \StructType\EmployeeHcmPosition
     */
    public function setPosition(\StructType\RecordRef $position = null)
    {
        $this->position = $position;
        return $this;
    }
    /**
     * Get primaryPosition value
     * @return bool|null
     */
    public function getPrimaryPosition()
    {
        return $this->primaryPosition;
    }
    /**
     * Set primaryPosition value
     * @param bool $primaryPosition
     * @return \StructType\EmployeeHcmPosition
     */
    public function setPrimaryPosition($primaryPosition = null)
    {
        // validation for constraint: boolean
        if (!is_null($primaryPosition) && !is_bool($primaryPosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primaryPosition, true), gettype($primaryPosition)), __LINE__);
        }
        $this->primaryPosition = $primaryPosition;
        return $this;
    }
    /**
     * Get positionId value
     * @return string|null
     */
    public function getPositionId()
    {
        return $this->positionId;
    }
    /**
     * Set positionId value
     * @param string $positionId
     * @return \StructType\EmployeeHcmPosition
     */
    public function setPositionId($positionId = null)
    {
        // validation for constraint: string
        if (!is_null($positionId) && !is_string($positionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($positionId, true), gettype($positionId)), __LINE__);
        }
        $this->positionId = $positionId;
        return $this;
    }
    /**
     * Get positionAllocation value
     * @return float|null
     */
    public function getPositionAllocation()
    {
        return $this->positionAllocation;
    }
    /**
     * Set positionAllocation value
     * @param float $positionAllocation
     * @return \StructType\EmployeeHcmPosition
     */
    public function setPositionAllocation($positionAllocation = null)
    {
        // validation for constraint: float
        if (!is_null($positionAllocation) && !(is_float($positionAllocation) || is_numeric($positionAllocation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($positionAllocation, true), gettype($positionAllocation)), __LINE__);
        }
        $this->positionAllocation = $positionAllocation;
        return $this;
    }
    /**
     * Get fullTimeEquivalent value
     * @return float|null
     */
    public function getFullTimeEquivalent()
    {
        return $this->fullTimeEquivalent;
    }
    /**
     * Set fullTimeEquivalent value
     * @param float $fullTimeEquivalent
     * @return \StructType\EmployeeHcmPosition
     */
    public function setFullTimeEquivalent($fullTimeEquivalent = null)
    {
        // validation for constraint: float
        if (!is_null($fullTimeEquivalent) && !(is_float($fullTimeEquivalent) || is_numeric($fullTimeEquivalent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fullTimeEquivalent, true), gettype($fullTimeEquivalent)), __LINE__);
        }
        $this->fullTimeEquivalent = $fullTimeEquivalent;
        return $this;
    }
    /**
     * Get employmentCategory value
     * @return \StructType\RecordRef|null
     */
    public function getEmploymentCategory()
    {
        return $this->employmentCategory;
    }
    /**
     * Set employmentCategory value
     * @param \StructType\RecordRef $employmentCategory
     * @return \StructType\EmployeeHcmPosition
     */
    public function setEmploymentCategory(\StructType\RecordRef $employmentCategory = null)
    {
        $this->employmentCategory = $employmentCategory;
        return $this;
    }
    /**
     * Get reportsTo value
     * @return \StructType\RecordRef|null
     */
    public function getReportsTo()
    {
        return $this->reportsTo;
    }
    /**
     * Set reportsTo value
     * @param \StructType\RecordRef $reportsTo
     * @return \StructType\EmployeeHcmPosition
     */
    public function setReportsTo(\StructType\RecordRef $reportsTo = null)
    {
        $this->reportsTo = $reportsTo;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\EmployeeHcmPosition
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\EmployeeHcmPosition
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
}
