<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeEarning StructType
 * @subpackage Structs
 */
class EmployeeEarning extends AbstractStructBase
{
    /**
     * The payrollItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $payrollItem;
    /**
     * The payRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payRate;
    /**
     * The primaryEarning
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $primaryEarning;
    /**
     * The defaultHours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $defaultHours;
    /**
     * The inactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $inactive;
    /**
     * The defaultEarning
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $defaultEarning;
    /**
     * The effectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $effectiveDate;
    /**
     * The expirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expirationDate;
    /**
     * Constructor method for EmployeeEarning
     * @uses EmployeeEarning::setPayrollItem()
     * @uses EmployeeEarning::setPayRate()
     * @uses EmployeeEarning::setPrimaryEarning()
     * @uses EmployeeEarning::setDefaultHours()
     * @uses EmployeeEarning::setInactive()
     * @uses EmployeeEarning::setDefaultEarning()
     * @uses EmployeeEarning::setEffectiveDate()
     * @uses EmployeeEarning::setExpirationDate()
     * @param \StructType\RecordRef $payrollItem
     * @param string $payRate
     * @param bool $primaryEarning
     * @param float $defaultHours
     * @param bool $inactive
     * @param bool $defaultEarning
     * @param string $effectiveDate
     * @param string $expirationDate
     */
    public function __construct(\StructType\RecordRef $payrollItem = null, $payRate = null, $primaryEarning = null, $defaultHours = null, $inactive = null, $defaultEarning = null, $effectiveDate = null, $expirationDate = null)
    {
        $this
            ->setPayrollItem($payrollItem)
            ->setPayRate($payRate)
            ->setPrimaryEarning($primaryEarning)
            ->setDefaultHours($defaultHours)
            ->setInactive($inactive)
            ->setDefaultEarning($defaultEarning)
            ->setEffectiveDate($effectiveDate)
            ->setExpirationDate($expirationDate);
    }
    /**
     * Get payrollItem value
     * @return \StructType\RecordRef|null
     */
    public function getPayrollItem()
    {
        return $this->payrollItem;
    }
    /**
     * Set payrollItem value
     * @param \StructType\RecordRef $payrollItem
     * @return \StructType\EmployeeEarning
     */
    public function setPayrollItem(\StructType\RecordRef $payrollItem = null)
    {
        $this->payrollItem = $payrollItem;
        return $this;
    }
    /**
     * Get payRate value
     * @return string|null
     */
    public function getPayRate()
    {
        return $this->payRate;
    }
    /**
     * Set payRate value
     * @param string $payRate
     * @return \StructType\EmployeeEarning
     */
    public function setPayRate($payRate = null)
    {
        // validation for constraint: string
        if (!is_null($payRate) && !is_string($payRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payRate, true), gettype($payRate)), __LINE__);
        }
        $this->payRate = $payRate;
        return $this;
    }
    /**
     * Get primaryEarning value
     * @return bool|null
     */
    public function getPrimaryEarning()
    {
        return $this->primaryEarning;
    }
    /**
     * Set primaryEarning value
     * @param bool $primaryEarning
     * @return \StructType\EmployeeEarning
     */
    public function setPrimaryEarning($primaryEarning = null)
    {
        // validation for constraint: boolean
        if (!is_null($primaryEarning) && !is_bool($primaryEarning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primaryEarning, true), gettype($primaryEarning)), __LINE__);
        }
        $this->primaryEarning = $primaryEarning;
        return $this;
    }
    /**
     * Get defaultHours value
     * @return float|null
     */
    public function getDefaultHours()
    {
        return $this->defaultHours;
    }
    /**
     * Set defaultHours value
     * @param float $defaultHours
     * @return \StructType\EmployeeEarning
     */
    public function setDefaultHours($defaultHours = null)
    {
        // validation for constraint: float
        if (!is_null($defaultHours) && !(is_float($defaultHours) || is_numeric($defaultHours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($defaultHours, true), gettype($defaultHours)), __LINE__);
        }
        $this->defaultHours = $defaultHours;
        return $this;
    }
    /**
     * Get inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->inactive;
    }
    /**
     * Set inactive value
     * @param bool $inactive
     * @return \StructType\EmployeeEarning
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->inactive = $inactive;
        return $this;
    }
    /**
     * Get defaultEarning value
     * @return bool|null
     */
    public function getDefaultEarning()
    {
        return $this->defaultEarning;
    }
    /**
     * Set defaultEarning value
     * @param bool $defaultEarning
     * @return \StructType\EmployeeEarning
     */
    public function setDefaultEarning($defaultEarning = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultEarning) && !is_bool($defaultEarning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultEarning, true), gettype($defaultEarning)), __LINE__);
        }
        $this->defaultEarning = $defaultEarning;
        return $this;
    }
    /**
     * Get effectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->effectiveDate;
    }
    /**
     * Set effectiveDate value
     * @param string $effectiveDate
     * @return \StructType\EmployeeEarning
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->effectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\EmployeeEarning
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
}
