<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DemandPlanMatrix StructType
 * @subpackage Structs
 */
class DemandPlanMatrix extends AbstractStructBase
{
    /**
     * The demandPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DemandPlan[]
     */
    public $demandPlan;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for DemandPlanMatrix
     * @uses DemandPlanMatrix::setDemandPlan()
     * @uses DemandPlanMatrix::setReplaceAll()
     * @param \StructType\DemandPlan[] $demandPlan
     * @param bool $replaceAll
     */
    public function __construct(array $demandPlan = array(), $replaceAll = false)
    {
        $this
            ->setDemandPlan($demandPlan)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get demandPlan value
     * @return \StructType\DemandPlan[]|null
     */
    public function getDemandPlan()
    {
        return $this->demandPlan;
    }
    /**
     * This method is responsible for validating the values passed to the setDemandPlan method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDemandPlan method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDemandPlanForArrayConstraintsFromSetDemandPlan(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $demandPlanMatrixDemandPlanItem) {
            // validation for constraint: itemType
            if (!$demandPlanMatrixDemandPlanItem instanceof \StructType\DemandPlan) {
                $invalidValues[] = is_object($demandPlanMatrixDemandPlanItem) ? get_class($demandPlanMatrixDemandPlanItem) : sprintf('%s(%s)', gettype($demandPlanMatrixDemandPlanItem), var_export($demandPlanMatrixDemandPlanItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The demandPlan property can only contain items of type \StructType\DemandPlan, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set demandPlan value
     * @throws \InvalidArgumentException
     * @param \StructType\DemandPlan[] $demandPlan
     * @return \StructType\DemandPlanMatrix
     */
    public function setDemandPlan(array $demandPlan = array())
    {
        // validation for constraint: array
        if ('' !== ($demandPlanArrayErrorMessage = self::validateDemandPlanForArrayConstraintsFromSetDemandPlan($demandPlan))) {
            throw new \InvalidArgumentException($demandPlanArrayErrorMessage, __LINE__);
        }
        $this->demandPlan = $demandPlan;
        return $this;
    }
    /**
     * Add item to demandPlan value
     * @throws \InvalidArgumentException
     * @param \StructType\DemandPlan $item
     * @return \StructType\DemandPlanMatrix
     */
    public function addToDemandPlan(\StructType\DemandPlan $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DemandPlan) {
            throw new \InvalidArgumentException(sprintf('The demandPlan property can only contain items of type \StructType\DemandPlan, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->demandPlan[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\DemandPlanMatrix
     */
    public function setReplaceAll($replaceAll = false)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
