<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerRefundDepositList StructType
 * @subpackage Structs
 */
class CustomerRefundDepositList extends AbstractStructBase
{
    /**
     * The customerRefundDeposit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerRefundDeposit[]
     */
    public $customerRefundDeposit;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomerRefundDepositList
     * @uses CustomerRefundDepositList::setCustomerRefundDeposit()
     * @uses CustomerRefundDepositList::setReplaceAll()
     * @param \StructType\CustomerRefundDeposit[] $customerRefundDeposit
     * @param bool $replaceAll
     */
    public function __construct(array $customerRefundDeposit = array(), $replaceAll = true)
    {
        $this
            ->setCustomerRefundDeposit($customerRefundDeposit)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get customerRefundDeposit value
     * @return \StructType\CustomerRefundDeposit[]|null
     */
    public function getCustomerRefundDeposit()
    {
        return $this->customerRefundDeposit;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerRefundDeposit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerRefundDeposit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerRefundDepositForArrayConstraintsFromSetCustomerRefundDeposit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerRefundDepositListCustomerRefundDepositItem) {
            // validation for constraint: itemType
            if (!$customerRefundDepositListCustomerRefundDepositItem instanceof \StructType\CustomerRefundDeposit) {
                $invalidValues[] = is_object($customerRefundDepositListCustomerRefundDepositItem) ? get_class($customerRefundDepositListCustomerRefundDepositItem) : sprintf('%s(%s)', gettype($customerRefundDepositListCustomerRefundDepositItem), var_export($customerRefundDepositListCustomerRefundDepositItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customerRefundDeposit property can only contain items of type \StructType\CustomerRefundDeposit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customerRefundDeposit value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerRefundDeposit[] $customerRefundDeposit
     * @return \StructType\CustomerRefundDepositList
     */
    public function setCustomerRefundDeposit(array $customerRefundDeposit = array())
    {
        // validation for constraint: array
        if ('' !== ($customerRefundDepositArrayErrorMessage = self::validateCustomerRefundDepositForArrayConstraintsFromSetCustomerRefundDeposit($customerRefundDeposit))) {
            throw new \InvalidArgumentException($customerRefundDepositArrayErrorMessage, __LINE__);
        }
        $this->customerRefundDeposit = $customerRefundDeposit;
        return $this;
    }
    /**
     * Add item to customerRefundDeposit value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerRefundDeposit $item
     * @return \StructType\CustomerRefundDepositList
     */
    public function addToCustomerRefundDeposit(\StructType\CustomerRefundDeposit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerRefundDeposit) {
            throw new \InvalidArgumentException(sprintf('The customerRefundDeposit property can only contain items of type \StructType\CustomerRefundDeposit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customerRefundDeposit[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomerRefundDepositList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
