<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPaymentDepositList StructType
 * @subpackage Structs
 */
class CustomerPaymentDepositList extends AbstractStructBase
{
    /**
     * The deposit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerPaymentDeposit[]
     */
    public $deposit;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomerPaymentDepositList
     * @uses CustomerPaymentDepositList::setDeposit()
     * @uses CustomerPaymentDepositList::setReplaceAll()
     * @param \StructType\CustomerPaymentDeposit[] $deposit
     * @param bool $replaceAll
     */
    public function __construct(array $deposit = array(), $replaceAll = true)
    {
        $this
            ->setDeposit($deposit)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get deposit value
     * @return \StructType\CustomerPaymentDeposit[]|null
     */
    public function getDeposit()
    {
        return $this->deposit;
    }
    /**
     * This method is responsible for validating the values passed to the setDeposit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeposit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepositForArrayConstraintsFromSetDeposit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerPaymentDepositListDepositItem) {
            // validation for constraint: itemType
            if (!$customerPaymentDepositListDepositItem instanceof \StructType\CustomerPaymentDeposit) {
                $invalidValues[] = is_object($customerPaymentDepositListDepositItem) ? get_class($customerPaymentDepositListDepositItem) : sprintf('%s(%s)', gettype($customerPaymentDepositListDepositItem), var_export($customerPaymentDepositListDepositItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The deposit property can only contain items of type \StructType\CustomerPaymentDeposit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set deposit value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerPaymentDeposit[] $deposit
     * @return \StructType\CustomerPaymentDepositList
     */
    public function setDeposit(array $deposit = array())
    {
        // validation for constraint: array
        if ('' !== ($depositArrayErrorMessage = self::validateDepositForArrayConstraintsFromSetDeposit($deposit))) {
            throw new \InvalidArgumentException($depositArrayErrorMessage, __LINE__);
        }
        $this->deposit = $deposit;
        return $this;
    }
    /**
     * Add item to deposit value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerPaymentDeposit $item
     * @return \StructType\CustomerPaymentDepositList
     */
    public function addToDeposit(\StructType\CustomerPaymentDeposit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerPaymentDeposit) {
            throw new \InvalidArgumentException(sprintf('The deposit property can only contain items of type \StructType\CustomerPaymentDeposit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->deposit[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomerPaymentDepositList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
