<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerItemPricingList StructType
 * @subpackage Structs
 */
class CustomerItemPricingList extends AbstractStructBase
{
    /**
     * The itemPricing
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerItemPricing[]
     */
    public $itemPricing;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomerItemPricingList
     * @uses CustomerItemPricingList::setItemPricing()
     * @uses CustomerItemPricingList::setReplaceAll()
     * @param \StructType\CustomerItemPricing[] $itemPricing
     * @param bool $replaceAll
     */
    public function __construct(array $itemPricing = array(), $replaceAll = true)
    {
        $this
            ->setItemPricing($itemPricing)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get itemPricing value
     * @return \StructType\CustomerItemPricing[]|null
     */
    public function getItemPricing()
    {
        return $this->itemPricing;
    }
    /**
     * This method is responsible for validating the values passed to the setItemPricing method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemPricing method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemPricingForArrayConstraintsFromSetItemPricing(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerItemPricingListItemPricingItem) {
            // validation for constraint: itemType
            if (!$customerItemPricingListItemPricingItem instanceof \StructType\CustomerItemPricing) {
                $invalidValues[] = is_object($customerItemPricingListItemPricingItem) ? get_class($customerItemPricingListItemPricingItem) : sprintf('%s(%s)', gettype($customerItemPricingListItemPricingItem), var_export($customerItemPricingListItemPricingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemPricing property can only contain items of type \StructType\CustomerItemPricing, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemPricing value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerItemPricing[] $itemPricing
     * @return \StructType\CustomerItemPricingList
     */
    public function setItemPricing(array $itemPricing = array())
    {
        // validation for constraint: array
        if ('' !== ($itemPricingArrayErrorMessage = self::validateItemPricingForArrayConstraintsFromSetItemPricing($itemPricing))) {
            throw new \InvalidArgumentException($itemPricingArrayErrorMessage, __LINE__);
        }
        $this->itemPricing = $itemPricing;
        return $this;
    }
    /**
     * Add item to itemPricing value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerItemPricing $item
     * @return \StructType\CustomerItemPricingList
     */
    public function addToItemPricing(\StructType\CustomerItemPricing $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerItemPricing) {
            throw new \InvalidArgumentException(sprintf('The itemPricing property can only contain items of type \StructType\CustomerItemPricing, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemPricing[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomerItemPricingList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
