<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerItemPricing StructType
 * @subpackage Structs
 */
class CustomerItemPricing extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The level
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $level;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price;
    /**
     * Constructor method for CustomerItemPricing
     * @uses CustomerItemPricing::setItem()
     * @uses CustomerItemPricing::setLevel()
     * @uses CustomerItemPricing::setCurrency()
     * @uses CustomerItemPricing::setPrice()
     * @param \StructType\RecordRef $item
     * @param \StructType\RecordRef $level
     * @param \StructType\RecordRef $currency
     * @param float $price
     */
    public function __construct(\StructType\RecordRef $item = null, \StructType\RecordRef $level = null, \StructType\RecordRef $currency = null, $price = null)
    {
        $this
            ->setItem($item)
            ->setLevel($level)
            ->setCurrency($currency)
            ->setPrice($price);
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\CustomerItemPricing
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get level value
     * @return \StructType\RecordRef|null
     */
    public function getLevel()
    {
        return $this->level;
    }
    /**
     * Set level value
     * @param \StructType\RecordRef $level
     * @return \StructType\CustomerItemPricing
     */
    public function setLevel(\StructType\RecordRef $level = null)
    {
        $this->level = $level;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\CustomerItemPricing
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\CustomerItemPricing
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
}
