<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerDownloadList StructType
 * @subpackage Structs
 */
class CustomerDownloadList extends AbstractStructBase
{
    /**
     * The download
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerDownload[]
     */
    public $download;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomerDownloadList
     * @uses CustomerDownloadList::setDownload()
     * @uses CustomerDownloadList::setReplaceAll()
     * @param \StructType\CustomerDownload[] $download
     * @param bool $replaceAll
     */
    public function __construct(array $download = array(), $replaceAll = true)
    {
        $this
            ->setDownload($download)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get download value
     * @return \StructType\CustomerDownload[]|null
     */
    public function getDownload()
    {
        return $this->download;
    }
    /**
     * This method is responsible for validating the values passed to the setDownload method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDownload method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDownloadForArrayConstraintsFromSetDownload(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerDownloadListDownloadItem) {
            // validation for constraint: itemType
            if (!$customerDownloadListDownloadItem instanceof \StructType\CustomerDownload) {
                $invalidValues[] = is_object($customerDownloadListDownloadItem) ? get_class($customerDownloadListDownloadItem) : sprintf('%s(%s)', gettype($customerDownloadListDownloadItem), var_export($customerDownloadListDownloadItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The download property can only contain items of type \StructType\CustomerDownload, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set download value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerDownload[] $download
     * @return \StructType\CustomerDownloadList
     */
    public function setDownload(array $download = array())
    {
        // validation for constraint: array
        if ('' !== ($downloadArrayErrorMessage = self::validateDownloadForArrayConstraintsFromSetDownload($download))) {
            throw new \InvalidArgumentException($downloadArrayErrorMessage, __LINE__);
        }
        $this->download = $download;
        return $this;
    }
    /**
     * Add item to download value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerDownload $item
     * @return \StructType\CustomerDownloadList
     */
    public function addToDownload(\StructType\CustomerDownload $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerDownload) {
            throw new \InvalidArgumentException(sprintf('The download property can only contain items of type \StructType\CustomerDownload, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->download[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomerDownloadList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
