<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerCreditCardsList StructType
 * @subpackage Structs
 */
class CustomerCreditCardsList extends AbstractStructBase
{
    /**
     * The creditCards
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerCreditCards[]
     */
    public $creditCards;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomerCreditCardsList
     * @uses CustomerCreditCardsList::setCreditCards()
     * @uses CustomerCreditCardsList::setReplaceAll()
     * @param \StructType\CustomerCreditCards[] $creditCards
     * @param bool $replaceAll
     */
    public function __construct(array $creditCards = array(), $replaceAll = true)
    {
        $this
            ->setCreditCards($creditCards)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get creditCards value
     * @return \StructType\CustomerCreditCards[]|null
     */
    public function getCreditCards()
    {
        return $this->creditCards;
    }
    /**
     * This method is responsible for validating the values passed to the setCreditCards method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreditCards method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreditCardsForArrayConstraintsFromSetCreditCards(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerCreditCardsListCreditCardsItem) {
            // validation for constraint: itemType
            if (!$customerCreditCardsListCreditCardsItem instanceof \StructType\CustomerCreditCards) {
                $invalidValues[] = is_object($customerCreditCardsListCreditCardsItem) ? get_class($customerCreditCardsListCreditCardsItem) : sprintf('%s(%s)', gettype($customerCreditCardsListCreditCardsItem), var_export($customerCreditCardsListCreditCardsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The creditCards property can only contain items of type \StructType\CustomerCreditCards, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set creditCards value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerCreditCards[] $creditCards
     * @return \StructType\CustomerCreditCardsList
     */
    public function setCreditCards(array $creditCards = array())
    {
        // validation for constraint: array
        if ('' !== ($creditCardsArrayErrorMessage = self::validateCreditCardsForArrayConstraintsFromSetCreditCards($creditCards))) {
            throw new \InvalidArgumentException($creditCardsArrayErrorMessage, __LINE__);
        }
        $this->creditCards = $creditCards;
        return $this;
    }
    /**
     * Add item to creditCards value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerCreditCards $item
     * @return \StructType\CustomerCreditCardsList
     */
    public function addToCreditCards(\StructType\CustomerCreditCards $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerCreditCards) {
            throw new \InvalidArgumentException(sprintf('The creditCards property can only contain items of type \StructType\CustomerCreditCards, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->creditCards[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomerCreditCardsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
