<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomRecordTypeTabsList StructType
 * @subpackage Structs
 */
class CustomRecordTypeTabsList extends AbstractStructBase
{
    /**
     * The tabs
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypeTabs[]
     */
    public $tabs;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomRecordTypeTabsList
     * @uses CustomRecordTypeTabsList::setTabs()
     * @uses CustomRecordTypeTabsList::setReplaceAll()
     * @param \StructType\CustomRecordTypeTabs[] $tabs
     * @param bool $replaceAll
     */
    public function __construct(array $tabs = array(), $replaceAll = true)
    {
        $this
            ->setTabs($tabs)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get tabs value
     * @return \StructType\CustomRecordTypeTabs[]|null
     */
    public function getTabs()
    {
        return $this->tabs;
    }
    /**
     * This method is responsible for validating the values passed to the setTabs method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTabs method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTabsForArrayConstraintsFromSetTabs(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customRecordTypeTabsListTabsItem) {
            // validation for constraint: itemType
            if (!$customRecordTypeTabsListTabsItem instanceof \StructType\CustomRecordTypeTabs) {
                $invalidValues[] = is_object($customRecordTypeTabsListTabsItem) ? get_class($customRecordTypeTabsListTabsItem) : sprintf('%s(%s)', gettype($customRecordTypeTabsListTabsItem), var_export($customRecordTypeTabsListTabsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The tabs property can only contain items of type \StructType\CustomRecordTypeTabs, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tabs value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordTypeTabs[] $tabs
     * @return \StructType\CustomRecordTypeTabsList
     */
    public function setTabs(array $tabs = array())
    {
        // validation for constraint: array
        if ('' !== ($tabsArrayErrorMessage = self::validateTabsForArrayConstraintsFromSetTabs($tabs))) {
            throw new \InvalidArgumentException($tabsArrayErrorMessage, __LINE__);
        }
        $this->tabs = $tabs;
        return $this;
    }
    /**
     * Add item to tabs value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordTypeTabs $item
     * @return \StructType\CustomRecordTypeTabsList
     */
    public function addToTabs(\StructType\CustomRecordTypeTabs $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomRecordTypeTabs) {
            throw new \InvalidArgumentException(sprintf('The tabs property can only contain items of type \StructType\CustomRecordTypeTabs, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->tabs[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomRecordTypeTabsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
