<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomRecordTypeParentsList StructType
 * @subpackage Structs
 */
class CustomRecordTypeParentsList extends AbstractStructBase
{
    /**
     * The parents
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypeParents[]
     */
    public $parents;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomRecordTypeParentsList
     * @uses CustomRecordTypeParentsList::setParents()
     * @uses CustomRecordTypeParentsList::setReplaceAll()
     * @param \StructType\CustomRecordTypeParents[] $parents
     * @param bool $replaceAll
     */
    public function __construct(array $parents = array(), $replaceAll = true)
    {
        $this
            ->setParents($parents)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get parents value
     * @return \StructType\CustomRecordTypeParents[]|null
     */
    public function getParents()
    {
        return $this->parents;
    }
    /**
     * This method is responsible for validating the values passed to the setParents method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParents method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParentsForArrayConstraintsFromSetParents(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customRecordTypeParentsListParentsItem) {
            // validation for constraint: itemType
            if (!$customRecordTypeParentsListParentsItem instanceof \StructType\CustomRecordTypeParents) {
                $invalidValues[] = is_object($customRecordTypeParentsListParentsItem) ? get_class($customRecordTypeParentsListParentsItem) : sprintf('%s(%s)', gettype($customRecordTypeParentsListParentsItem), var_export($customRecordTypeParentsListParentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parents property can only contain items of type \StructType\CustomRecordTypeParents, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parents value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordTypeParents[] $parents
     * @return \StructType\CustomRecordTypeParentsList
     */
    public function setParents(array $parents = array())
    {
        // validation for constraint: array
        if ('' !== ($parentsArrayErrorMessage = self::validateParentsForArrayConstraintsFromSetParents($parents))) {
            throw new \InvalidArgumentException($parentsArrayErrorMessage, __LINE__);
        }
        $this->parents = $parents;
        return $this;
    }
    /**
     * Add item to parents value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordTypeParents $item
     * @return \StructType\CustomRecordTypeParentsList
     */
    public function addToParents(\StructType\CustomRecordTypeParents $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomRecordTypeParents) {
            throw new \InvalidArgumentException(sprintf('The parents property can only contain items of type \StructType\CustomRecordTypeParents, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parents[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomRecordTypeParentsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
