<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomRecordTypeLinks StructType
 * @subpackage Structs
 */
class CustomRecordTypeLinks extends AbstractStructBase
{
    /**
     * The linkCenter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $linkCenter;
    /**
     * The linkSection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $linkSection;
    /**
     * The linkLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $linkLabel;
    /**
     * Constructor method for CustomRecordTypeLinks
     * @uses CustomRecordTypeLinks::setLinkCenter()
     * @uses CustomRecordTypeLinks::setLinkSection()
     * @uses CustomRecordTypeLinks::setLinkLabel()
     * @param \StructType\RecordRef $linkCenter
     * @param \StructType\RecordRef $linkSection
     * @param string $linkLabel
     */
    public function __construct(\StructType\RecordRef $linkCenter = null, \StructType\RecordRef $linkSection = null, $linkLabel = null)
    {
        $this
            ->setLinkCenter($linkCenter)
            ->setLinkSection($linkSection)
            ->setLinkLabel($linkLabel);
    }
    /**
     * Get linkCenter value
     * @return \StructType\RecordRef|null
     */
    public function getLinkCenter()
    {
        return $this->linkCenter;
    }
    /**
     * Set linkCenter value
     * @param \StructType\RecordRef $linkCenter
     * @return \StructType\CustomRecordTypeLinks
     */
    public function setLinkCenter(\StructType\RecordRef $linkCenter = null)
    {
        $this->linkCenter = $linkCenter;
        return $this;
    }
    /**
     * Get linkSection value
     * @return \StructType\RecordRef|null
     */
    public function getLinkSection()
    {
        return $this->linkSection;
    }
    /**
     * Set linkSection value
     * @param \StructType\RecordRef $linkSection
     * @return \StructType\CustomRecordTypeLinks
     */
    public function setLinkSection(\StructType\RecordRef $linkSection = null)
    {
        $this->linkSection = $linkSection;
        return $this;
    }
    /**
     * Get linkLabel value
     * @return string|null
     */
    public function getLinkLabel()
    {
        return $this->linkLabel;
    }
    /**
     * Set linkLabel value
     * @param string $linkLabel
     * @return \StructType\CustomRecordTypeLinks
     */
    public function setLinkLabel($linkLabel = null)
    {
        // validation for constraint: string
        if (!is_null($linkLabel) && !is_string($linkLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkLabel, true), gettype($linkLabel)), __LINE__);
        }
        $this->linkLabel = $linkLabel;
        return $this;
    }
}
