<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomRecordTypeChildrenList StructType
 * @subpackage Structs
 */
class CustomRecordTypeChildrenList extends AbstractStructBase
{
    /**
     * The children
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomRecordTypeChildren[]
     */
    public $children;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CustomRecordTypeChildrenList
     * @uses CustomRecordTypeChildrenList::setChildren()
     * @uses CustomRecordTypeChildrenList::setReplaceAll()
     * @param \StructType\CustomRecordTypeChildren[] $children
     * @param bool $replaceAll
     */
    public function __construct(array $children = array(), $replaceAll = true)
    {
        $this
            ->setChildren($children)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get children value
     * @return \StructType\CustomRecordTypeChildren[]|null
     */
    public function getChildren()
    {
        return $this->children;
    }
    /**
     * This method is responsible for validating the values passed to the setChildren method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChildren method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChildrenForArrayConstraintsFromSetChildren(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customRecordTypeChildrenListChildrenItem) {
            // validation for constraint: itemType
            if (!$customRecordTypeChildrenListChildrenItem instanceof \StructType\CustomRecordTypeChildren) {
                $invalidValues[] = is_object($customRecordTypeChildrenListChildrenItem) ? get_class($customRecordTypeChildrenListChildrenItem) : sprintf('%s(%s)', gettype($customRecordTypeChildrenListChildrenItem), var_export($customRecordTypeChildrenListChildrenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The children property can only contain items of type \StructType\CustomRecordTypeChildren, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set children value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordTypeChildren[] $children
     * @return \StructType\CustomRecordTypeChildrenList
     */
    public function setChildren(array $children = array())
    {
        // validation for constraint: array
        if ('' !== ($childrenArrayErrorMessage = self::validateChildrenForArrayConstraintsFromSetChildren($children))) {
            throw new \InvalidArgumentException($childrenArrayErrorMessage, __LINE__);
        }
        $this->children = $children;
        return $this;
    }
    /**
     * Add item to children value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomRecordTypeChildren $item
     * @return \StructType\CustomRecordTypeChildrenList
     */
    public function addToChildren(\StructType\CustomRecordTypeChildren $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomRecordTypeChildren) {
            throw new \InvalidArgumentException(sprintf('The children property can only contain items of type \StructType\CustomRecordTypeChildren, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->children[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CustomRecordTypeChildrenList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
