<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomPurchase StructType
 * @subpackage Structs
 */
class CustomPurchase extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The tranType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $tranType;
    /**
     * The nexus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nexus;
    /**
     * The subsidiaryTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiaryTaxRegNum;
    /**
     * The taxRegOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxRegOverride;
    /**
     * The taxDetailsOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxDetailsOverride;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The billAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billAddressList;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The currencyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currencyName;
    /**
     * The billingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $billingAddress;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The entityTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entityTaxRegNum;
    /**
     * The terms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $terms;
    /**
     * The dueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dueDate;
    /**
     * The discountDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $discountDate;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The createdFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createdFrom;
    /**
     * The userTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $userTotal;
    /**
     * The discountAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountAmount;
    /**
     * The taxTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxTotal;
    /**
     * The paymentHold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $paymentHold;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The tranStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $tranStatus;
    /**
     * The availableVendorCredit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $availableVendorCredit;
    /**
     * The landedCostMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $landedCostMethod;
    /**
     * The landedCostPerLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $landedCostPerLine;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The incoterm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $incoterm;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The transactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transactionNumber;
    /**
     * The overrideInstallments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $overrideInstallments;
    /**
     * The installmentList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InstallmentList
     */
    public $installmentList;
    /**
     * The expenseList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomPurchaseExpenseList
     */
    public $expenseList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The itemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomPurchaseItemList
     */
    public $itemList;
    /**
     * The landedCostsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PurchLandedCostList
     */
    public $landedCostsList;
    /**
     * The purchaseOrderList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $purchaseOrderList;
    /**
     * The taxDetailsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxDetailsList
     */
    public $taxDetailsList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for CustomPurchase
     * @uses CustomPurchase::setCreatedDate()
     * @uses CustomPurchase::setLastModifiedDate()
     * @uses CustomPurchase::setTranType()
     * @uses CustomPurchase::setNexus()
     * @uses CustomPurchase::setSubsidiaryTaxRegNum()
     * @uses CustomPurchase::setTaxRegOverride()
     * @uses CustomPurchase::setTaxDetailsOverride()
     * @uses CustomPurchase::setCustomForm()
     * @uses CustomPurchase::setBillAddressList()
     * @uses CustomPurchase::setAccount()
     * @uses CustomPurchase::setEntity()
     * @uses CustomPurchase::setSubsidiary()
     * @uses CustomPurchase::setPostingPeriod()
     * @uses CustomPurchase::setTranDate()
     * @uses CustomPurchase::setCurrencyName()
     * @uses CustomPurchase::setBillingAddress()
     * @uses CustomPurchase::setExchangeRate()
     * @uses CustomPurchase::setEntityTaxRegNum()
     * @uses CustomPurchase::setTerms()
     * @uses CustomPurchase::setDueDate()
     * @uses CustomPurchase::setDiscountDate()
     * @uses CustomPurchase::setTranId()
     * @uses CustomPurchase::setCreatedFrom()
     * @uses CustomPurchase::setUserTotal()
     * @uses CustomPurchase::setDiscountAmount()
     * @uses CustomPurchase::setTaxTotal()
     * @uses CustomPurchase::setPaymentHold()
     * @uses CustomPurchase::setMemo()
     * @uses CustomPurchase::setTranStatus()
     * @uses CustomPurchase::setAvailableVendorCredit()
     * @uses CustomPurchase::setLandedCostMethod()
     * @uses CustomPurchase::setLandedCostPerLine()
     * @uses CustomPurchase::setCurrency()
     * @uses CustomPurchase::setIncoterm()
     * @uses CustomPurchase::setClass()
     * @uses CustomPurchase::setDepartment()
     * @uses CustomPurchase::setLocation()
     * @uses CustomPurchase::setStatus()
     * @uses CustomPurchase::setTransactionNumber()
     * @uses CustomPurchase::setOverrideInstallments()
     * @uses CustomPurchase::setInstallmentList()
     * @uses CustomPurchase::setExpenseList()
     * @uses CustomPurchase::setAccountingBookDetailList()
     * @uses CustomPurchase::setItemList()
     * @uses CustomPurchase::setLandedCostsList()
     * @uses CustomPurchase::setPurchaseOrderList()
     * @uses CustomPurchase::setTaxDetailsList()
     * @uses CustomPurchase::setCustomFieldList()
     * @uses CustomPurchase::setInternalId()
     * @uses CustomPurchase::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $tranType
     * @param \StructType\RecordRef $nexus
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @param bool $taxRegOverride
     * @param bool $taxDetailsOverride
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $billAddressList
     * @param \StructType\RecordRef $account
     * @param \StructType\RecordRef $entity
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $postingPeriod
     * @param string $tranDate
     * @param string $currencyName
     * @param \StructType\Address $billingAddress
     * @param float $exchangeRate
     * @param \StructType\RecordRef $entityTaxRegNum
     * @param \StructType\RecordRef $terms
     * @param string $dueDate
     * @param string $discountDate
     * @param string $tranId
     * @param \StructType\RecordRef $createdFrom
     * @param float $userTotal
     * @param float $discountAmount
     * @param float $taxTotal
     * @param bool $paymentHold
     * @param string $memo
     * @param \StructType\RecordRef $tranStatus
     * @param float $availableVendorCredit
     * @param string $landedCostMethod
     * @param bool $landedCostPerLine
     * @param \StructType\RecordRef $currency
     * @param \StructType\RecordRef $incoterm
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $location
     * @param string $status
     * @param string $transactionNumber
     * @param bool $overrideInstallments
     * @param \StructType\InstallmentList $installmentList
     * @param \StructType\CustomPurchaseExpenseList $expenseList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\CustomPurchaseItemList $itemList
     * @param \StructType\PurchLandedCostList $landedCostsList
     * @param \StructType\RecordRefList $purchaseOrderList
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $tranType = null, \StructType\RecordRef $nexus = null, \StructType\RecordRef $subsidiaryTaxRegNum = null, $taxRegOverride = null, $taxDetailsOverride = null, \StructType\RecordRef $customForm = null, \StructType\RecordRef $billAddressList = null, \StructType\RecordRef $account = null, \StructType\RecordRef $entity = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $postingPeriod = null, $tranDate = null, $currencyName = null, \StructType\Address $billingAddress = null, $exchangeRate = null, \StructType\RecordRef $entityTaxRegNum = null, \StructType\RecordRef $terms = null, $dueDate = null, $discountDate = null, $tranId = null, \StructType\RecordRef $createdFrom = null, $userTotal = null, $discountAmount = null, $taxTotal = null, $paymentHold = null, $memo = null, \StructType\RecordRef $tranStatus = null, $availableVendorCredit = null, $landedCostMethod = null, $landedCostPerLine = null, \StructType\RecordRef $currency = null, \StructType\RecordRef $incoterm = null, \StructType\RecordRef $class = null, \StructType\RecordRef $department = null, \StructType\RecordRef $location = null, $status = null, $transactionNumber = null, $overrideInstallments = null, \StructType\InstallmentList $installmentList = null, \StructType\CustomPurchaseExpenseList $expenseList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\CustomPurchaseItemList $itemList = null, \StructType\PurchLandedCostList $landedCostsList = null, \StructType\RecordRefList $purchaseOrderList = null, \StructType\TaxDetailsList $taxDetailsList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setTranType($tranType)
            ->setNexus($nexus)
            ->setSubsidiaryTaxRegNum($subsidiaryTaxRegNum)
            ->setTaxRegOverride($taxRegOverride)
            ->setTaxDetailsOverride($taxDetailsOverride)
            ->setCustomForm($customForm)
            ->setBillAddressList($billAddressList)
            ->setAccount($account)
            ->setEntity($entity)
            ->setSubsidiary($subsidiary)
            ->setPostingPeriod($postingPeriod)
            ->setTranDate($tranDate)
            ->setCurrencyName($currencyName)
            ->setBillingAddress($billingAddress)
            ->setExchangeRate($exchangeRate)
            ->setEntityTaxRegNum($entityTaxRegNum)
            ->setTerms($terms)
            ->setDueDate($dueDate)
            ->setDiscountDate($discountDate)
            ->setTranId($tranId)
            ->setCreatedFrom($createdFrom)
            ->setUserTotal($userTotal)
            ->setDiscountAmount($discountAmount)
            ->setTaxTotal($taxTotal)
            ->setPaymentHold($paymentHold)
            ->setMemo($memo)
            ->setTranStatus($tranStatus)
            ->setAvailableVendorCredit($availableVendorCredit)
            ->setLandedCostMethod($landedCostMethod)
            ->setLandedCostPerLine($landedCostPerLine)
            ->setCurrency($currency)
            ->setIncoterm($incoterm)
            ->setClass($class)
            ->setDepartment($department)
            ->setLocation($location)
            ->setStatus($status)
            ->setTransactionNumber($transactionNumber)
            ->setOverrideInstallments($overrideInstallments)
            ->setInstallmentList($installmentList)
            ->setExpenseList($expenseList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setItemList($itemList)
            ->setLandedCostsList($landedCostsList)
            ->setPurchaseOrderList($purchaseOrderList)
            ->setTaxDetailsList($taxDetailsList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\CustomPurchase
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\CustomPurchase
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get tranType value
     * @return \StructType\RecordRef|null
     */
    public function getTranType()
    {
        return $this->tranType;
    }
    /**
     * Set tranType value
     * @param \StructType\RecordRef $tranType
     * @return \StructType\CustomPurchase
     */
    public function setTranType(\StructType\RecordRef $tranType = null)
    {
        $this->tranType = $tranType;
        return $this;
    }
    /**
     * Get nexus value
     * @return \StructType\RecordRef|null
     */
    public function getNexus()
    {
        return $this->nexus;
    }
    /**
     * Set nexus value
     * @param \StructType\RecordRef $nexus
     * @return \StructType\CustomPurchase
     */
    public function setNexus(\StructType\RecordRef $nexus = null)
    {
        $this->nexus = $nexus;
        return $this;
    }
    /**
     * Get subsidiaryTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiaryTaxRegNum()
    {
        return $this->subsidiaryTaxRegNum;
    }
    /**
     * Set subsidiaryTaxRegNum value
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @return \StructType\CustomPurchase
     */
    public function setSubsidiaryTaxRegNum(\StructType\RecordRef $subsidiaryTaxRegNum = null)
    {
        $this->subsidiaryTaxRegNum = $subsidiaryTaxRegNum;
        return $this;
    }
    /**
     * Get taxRegOverride value
     * @return bool|null
     */
    public function getTaxRegOverride()
    {
        return $this->taxRegOverride;
    }
    /**
     * Set taxRegOverride value
     * @param bool $taxRegOverride
     * @return \StructType\CustomPurchase
     */
    public function setTaxRegOverride($taxRegOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxRegOverride) && !is_bool($taxRegOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxRegOverride, true), gettype($taxRegOverride)), __LINE__);
        }
        $this->taxRegOverride = $taxRegOverride;
        return $this;
    }
    /**
     * Get taxDetailsOverride value
     * @return bool|null
     */
    public function getTaxDetailsOverride()
    {
        return $this->taxDetailsOverride;
    }
    /**
     * Set taxDetailsOverride value
     * @param bool $taxDetailsOverride
     * @return \StructType\CustomPurchase
     */
    public function setTaxDetailsOverride($taxDetailsOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxDetailsOverride) && !is_bool($taxDetailsOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxDetailsOverride, true), gettype($taxDetailsOverride)), __LINE__);
        }
        $this->taxDetailsOverride = $taxDetailsOverride;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\CustomPurchase
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get billAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getBillAddressList()
    {
        return $this->billAddressList;
    }
    /**
     * Set billAddressList value
     * @param \StructType\RecordRef $billAddressList
     * @return \StructType\CustomPurchase
     */
    public function setBillAddressList(\StructType\RecordRef $billAddressList = null)
    {
        $this->billAddressList = $billAddressList;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\CustomPurchase
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\CustomPurchase
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\CustomPurchase
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\CustomPurchase
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\CustomPurchase
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get currencyName value
     * @return string|null
     */
    public function getCurrencyName()
    {
        return $this->currencyName;
    }
    /**
     * Set currencyName value
     * @param string $currencyName
     * @return \StructType\CustomPurchase
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        $this->currencyName = $currencyName;
        return $this;
    }
    /**
     * Get billingAddress value
     * @return \StructType\Address|null
     */
    public function getBillingAddress()
    {
        return $this->billingAddress;
    }
    /**
     * Set billingAddress value
     * @param \StructType\Address $billingAddress
     * @return \StructType\CustomPurchase
     */
    public function setBillingAddress(\StructType\Address $billingAddress = null)
    {
        $this->billingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\CustomPurchase
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get entityTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getEntityTaxRegNum()
    {
        return $this->entityTaxRegNum;
    }
    /**
     * Set entityTaxRegNum value
     * @param \StructType\RecordRef $entityTaxRegNum
     * @return \StructType\CustomPurchase
     */
    public function setEntityTaxRegNum(\StructType\RecordRef $entityTaxRegNum = null)
    {
        $this->entityTaxRegNum = $entityTaxRegNum;
        return $this;
    }
    /**
     * Get terms value
     * @return \StructType\RecordRef|null
     */
    public function getTerms()
    {
        return $this->terms;
    }
    /**
     * Set terms value
     * @param \StructType\RecordRef $terms
     * @return \StructType\CustomPurchase
     */
    public function setTerms(\StructType\RecordRef $terms = null)
    {
        $this->terms = $terms;
        return $this;
    }
    /**
     * Get dueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }
    /**
     * Set dueDate value
     * @param string $dueDate
     * @return \StructType\CustomPurchase
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->dueDate = $dueDate;
        return $this;
    }
    /**
     * Get discountDate value
     * @return string|null
     */
    public function getDiscountDate()
    {
        return $this->discountDate;
    }
    /**
     * Set discountDate value
     * @param string $discountDate
     * @return \StructType\CustomPurchase
     */
    public function setDiscountDate($discountDate = null)
    {
        // validation for constraint: string
        if (!is_null($discountDate) && !is_string($discountDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountDate, true), gettype($discountDate)), __LINE__);
        }
        $this->discountDate = $discountDate;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\CustomPurchase
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get createdFrom value
     * @return \StructType\RecordRef|null
     */
    public function getCreatedFrom()
    {
        return $this->createdFrom;
    }
    /**
     * Set createdFrom value
     * @param \StructType\RecordRef $createdFrom
     * @return \StructType\CustomPurchase
     */
    public function setCreatedFrom(\StructType\RecordRef $createdFrom = null)
    {
        $this->createdFrom = $createdFrom;
        return $this;
    }
    /**
     * Get userTotal value
     * @return float|null
     */
    public function getUserTotal()
    {
        return $this->userTotal;
    }
    /**
     * Set userTotal value
     * @param float $userTotal
     * @return \StructType\CustomPurchase
     */
    public function setUserTotal($userTotal = null)
    {
        // validation for constraint: float
        if (!is_null($userTotal) && !(is_float($userTotal) || is_numeric($userTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($userTotal, true), gettype($userTotal)), __LINE__);
        }
        $this->userTotal = $userTotal;
        return $this;
    }
    /**
     * Get discountAmount value
     * @return float|null
     */
    public function getDiscountAmount()
    {
        return $this->discountAmount;
    }
    /**
     * Set discountAmount value
     * @param float $discountAmount
     * @return \StructType\CustomPurchase
     */
    public function setDiscountAmount($discountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($discountAmount) && !(is_float($discountAmount) || is_numeric($discountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountAmount, true), gettype($discountAmount)), __LINE__);
        }
        $this->discountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get taxTotal value
     * @return float|null
     */
    public function getTaxTotal()
    {
        return $this->taxTotal;
    }
    /**
     * Set taxTotal value
     * @param float $taxTotal
     * @return \StructType\CustomPurchase
     */
    public function setTaxTotal($taxTotal = null)
    {
        // validation for constraint: float
        if (!is_null($taxTotal) && !(is_float($taxTotal) || is_numeric($taxTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxTotal, true), gettype($taxTotal)), __LINE__);
        }
        $this->taxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get paymentHold value
     * @return bool|null
     */
    public function getPaymentHold()
    {
        return $this->paymentHold;
    }
    /**
     * Set paymentHold value
     * @param bool $paymentHold
     * @return \StructType\CustomPurchase
     */
    public function setPaymentHold($paymentHold = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentHold) && !is_bool($paymentHold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paymentHold, true), gettype($paymentHold)), __LINE__);
        }
        $this->paymentHold = $paymentHold;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\CustomPurchase
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get tranStatus value
     * @return \StructType\RecordRef|null
     */
    public function getTranStatus()
    {
        return $this->tranStatus;
    }
    /**
     * Set tranStatus value
     * @param \StructType\RecordRef $tranStatus
     * @return \StructType\CustomPurchase
     */
    public function setTranStatus(\StructType\RecordRef $tranStatus = null)
    {
        $this->tranStatus = $tranStatus;
        return $this;
    }
    /**
     * Get availableVendorCredit value
     * @return float|null
     */
    public function getAvailableVendorCredit()
    {
        return $this->availableVendorCredit;
    }
    /**
     * Set availableVendorCredit value
     * @param float $availableVendorCredit
     * @return \StructType\CustomPurchase
     */
    public function setAvailableVendorCredit($availableVendorCredit = null)
    {
        // validation for constraint: float
        if (!is_null($availableVendorCredit) && !(is_float($availableVendorCredit) || is_numeric($availableVendorCredit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($availableVendorCredit, true), gettype($availableVendorCredit)), __LINE__);
        }
        $this->availableVendorCredit = $availableVendorCredit;
        return $this;
    }
    /**
     * Get landedCostMethod value
     * @return string|null
     */
    public function getLandedCostMethod()
    {
        return $this->landedCostMethod;
    }
    /**
     * Set landedCostMethod value
     * @uses \EnumType\LandedCostMethod::valueIsValid()
     * @uses \EnumType\LandedCostMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $landedCostMethod
     * @return \StructType\CustomPurchase
     */
    public function setLandedCostMethod($landedCostMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LandedCostMethod::valueIsValid($landedCostMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LandedCostMethod', is_array($landedCostMethod) ? implode(', ', $landedCostMethod) : var_export($landedCostMethod, true), implode(', ', \EnumType\LandedCostMethod::getValidValues())), __LINE__);
        }
        $this->landedCostMethod = $landedCostMethod;
        return $this;
    }
    /**
     * Get landedCostPerLine value
     * @return bool|null
     */
    public function getLandedCostPerLine()
    {
        return $this->landedCostPerLine;
    }
    /**
     * Set landedCostPerLine value
     * @param bool $landedCostPerLine
     * @return \StructType\CustomPurchase
     */
    public function setLandedCostPerLine($landedCostPerLine = null)
    {
        // validation for constraint: boolean
        if (!is_null($landedCostPerLine) && !is_bool($landedCostPerLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($landedCostPerLine, true), gettype($landedCostPerLine)), __LINE__);
        }
        $this->landedCostPerLine = $landedCostPerLine;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\CustomPurchase
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get incoterm value
     * @return \StructType\RecordRef|null
     */
    public function getIncoterm()
    {
        return $this->incoterm;
    }
    /**
     * Set incoterm value
     * @param \StructType\RecordRef $incoterm
     * @return \StructType\CustomPurchase
     */
    public function setIncoterm(\StructType\RecordRef $incoterm = null)
    {
        $this->incoterm = $incoterm;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\CustomPurchase
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\CustomPurchase
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\CustomPurchase
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\CustomPurchase
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get transactionNumber value
     * @return string|null
     */
    public function getTransactionNumber()
    {
        return $this->transactionNumber;
    }
    /**
     * Set transactionNumber value
     * @param string $transactionNumber
     * @return \StructType\CustomPurchase
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNumber) && !is_string($transactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        $this->transactionNumber = $transactionNumber;
        return $this;
    }
    /**
     * Get overrideInstallments value
     * @return bool|null
     */
    public function getOverrideInstallments()
    {
        return $this->overrideInstallments;
    }
    /**
     * Set overrideInstallments value
     * @param bool $overrideInstallments
     * @return \StructType\CustomPurchase
     */
    public function setOverrideInstallments($overrideInstallments = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideInstallments) && !is_bool($overrideInstallments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideInstallments, true), gettype($overrideInstallments)), __LINE__);
        }
        $this->overrideInstallments = $overrideInstallments;
        return $this;
    }
    /**
     * Get installmentList value
     * @return \StructType\InstallmentList|null
     */
    public function getInstallmentList()
    {
        return $this->installmentList;
    }
    /**
     * Set installmentList value
     * @param \StructType\InstallmentList $installmentList
     * @return \StructType\CustomPurchase
     */
    public function setInstallmentList(\StructType\InstallmentList $installmentList = null)
    {
        $this->installmentList = $installmentList;
        return $this;
    }
    /**
     * Get expenseList value
     * @return \StructType\CustomPurchaseExpenseList|null
     */
    public function getExpenseList()
    {
        return $this->expenseList;
    }
    /**
     * Set expenseList value
     * @param \StructType\CustomPurchaseExpenseList $expenseList
     * @return \StructType\CustomPurchase
     */
    public function setExpenseList(\StructType\CustomPurchaseExpenseList $expenseList = null)
    {
        $this->expenseList = $expenseList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\CustomPurchase
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get itemList value
     * @return \StructType\CustomPurchaseItemList|null
     */
    public function getItemList()
    {
        return $this->itemList;
    }
    /**
     * Set itemList value
     * @param \StructType\CustomPurchaseItemList $itemList
     * @return \StructType\CustomPurchase
     */
    public function setItemList(\StructType\CustomPurchaseItemList $itemList = null)
    {
        $this->itemList = $itemList;
        return $this;
    }
    /**
     * Get landedCostsList value
     * @return \StructType\PurchLandedCostList|null
     */
    public function getLandedCostsList()
    {
        return $this->landedCostsList;
    }
    /**
     * Set landedCostsList value
     * @param \StructType\PurchLandedCostList $landedCostsList
     * @return \StructType\CustomPurchase
     */
    public function setLandedCostsList(\StructType\PurchLandedCostList $landedCostsList = null)
    {
        $this->landedCostsList = $landedCostsList;
        return $this;
    }
    /**
     * Get purchaseOrderList value
     * @return \StructType\RecordRefList|null
     */
    public function getPurchaseOrderList()
    {
        return $this->purchaseOrderList;
    }
    /**
     * Set purchaseOrderList value
     * @param \StructType\RecordRefList $purchaseOrderList
     * @return \StructType\CustomPurchase
     */
    public function setPurchaseOrderList(\StructType\RecordRefList $purchaseOrderList = null)
    {
        $this->purchaseOrderList = $purchaseOrderList;
        return $this;
    }
    /**
     * Get taxDetailsList value
     * @return \StructType\TaxDetailsList|null
     */
    public function getTaxDetailsList()
    {
        return $this->taxDetailsList;
    }
    /**
     * Set taxDetailsList value
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @return \StructType\CustomPurchase
     */
    public function setTaxDetailsList(\StructType\TaxDetailsList $taxDetailsList = null)
    {
        $this->taxDetailsList = $taxDetailsList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\CustomPurchase
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CustomPurchase
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\CustomPurchase
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
