<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyRateFilter StructType
 * @subpackage Structs
 */
class CurrencyRateFilter extends AbstractStructBase
{
    /**
     * The baseCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $baseCurrency;
    /**
     * The fromCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $fromCurrency;
    /**
     * The effectiveDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $effectiveDate;
    /**
     * Constructor method for CurrencyRateFilter
     * @uses CurrencyRateFilter::setBaseCurrency()
     * @uses CurrencyRateFilter::setFromCurrency()
     * @uses CurrencyRateFilter::setEffectiveDate()
     * @param \StructType\RecordRef $baseCurrency
     * @param \StructType\RecordRef $fromCurrency
     * @param string $effectiveDate
     */
    public function __construct(\StructType\RecordRef $baseCurrency = null, \StructType\RecordRef $fromCurrency = null, $effectiveDate = null)
    {
        $this
            ->setBaseCurrency($baseCurrency)
            ->setFromCurrency($fromCurrency)
            ->setEffectiveDate($effectiveDate);
    }
    /**
     * Get baseCurrency value
     * @return \StructType\RecordRef|null
     */
    public function getBaseCurrency()
    {
        return $this->baseCurrency;
    }
    /**
     * Set baseCurrency value
     * @param \StructType\RecordRef $baseCurrency
     * @return \StructType\CurrencyRateFilter
     */
    public function setBaseCurrency(\StructType\RecordRef $baseCurrency = null)
    {
        $this->baseCurrency = $baseCurrency;
        return $this;
    }
    /**
     * Get fromCurrency value
     * @return \StructType\RecordRef|null
     */
    public function getFromCurrency()
    {
        return $this->fromCurrency;
    }
    /**
     * Set fromCurrency value
     * @param \StructType\RecordRef $fromCurrency
     * @return \StructType\CurrencyRateFilter
     */
    public function setFromCurrency(\StructType\RecordRef $fromCurrency = null)
    {
        $this->fromCurrency = $fromCurrency;
        return $this;
    }
    /**
     * Get effectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->effectiveDate;
    }
    /**
     * Set effectiveDate value
     * @param string $effectiveDate
     * @return \StructType\CurrencyRateFilter
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->effectiveDate = $effectiveDate;
        return $this;
    }
}
