<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Currency StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:Currency
 * @subpackage Structs
 */
class Currency extends Record
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The symbol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $symbol;
    /**
     * The isBaseCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isBaseCurrency;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The overrideCurrencyFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $overrideCurrencyFormat;
    /**
     * The displaySymbol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $displaySymbol;
    /**
     * The symbolPlacement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $symbolPlacement;
    /**
     * The locale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $locale;
    /**
     * The formatSample
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $formatSample;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The fxRateUpdateTimezone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fxRateUpdateTimezone;
    /**
     * The inclInFxRateUpdates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $inclInFxRateUpdates;
    /**
     * The currencyPrecision
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currencyPrecision;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Currency
     * @uses Currency::setName()
     * @uses Currency::setSymbol()
     * @uses Currency::setIsBaseCurrency()
     * @uses Currency::setIsInactive()
     * @uses Currency::setOverrideCurrencyFormat()
     * @uses Currency::setDisplaySymbol()
     * @uses Currency::setSymbolPlacement()
     * @uses Currency::setLocale()
     * @uses Currency::setFormatSample()
     * @uses Currency::setExchangeRate()
     * @uses Currency::setFxRateUpdateTimezone()
     * @uses Currency::setInclInFxRateUpdates()
     * @uses Currency::setCurrencyPrecision()
     * @uses Currency::setInternalId()
     * @uses Currency::setExternalId()
     * @param string $name
     * @param string $symbol
     * @param bool $isBaseCurrency
     * @param bool $isInactive
     * @param bool $overrideCurrencyFormat
     * @param string $displaySymbol
     * @param string $symbolPlacement
     * @param string $locale
     * @param string $formatSample
     * @param float $exchangeRate
     * @param string $fxRateUpdateTimezone
     * @param bool $inclInFxRateUpdates
     * @param string $currencyPrecision
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($name = null, $symbol = null, $isBaseCurrency = null, $isInactive = null, $overrideCurrencyFormat = null, $displaySymbol = null, $symbolPlacement = null, $locale = null, $formatSample = null, $exchangeRate = null, $fxRateUpdateTimezone = null, $inclInFxRateUpdates = null, $currencyPrecision = null, $internalId = null, $externalId = null)
    {
        $this
            ->setName($name)
            ->setSymbol($symbol)
            ->setIsBaseCurrency($isBaseCurrency)
            ->setIsInactive($isInactive)
            ->setOverrideCurrencyFormat($overrideCurrencyFormat)
            ->setDisplaySymbol($displaySymbol)
            ->setSymbolPlacement($symbolPlacement)
            ->setLocale($locale)
            ->setFormatSample($formatSample)
            ->setExchangeRate($exchangeRate)
            ->setFxRateUpdateTimezone($fxRateUpdateTimezone)
            ->setInclInFxRateUpdates($inclInFxRateUpdates)
            ->setCurrencyPrecision($currencyPrecision)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Currency
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get symbol value
     * @return string|null
     */
    public function getSymbol()
    {
        return $this->symbol;
    }
    /**
     * Set symbol value
     * @param string $symbol
     * @return \StructType\Currency
     */
    public function setSymbol($symbol = null)
    {
        // validation for constraint: string
        if (!is_null($symbol) && !is_string($symbol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($symbol, true), gettype($symbol)), __LINE__);
        }
        $this->symbol = $symbol;
        return $this;
    }
    /**
     * Get isBaseCurrency value
     * @return bool|null
     */
    public function getIsBaseCurrency()
    {
        return $this->isBaseCurrency;
    }
    /**
     * Set isBaseCurrency value
     * @param bool $isBaseCurrency
     * @return \StructType\Currency
     */
    public function setIsBaseCurrency($isBaseCurrency = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBaseCurrency) && !is_bool($isBaseCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBaseCurrency, true), gettype($isBaseCurrency)), __LINE__);
        }
        $this->isBaseCurrency = $isBaseCurrency;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\Currency
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get overrideCurrencyFormat value
     * @return bool|null
     */
    public function getOverrideCurrencyFormat()
    {
        return $this->overrideCurrencyFormat;
    }
    /**
     * Set overrideCurrencyFormat value
     * @param bool $overrideCurrencyFormat
     * @return \StructType\Currency
     */
    public function setOverrideCurrencyFormat($overrideCurrencyFormat = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideCurrencyFormat) && !is_bool($overrideCurrencyFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideCurrencyFormat, true), gettype($overrideCurrencyFormat)), __LINE__);
        }
        $this->overrideCurrencyFormat = $overrideCurrencyFormat;
        return $this;
    }
    /**
     * Get displaySymbol value
     * @return string|null
     */
    public function getDisplaySymbol()
    {
        return $this->displaySymbol;
    }
    /**
     * Set displaySymbol value
     * @param string $displaySymbol
     * @return \StructType\Currency
     */
    public function setDisplaySymbol($displaySymbol = null)
    {
        // validation for constraint: string
        if (!is_null($displaySymbol) && !is_string($displaySymbol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displaySymbol, true), gettype($displaySymbol)), __LINE__);
        }
        $this->displaySymbol = $displaySymbol;
        return $this;
    }
    /**
     * Get symbolPlacement value
     * @return string|null
     */
    public function getSymbolPlacement()
    {
        return $this->symbolPlacement;
    }
    /**
     * Set symbolPlacement value
     * @uses \EnumType\CurrencySymbolPlacement::valueIsValid()
     * @uses \EnumType\CurrencySymbolPlacement::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $symbolPlacement
     * @return \StructType\Currency
     */
    public function setSymbolPlacement($symbolPlacement = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CurrencySymbolPlacement::valueIsValid($symbolPlacement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CurrencySymbolPlacement', is_array($symbolPlacement) ? implode(', ', $symbolPlacement) : var_export($symbolPlacement, true), implode(', ', \EnumType\CurrencySymbolPlacement::getValidValues())), __LINE__);
        }
        $this->symbolPlacement = $symbolPlacement;
        return $this;
    }
    /**
     * Get locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->locale;
    }
    /**
     * Set locale value
     * @uses \EnumType\CurrencyLocale::valueIsValid()
     * @uses \EnumType\CurrencyLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $locale
     * @return \StructType\Currency
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CurrencyLocale::valueIsValid($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CurrencyLocale', is_array($locale) ? implode(', ', $locale) : var_export($locale, true), implode(', ', \EnumType\CurrencyLocale::getValidValues())), __LINE__);
        }
        $this->locale = $locale;
        return $this;
    }
    /**
     * Get formatSample value
     * @return string|null
     */
    public function getFormatSample()
    {
        return $this->formatSample;
    }
    /**
     * Set formatSample value
     * @param string $formatSample
     * @return \StructType\Currency
     */
    public function setFormatSample($formatSample = null)
    {
        // validation for constraint: string
        if (!is_null($formatSample) && !is_string($formatSample)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formatSample, true), gettype($formatSample)), __LINE__);
        }
        $this->formatSample = $formatSample;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\Currency
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get fxRateUpdateTimezone value
     * @return string|null
     */
    public function getFxRateUpdateTimezone()
    {
        return $this->fxRateUpdateTimezone;
    }
    /**
     * Set fxRateUpdateTimezone value
     * @uses \EnumType\CurrencyFxRateUpdateTimezone::valueIsValid()
     * @uses \EnumType\CurrencyFxRateUpdateTimezone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fxRateUpdateTimezone
     * @return \StructType\Currency
     */
    public function setFxRateUpdateTimezone($fxRateUpdateTimezone = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CurrencyFxRateUpdateTimezone::valueIsValid($fxRateUpdateTimezone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CurrencyFxRateUpdateTimezone', is_array($fxRateUpdateTimezone) ? implode(', ', $fxRateUpdateTimezone) : var_export($fxRateUpdateTimezone, true), implode(', ', \EnumType\CurrencyFxRateUpdateTimezone::getValidValues())), __LINE__);
        }
        $this->fxRateUpdateTimezone = $fxRateUpdateTimezone;
        return $this;
    }
    /**
     * Get inclInFxRateUpdates value
     * @return bool|null
     */
    public function getInclInFxRateUpdates()
    {
        return $this->inclInFxRateUpdates;
    }
    /**
     * Set inclInFxRateUpdates value
     * @param bool $inclInFxRateUpdates
     * @return \StructType\Currency
     */
    public function setInclInFxRateUpdates($inclInFxRateUpdates = null)
    {
        // validation for constraint: boolean
        if (!is_null($inclInFxRateUpdates) && !is_bool($inclInFxRateUpdates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inclInFxRateUpdates, true), gettype($inclInFxRateUpdates)), __LINE__);
        }
        $this->inclInFxRateUpdates = $inclInFxRateUpdates;
        return $this;
    }
    /**
     * Get currencyPrecision value
     * @return string|null
     */
    public function getCurrencyPrecision()
    {
        return $this->currencyPrecision;
    }
    /**
     * Set currencyPrecision value
     * @uses \EnumType\CurrencyCurrencyPrecision::valueIsValid()
     * @uses \EnumType\CurrencyCurrencyPrecision::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currencyPrecision
     * @return \StructType\Currency
     */
    public function setCurrencyPrecision($currencyPrecision = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CurrencyCurrencyPrecision::valueIsValid($currencyPrecision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CurrencyCurrencyPrecision', is_array($currencyPrecision) ? implode(', ', $currencyPrecision) : var_export($currencyPrecision, true), implode(', ', \EnumType\CurrencyCurrencyPrecision::getValidValues())), __LINE__);
        }
        $this->currencyPrecision = $currencyPrecision;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Currency
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Currency
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
