<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsolidatedExchangeRate StructType
 * @subpackage Structs
 */
class ConsolidatedExchangeRate extends Record
{
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postingPeriod;
    /**
     * The fromSubsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fromSubsidiary;
    /**
     * The fromCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fromCurrency;
    /**
     * The toSubsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $toSubsidiary;
    /**
     * The toCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $toCurrency;
    /**
     * The averageRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $averageRate;
    /**
     * The currentRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $currentRate;
    /**
     * The historicalRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $historicalRate;
    /**
     * The accountingBook
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountingBook;
    /**
     * The isPeriodClosed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isPeriodClosed;
    /**
     * The isDerived
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isDerived;
    /**
     * The isEliminationSubsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isEliminationSubsidiary;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for ConsolidatedExchangeRate
     * @uses ConsolidatedExchangeRate::setPostingPeriod()
     * @uses ConsolidatedExchangeRate::setFromSubsidiary()
     * @uses ConsolidatedExchangeRate::setFromCurrency()
     * @uses ConsolidatedExchangeRate::setToSubsidiary()
     * @uses ConsolidatedExchangeRate::setToCurrency()
     * @uses ConsolidatedExchangeRate::setAverageRate()
     * @uses ConsolidatedExchangeRate::setCurrentRate()
     * @uses ConsolidatedExchangeRate::setHistoricalRate()
     * @uses ConsolidatedExchangeRate::setAccountingBook()
     * @uses ConsolidatedExchangeRate::setIsPeriodClosed()
     * @uses ConsolidatedExchangeRate::setIsDerived()
     * @uses ConsolidatedExchangeRate::setIsEliminationSubsidiary()
     * @uses ConsolidatedExchangeRate::setInternalId()
     * @uses ConsolidatedExchangeRate::setExternalId()
     * @param string $postingPeriod
     * @param string $fromSubsidiary
     * @param string $fromCurrency
     * @param string $toSubsidiary
     * @param string $toCurrency
     * @param float $averageRate
     * @param float $currentRate
     * @param float $historicalRate
     * @param string $accountingBook
     * @param bool $isPeriodClosed
     * @param bool $isDerived
     * @param bool $isEliminationSubsidiary
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($postingPeriod = null, $fromSubsidiary = null, $fromCurrency = null, $toSubsidiary = null, $toCurrency = null, $averageRate = null, $currentRate = null, $historicalRate = null, $accountingBook = null, $isPeriodClosed = null, $isDerived = null, $isEliminationSubsidiary = null, $internalId = null, $externalId = null)
    {
        $this
            ->setPostingPeriod($postingPeriod)
            ->setFromSubsidiary($fromSubsidiary)
            ->setFromCurrency($fromCurrency)
            ->setToSubsidiary($toSubsidiary)
            ->setToCurrency($toCurrency)
            ->setAverageRate($averageRate)
            ->setCurrentRate($currentRate)
            ->setHistoricalRate($historicalRate)
            ->setAccountingBook($accountingBook)
            ->setIsPeriodClosed($isPeriodClosed)
            ->setIsDerived($isDerived)
            ->setIsEliminationSubsidiary($isEliminationSubsidiary)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get postingPeriod value
     * @return string|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param string $postingPeriod
     * @return \StructType\ConsolidatedExchangeRate
     */
    public function setPostingPeriod($postingPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($postingPeriod) && !is_string($postingPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postingPeriod, true), gettype($postingPeriod)), __LINE__);
        }
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get fromSubsidiary value
     * @return string|null
     */
    public function getFromSubsidiary()
    {
        return $this->fromSubsidiary;
    }
    /**
     * Set fromSubsidiary value
     * @param string $fromSubsidiary
     * @return \StructType\ConsolidatedExchangeRate
     */
    public function setFromSubsidiary($fromSubsidiary = null)
    {
        // validation for constraint: string
        if (!is_null($fromSubsidiary) && !is_string($fromSubsidiary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromSubsidiary, true), gettype($fromSubsidiary)), __LINE__);
        }
        $this->fromSubsidiary = $fromSubsidiary;
        return $this;
    }
    /**
     * Get fromCurrency value
     * @return string|null
     */
    public function getFromCurrency()
    {
        return $this->fromCurrency;
    }
    /**
     * Set fromCurrency value
     * @param string $fromCurrency
     * @return \StructType\ConsolidatedExchangeRate
     */
    public function setFromCurrency($fromCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($fromCurrency) && !is_string($fromCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromCurrency, true), gettype($fromCurrency)), __LINE__);
        }
        $this->fromCurrency = $fromCurrency;
        return $this;
    }
    /**
     * Get toSubsidiary value
     * @return string|null
     */
    public function getToSubsidiary()
    {
        return $this->toSubsidiary;
    }
    /**
     * Set toSubsidiary value
     * @param string $toSubsidiary
     * @return \StructType\ConsolidatedExchangeRate
     */
    public function setToSubsidiary($toSubsidiary = null)
    {
        // validation for constraint: string
        if (!is_null($toSubsidiary) && !is_string($toSubsidiary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toSubsidiary, true), gettype($toSubsidiary)), __LINE__);
        }
        $this->toSubsidiary = $toSubsidiary;
        return $this;
    }
    /**
     * Get toCurrency value
     * @return string|null
     */
    public function getToCurrency()
    {
        return $this->toCurrency;
    }
    /**
     * Set toCurrency value
     * @param string $toCurrency
     * @return \StructType\ConsolidatedExchangeRate
     */
    public function setToCurrency($toCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($toCurrency) && !is_string($toCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toCurrency, true), gettype($toCurrency)), __LINE__);
        }
        $this->toCurrency = $toCurrency;
        return $this;
    }
    /**
     * Get averageRate value
     * @return float|null
     */
    public function getAverageRate()
    {
        return $this->averageRate;
    }
    /**
     * Set averageRate value
     * @param float $averageRate
     * @return \StructType\ConsolidatedExchangeRate
     */
    public function setAverageRate($averageRate = null)
    {
        // validation for constraint: float
        if (!is_null($averageRate) && !(is_float($averageRate) || is_numeric($averageRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($averageRate, true), gettype($averageRate)), __LINE__);
        }
        $this->averageRate = $averageRate;
        return $this;
    }
    /**
     * Get currentRate value
     * @return float|null
     */
    public function getCurrentRate()
    {
        return $this->currentRate;
    }
    /**
     * Set currentRate value
     * @param float $currentRate
     * @return \StructType\ConsolidatedExchangeRate
     */
    public function setCurrentRate($currentRate = null)
    {
        // validation for constraint: float
        if (!is_null($currentRate) && !(is_float($currentRate) || is_numeric($currentRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currentRate, true), gettype($currentRate)), __LINE__);
        }
        $this->currentRate = $currentRate;
        return $this;
    }
    /**
     * Get historicalRate value
     * @return float|null
     */
    public function getHistoricalRate()
    {
        return $this->historicalRate;
    }
    /**
     * Set historicalRate value
     * @param float $historicalRate
     * @return \StructType\ConsolidatedExchangeRate
     */
    public function setHistoricalRate($historicalRate = null)
    {
        // validation for constraint: float
        if (!is_null($historicalRate) && !(is_float($historicalRate) || is_numeric($historicalRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($historicalRate, true), gettype($historicalRate)), __LINE__);
        }
        $this->historicalRate = $historicalRate;
        return $this;
    }
    /**
     * Get accountingBook value
     * @return string|null
     */
    public function getAccountingBook()
    {
        return $this->accountingBook;
    }
    /**
     * Set accountingBook value
     * @param string $accountingBook
     * @return \StructType\ConsolidatedExchangeRate
     */
    public function setAccountingBook($accountingBook = null)
    {
        // validation for constraint: string
        if (!is_null($accountingBook) && !is_string($accountingBook)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountingBook, true), gettype($accountingBook)), __LINE__);
        }
        $this->accountingBook = $accountingBook;
        return $this;
    }
    /**
     * Get isPeriodClosed value
     * @return bool|null
     */
    public function getIsPeriodClosed()
    {
        return $this->isPeriodClosed;
    }
    /**
     * Set isPeriodClosed value
     * @param bool $isPeriodClosed
     * @return \StructType\ConsolidatedExchangeRate
     */
    public function setIsPeriodClosed($isPeriodClosed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPeriodClosed) && !is_bool($isPeriodClosed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPeriodClosed, true), gettype($isPeriodClosed)), __LINE__);
        }
        $this->isPeriodClosed = $isPeriodClosed;
        return $this;
    }
    /**
     * Get isDerived value
     * @return bool|null
     */
    public function getIsDerived()
    {
        return $this->isDerived;
    }
    /**
     * Set isDerived value
     * @param bool $isDerived
     * @return \StructType\ConsolidatedExchangeRate
     */
    public function setIsDerived($isDerived = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDerived) && !is_bool($isDerived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDerived, true), gettype($isDerived)), __LINE__);
        }
        $this->isDerived = $isDerived;
        return $this;
    }
    /**
     * Get isEliminationSubsidiary value
     * @return bool|null
     */
    public function getIsEliminationSubsidiary()
    {
        return $this->isEliminationSubsidiary;
    }
    /**
     * Set isEliminationSubsidiary value
     * @param bool $isEliminationSubsidiary
     * @return \StructType\ConsolidatedExchangeRate
     */
    public function setIsEliminationSubsidiary($isEliminationSubsidiary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEliminationSubsidiary) && !is_bool($isEliminationSubsidiary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEliminationSubsidiary, true), gettype($isEliminationSubsidiary)), __LINE__);
        }
        $this->isEliminationSubsidiary = $isEliminationSubsidiary;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\ConsolidatedExchangeRate
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\ConsolidatedExchangeRate
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
