<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClassTranslationList StructType
 * @subpackage Structs
 */
class ClassTranslationList extends AbstractStructBase
{
    /**
     * The classTranslation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ClassTranslation[]
     */
    public $classTranslation;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for ClassTranslationList
     * @uses ClassTranslationList::setClassTranslation()
     * @uses ClassTranslationList::setReplaceAll()
     * @param \StructType\ClassTranslation[] $classTranslation
     * @param bool $replaceAll
     */
    public function __construct(array $classTranslation = array(), $replaceAll = true)
    {
        $this
            ->setClassTranslation($classTranslation)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get classTranslation value
     * @return \StructType\ClassTranslation[]|null
     */
    public function getClassTranslation()
    {
        return $this->classTranslation;
    }
    /**
     * This method is responsible for validating the values passed to the setClassTranslation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClassTranslation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClassTranslationForArrayConstraintsFromSetClassTranslation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $classTranslationListClassTranslationItem) {
            // validation for constraint: itemType
            if (!$classTranslationListClassTranslationItem instanceof \StructType\ClassTranslation) {
                $invalidValues[] = is_object($classTranslationListClassTranslationItem) ? get_class($classTranslationListClassTranslationItem) : sprintf('%s(%s)', gettype($classTranslationListClassTranslationItem), var_export($classTranslationListClassTranslationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The classTranslation property can only contain items of type \StructType\ClassTranslation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set classTranslation value
     * @throws \InvalidArgumentException
     * @param \StructType\ClassTranslation[] $classTranslation
     * @return \StructType\ClassTranslationList
     */
    public function setClassTranslation(array $classTranslation = array())
    {
        // validation for constraint: array
        if ('' !== ($classTranslationArrayErrorMessage = self::validateClassTranslationForArrayConstraintsFromSetClassTranslation($classTranslation))) {
            throw new \InvalidArgumentException($classTranslationArrayErrorMessage, __LINE__);
        }
        $this->classTranslation = $classTranslation;
        return $this;
    }
    /**
     * Add item to classTranslation value
     * @throws \InvalidArgumentException
     * @param \StructType\ClassTranslation $item
     * @return \StructType\ClassTranslationList
     */
    public function addToClassTranslation(\StructType\ClassTranslation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ClassTranslation) {
            throw new \InvalidArgumentException(sprintf('The classTranslation property can only contain items of type \StructType\ClassTranslation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->classTranslation[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\ClassTranslationList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
