<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Check StructType
 * Meta information extracted from the WSDL
 * - type: tranBank:Check
 * @subpackage Structs
 */
class Check extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $balance;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The voidJournal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $voidJournal;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The toBePrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBePrinted;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The taxTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxTotal;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The tax2Total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax2Total;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The userTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $userTotal;
    /**
     * The landedCostMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $landedCostMethod;
    /**
     * The landedCostPerLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $landedCostPerLine;
    /**
     * The transactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transactionNumber;
    /**
     * The expenseList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CheckExpenseList
     */
    public $expenseList;
    /**
     * The itemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CheckItemList
     */
    public $itemList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The landedCostsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CheckLandedCostList
     */
    public $landedCostsList;
    /**
     * The billPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $billPay;
    /**
     * The payeeAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $payeeAddressList;
    /**
     * The payeeAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $payeeAddress;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Check
     * @uses Check::setCreatedDate()
     * @uses Check::setLastModifiedDate()
     * @uses Check::setStatus()
     * @uses Check::setCustomForm()
     * @uses Check::setAccount()
     * @uses Check::setBalance()
     * @uses Check::setEntity()
     * @uses Check::setSubsidiary()
     * @uses Check::setPostingPeriod()
     * @uses Check::setTranDate()
     * @uses Check::setCurrency()
     * @uses Check::setVoidJournal()
     * @uses Check::setExchangeRate()
     * @uses Check::setToBePrinted()
     * @uses Check::setTranId()
     * @uses Check::setMemo()
     * @uses Check::setDepartment()
     * @uses Check::setTaxTotal()
     * @uses Check::setClass()
     * @uses Check::setTax2Total()
     * @uses Check::setLocation()
     * @uses Check::setUserTotal()
     * @uses Check::setLandedCostMethod()
     * @uses Check::setLandedCostPerLine()
     * @uses Check::setTransactionNumber()
     * @uses Check::setExpenseList()
     * @uses Check::setItemList()
     * @uses Check::setAccountingBookDetailList()
     * @uses Check::setLandedCostsList()
     * @uses Check::setBillPay()
     * @uses Check::setPayeeAddressList()
     * @uses Check::setPayeeAddress()
     * @uses Check::setCustomFieldList()
     * @uses Check::setInternalId()
     * @uses Check::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param string $status
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $account
     * @param float $balance
     * @param \StructType\RecordRef $entity
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $postingPeriod
     * @param string $tranDate
     * @param \StructType\RecordRef $currency
     * @param \StructType\RecordRef $voidJournal
     * @param float $exchangeRate
     * @param bool $toBePrinted
     * @param string $tranId
     * @param string $memo
     * @param \StructType\RecordRef $department
     * @param float $taxTotal
     * @param \StructType\RecordRef $class
     * @param float $tax2Total
     * @param \StructType\RecordRef $location
     * @param float $userTotal
     * @param string $landedCostMethod
     * @param bool $landedCostPerLine
     * @param string $transactionNumber
     * @param \StructType\CheckExpenseList $expenseList
     * @param \StructType\CheckItemList $itemList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\CheckLandedCostList $landedCostsList
     * @param bool $billPay
     * @param \StructType\RecordRef $payeeAddressList
     * @param \StructType\Address $payeeAddress
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, $status = null, \StructType\RecordRef $customForm = null, \StructType\RecordRef $account = null, $balance = null, \StructType\RecordRef $entity = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $postingPeriod = null, $tranDate = null, \StructType\RecordRef $currency = null, \StructType\RecordRef $voidJournal = null, $exchangeRate = null, $toBePrinted = null, $tranId = null, $memo = null, \StructType\RecordRef $department = null, $taxTotal = null, \StructType\RecordRef $class = null, $tax2Total = null, \StructType\RecordRef $location = null, $userTotal = null, $landedCostMethod = null, $landedCostPerLine = null, $transactionNumber = null, \StructType\CheckExpenseList $expenseList = null, \StructType\CheckItemList $itemList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\CheckLandedCostList $landedCostsList = null, $billPay = null, \StructType\RecordRef $payeeAddressList = null, \StructType\Address $payeeAddress = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setStatus($status)
            ->setCustomForm($customForm)
            ->setAccount($account)
            ->setBalance($balance)
            ->setEntity($entity)
            ->setSubsidiary($subsidiary)
            ->setPostingPeriod($postingPeriod)
            ->setTranDate($tranDate)
            ->setCurrency($currency)
            ->setVoidJournal($voidJournal)
            ->setExchangeRate($exchangeRate)
            ->setToBePrinted($toBePrinted)
            ->setTranId($tranId)
            ->setMemo($memo)
            ->setDepartment($department)
            ->setTaxTotal($taxTotal)
            ->setClass($class)
            ->setTax2Total($tax2Total)
            ->setLocation($location)
            ->setUserTotal($userTotal)
            ->setLandedCostMethod($landedCostMethod)
            ->setLandedCostPerLine($landedCostPerLine)
            ->setTransactionNumber($transactionNumber)
            ->setExpenseList($expenseList)
            ->setItemList($itemList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setLandedCostsList($landedCostsList)
            ->setBillPay($billPay)
            ->setPayeeAddressList($payeeAddressList)
            ->setPayeeAddress($payeeAddress)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\Check
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Check
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Check
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\Check
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\Check
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param float $balance
     * @return \StructType\Check
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\Check
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\Check
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\Check
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\Check
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\Check
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get voidJournal value
     * @return \StructType\RecordRef|null
     */
    public function getVoidJournal()
    {
        return $this->voidJournal;
    }
    /**
     * Set voidJournal value
     * @param \StructType\RecordRef $voidJournal
     * @return \StructType\Check
     */
    public function setVoidJournal(\StructType\RecordRef $voidJournal = null)
    {
        $this->voidJournal = $voidJournal;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\Check
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get toBePrinted value
     * @return bool|null
     */
    public function getToBePrinted()
    {
        return $this->toBePrinted;
    }
    /**
     * Set toBePrinted value
     * @param bool $toBePrinted
     * @return \StructType\Check
     */
    public function setToBePrinted($toBePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBePrinted) && !is_bool($toBePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBePrinted, true), gettype($toBePrinted)), __LINE__);
        }
        $this->toBePrinted = $toBePrinted;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\Check
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\Check
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\Check
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get taxTotal value
     * @return float|null
     */
    public function getTaxTotal()
    {
        return $this->taxTotal;
    }
    /**
     * Set taxTotal value
     * @param float $taxTotal
     * @return \StructType\Check
     */
    public function setTaxTotal($taxTotal = null)
    {
        // validation for constraint: float
        if (!is_null($taxTotal) && !(is_float($taxTotal) || is_numeric($taxTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxTotal, true), gettype($taxTotal)), __LINE__);
        }
        $this->taxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\Check
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get tax2Total value
     * @return float|null
     */
    public function getTax2Total()
    {
        return $this->tax2Total;
    }
    /**
     * Set tax2Total value
     * @param float $tax2Total
     * @return \StructType\Check
     */
    public function setTax2Total($tax2Total = null)
    {
        // validation for constraint: float
        if (!is_null($tax2Total) && !(is_float($tax2Total) || is_numeric($tax2Total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax2Total, true), gettype($tax2Total)), __LINE__);
        }
        $this->tax2Total = $tax2Total;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\Check
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get userTotal value
     * @return float|null
     */
    public function getUserTotal()
    {
        return $this->userTotal;
    }
    /**
     * Set userTotal value
     * @param float $userTotal
     * @return \StructType\Check
     */
    public function setUserTotal($userTotal = null)
    {
        // validation for constraint: float
        if (!is_null($userTotal) && !(is_float($userTotal) || is_numeric($userTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($userTotal, true), gettype($userTotal)), __LINE__);
        }
        $this->userTotal = $userTotal;
        return $this;
    }
    /**
     * Get landedCostMethod value
     * @return string|null
     */
    public function getLandedCostMethod()
    {
        return $this->landedCostMethod;
    }
    /**
     * Set landedCostMethod value
     * @uses \EnumType\LandedCostMethod::valueIsValid()
     * @uses \EnumType\LandedCostMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $landedCostMethod
     * @return \StructType\Check
     */
    public function setLandedCostMethod($landedCostMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LandedCostMethod::valueIsValid($landedCostMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LandedCostMethod', is_array($landedCostMethod) ? implode(', ', $landedCostMethod) : var_export($landedCostMethod, true), implode(', ', \EnumType\LandedCostMethod::getValidValues())), __LINE__);
        }
        $this->landedCostMethod = $landedCostMethod;
        return $this;
    }
    /**
     * Get landedCostPerLine value
     * @return bool|null
     */
    public function getLandedCostPerLine()
    {
        return $this->landedCostPerLine;
    }
    /**
     * Set landedCostPerLine value
     * @param bool $landedCostPerLine
     * @return \StructType\Check
     */
    public function setLandedCostPerLine($landedCostPerLine = null)
    {
        // validation for constraint: boolean
        if (!is_null($landedCostPerLine) && !is_bool($landedCostPerLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($landedCostPerLine, true), gettype($landedCostPerLine)), __LINE__);
        }
        $this->landedCostPerLine = $landedCostPerLine;
        return $this;
    }
    /**
     * Get transactionNumber value
     * @return string|null
     */
    public function getTransactionNumber()
    {
        return $this->transactionNumber;
    }
    /**
     * Set transactionNumber value
     * @param string $transactionNumber
     * @return \StructType\Check
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNumber) && !is_string($transactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        $this->transactionNumber = $transactionNumber;
        return $this;
    }
    /**
     * Get expenseList value
     * @return \StructType\CheckExpenseList|null
     */
    public function getExpenseList()
    {
        return $this->expenseList;
    }
    /**
     * Set expenseList value
     * @param \StructType\CheckExpenseList $expenseList
     * @return \StructType\Check
     */
    public function setExpenseList(\StructType\CheckExpenseList $expenseList = null)
    {
        $this->expenseList = $expenseList;
        return $this;
    }
    /**
     * Get itemList value
     * @return \StructType\CheckItemList|null
     */
    public function getItemList()
    {
        return $this->itemList;
    }
    /**
     * Set itemList value
     * @param \StructType\CheckItemList $itemList
     * @return \StructType\Check
     */
    public function setItemList(\StructType\CheckItemList $itemList = null)
    {
        $this->itemList = $itemList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\Check
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get landedCostsList value
     * @return \StructType\CheckLandedCostList|null
     */
    public function getLandedCostsList()
    {
        return $this->landedCostsList;
    }
    /**
     * Set landedCostsList value
     * @param \StructType\CheckLandedCostList $landedCostsList
     * @return \StructType\Check
     */
    public function setLandedCostsList(\StructType\CheckLandedCostList $landedCostsList = null)
    {
        $this->landedCostsList = $landedCostsList;
        return $this;
    }
    /**
     * Get billPay value
     * @return bool|null
     */
    public function getBillPay()
    {
        return $this->billPay;
    }
    /**
     * Set billPay value
     * @param bool $billPay
     * @return \StructType\Check
     */
    public function setBillPay($billPay = null)
    {
        // validation for constraint: boolean
        if (!is_null($billPay) && !is_bool($billPay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($billPay, true), gettype($billPay)), __LINE__);
        }
        $this->billPay = $billPay;
        return $this;
    }
    /**
     * Get payeeAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getPayeeAddressList()
    {
        return $this->payeeAddressList;
    }
    /**
     * Set payeeAddressList value
     * @param \StructType\RecordRef $payeeAddressList
     * @return \StructType\Check
     */
    public function setPayeeAddressList(\StructType\RecordRef $payeeAddressList = null)
    {
        $this->payeeAddressList = $payeeAddressList;
        return $this;
    }
    /**
     * Get payeeAddress value
     * @return \StructType\Address|null
     */
    public function getPayeeAddress()
    {
        return $this->payeeAddress;
    }
    /**
     * Set payeeAddress value
     * @param \StructType\Address $payeeAddress
     * @return \StructType\Check
     */
    public function setPayeeAddress(\StructType\Address $payeeAddress = null)
    {
        $this->payeeAddress = $payeeAddress;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\Check
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Check
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Check
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
