<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CashSaleTimeList StructType
 * @subpackage Structs
 */
class CashSaleTimeList extends AbstractStructBase
{
    /**
     * The time
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CashSaleTime[]
     */
    public $time;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CashSaleTimeList
     * @uses CashSaleTimeList::setTime()
     * @uses CashSaleTimeList::setReplaceAll()
     * @param \StructType\CashSaleTime[] $time
     * @param bool $replaceAll
     */
    public function __construct(array $time = array(), $replaceAll = true)
    {
        $this
            ->setTime($time)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get time value
     * @return \StructType\CashSaleTime[]|null
     */
    public function getTime()
    {
        return $this->time;
    }
    /**
     * This method is responsible for validating the values passed to the setTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTime method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTimeForArrayConstraintsFromSetTime(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cashSaleTimeListTimeItem) {
            // validation for constraint: itemType
            if (!$cashSaleTimeListTimeItem instanceof \StructType\CashSaleTime) {
                $invalidValues[] = is_object($cashSaleTimeListTimeItem) ? get_class($cashSaleTimeListTimeItem) : sprintf('%s(%s)', gettype($cashSaleTimeListTimeItem), var_export($cashSaleTimeListTimeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The time property can only contain items of type \StructType\CashSaleTime, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set time value
     * @throws \InvalidArgumentException
     * @param \StructType\CashSaleTime[] $time
     * @return \StructType\CashSaleTimeList
     */
    public function setTime(array $time = array())
    {
        // validation for constraint: array
        if ('' !== ($timeArrayErrorMessage = self::validateTimeForArrayConstraintsFromSetTime($time))) {
            throw new \InvalidArgumentException($timeArrayErrorMessage, __LINE__);
        }
        $this->time = $time;
        return $this;
    }
    /**
     * Add item to time value
     * @throws \InvalidArgumentException
     * @param \StructType\CashSaleTime $item
     * @return \StructType\CashSaleTimeList
     */
    public function addToTime(\StructType\CashSaleTime $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CashSaleTime) {
            throw new \InvalidArgumentException(sprintf('The time property can only contain items of type \StructType\CashSaleTime, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->time[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CashSaleTimeList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
