<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CashSaleSalesTeamList StructType
 * @subpackage Structs
 */
class CashSaleSalesTeamList extends AbstractStructBase
{
    /**
     * The salesTeam
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CashSaleSalesTeam[]
     */
    public $salesTeam;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CashSaleSalesTeamList
     * @uses CashSaleSalesTeamList::setSalesTeam()
     * @uses CashSaleSalesTeamList::setReplaceAll()
     * @param \StructType\CashSaleSalesTeam[] $salesTeam
     * @param bool $replaceAll
     */
    public function __construct(array $salesTeam = array(), $replaceAll = true)
    {
        $this
            ->setSalesTeam($salesTeam)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get salesTeam value
     * @return \StructType\CashSaleSalesTeam[]|null
     */
    public function getSalesTeam()
    {
        return $this->salesTeam;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesTeam method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesTeam method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesTeamForArrayConstraintsFromSetSalesTeam(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cashSaleSalesTeamListSalesTeamItem) {
            // validation for constraint: itemType
            if (!$cashSaleSalesTeamListSalesTeamItem instanceof \StructType\CashSaleSalesTeam) {
                $invalidValues[] = is_object($cashSaleSalesTeamListSalesTeamItem) ? get_class($cashSaleSalesTeamListSalesTeamItem) : sprintf('%s(%s)', gettype($cashSaleSalesTeamListSalesTeamItem), var_export($cashSaleSalesTeamListSalesTeamItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The salesTeam property can only contain items of type \StructType\CashSaleSalesTeam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set salesTeam value
     * @throws \InvalidArgumentException
     * @param \StructType\CashSaleSalesTeam[] $salesTeam
     * @return \StructType\CashSaleSalesTeamList
     */
    public function setSalesTeam(array $salesTeam = array())
    {
        // validation for constraint: array
        if ('' !== ($salesTeamArrayErrorMessage = self::validateSalesTeamForArrayConstraintsFromSetSalesTeam($salesTeam))) {
            throw new \InvalidArgumentException($salesTeamArrayErrorMessage, __LINE__);
        }
        $this->salesTeam = $salesTeam;
        return $this;
    }
    /**
     * Add item to salesTeam value
     * @throws \InvalidArgumentException
     * @param \StructType\CashSaleSalesTeam $item
     * @return \StructType\CashSaleSalesTeamList
     */
    public function addToSalesTeam(\StructType\CashSaleSalesTeam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CashSaleSalesTeam) {
            throw new \InvalidArgumentException(sprintf('The salesTeam property can only contain items of type \StructType\CashSaleSalesTeam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->salesTeam[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CashSaleSalesTeamList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
