<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CashRefundPartnersList StructType
 * @subpackage Structs
 */
class CashRefundPartnersList extends AbstractStructBase
{
    /**
     * The partners
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Partners[]
     */
    public $partners;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for CashRefundPartnersList
     * @uses CashRefundPartnersList::setPartners()
     * @uses CashRefundPartnersList::setReplaceAll()
     * @param \StructType\Partners[] $partners
     * @param bool $replaceAll
     */
    public function __construct(array $partners = array(), $replaceAll = true)
    {
        $this
            ->setPartners($partners)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get partners value
     * @return \StructType\Partners[]|null
     */
    public function getPartners()
    {
        return $this->partners;
    }
    /**
     * This method is responsible for validating the values passed to the setPartners method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartners method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartnersForArrayConstraintsFromSetPartners(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cashRefundPartnersListPartnersItem) {
            // validation for constraint: itemType
            if (!$cashRefundPartnersListPartnersItem instanceof \StructType\Partners) {
                $invalidValues[] = is_object($cashRefundPartnersListPartnersItem) ? get_class($cashRefundPartnersListPartnersItem) : sprintf('%s(%s)', gettype($cashRefundPartnersListPartnersItem), var_export($cashRefundPartnersListPartnersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The partners property can only contain items of type \StructType\Partners, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set partners value
     * @throws \InvalidArgumentException
     * @param \StructType\Partners[] $partners
     * @return \StructType\CashRefundPartnersList
     */
    public function setPartners(array $partners = array())
    {
        // validation for constraint: array
        if ('' !== ($partnersArrayErrorMessage = self::validatePartnersForArrayConstraintsFromSetPartners($partners))) {
            throw new \InvalidArgumentException($partnersArrayErrorMessage, __LINE__);
        }
        $this->partners = $partners;
        return $this;
    }
    /**
     * Add item to partners value
     * @throws \InvalidArgumentException
     * @param \StructType\Partners $item
     * @return \StructType\CashRefundPartnersList
     */
    public function addToPartners(\StructType\Partners $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Partners) {
            throw new \InvalidArgumentException(sprintf('The partners property can only contain items of type \StructType\Partners, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->partners[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\CashRefundPartnersList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
