<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CashRefundItem StructType
 * @subpackage Structs
 */
class CashRefundItem extends AbstractStructBase
{
    /**
     * The job
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $job;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The orderLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orderLine;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantity;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $units;
    /**
     * The inventoryDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventoryDetail
     */
    public $inventoryDetail;
    /**
     * The binNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $binNumbers;
    /**
     * The serialNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serialNumbers;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $price;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The taxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxCode;
    /**
     * The taxRate1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxRate1;
    /**
     * The taxRate2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxRate2;
    /**
     * The tax1Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax1Amt;
    /**
     * The grossAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmt;
    /**
     * The isTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isTaxable;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $options;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The revRecSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revRecSchedule;
    /**
     * The revRecStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revRecStartDate;
    /**
     * The revRecEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $revRecEndDate;
    /**
     * The catchUpPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $catchUpPeriod;
    /**
     * The deferRevRec
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deferRevRec;
    /**
     * The giftCertFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertFrom;
    /**
     * The costEstimateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costEstimateType;
    /**
     * The costEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $costEstimate;
    /**
     * The taxDetailsReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxDetailsReference;
    /**
     * The giftCertRecipientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertRecipientName;
    /**
     * The giftCertRecipientEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertRecipientEmail;
    /**
     * The giftCertMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertMessage;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxAmount;
    /**
     * The giftCertNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $giftCertNumber;
    /**
     * The vsoeSopGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeSopGroup;
    /**
     * The vsoeIsEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vsoeIsEstimate;
    /**
     * The vsoePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vsoePrice;
    /**
     * The vsoeAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vsoeAmount;
    /**
     * The vsoeAllocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vsoeAllocation;
    /**
     * The vsoeDeferral
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeDeferral;
    /**
     * The vsoePermitDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoePermitDiscount;
    /**
     * The vsoeDelivered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vsoeDelivered;
    /**
     * The chargeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $chargeType;
    /**
     * The chargesList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $chargesList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for CashRefundItem
     * @uses CashRefundItem::setJob()
     * @uses CashRefundItem::setItem()
     * @uses CashRefundItem::setLine()
     * @uses CashRefundItem::setOrderLine()
     * @uses CashRefundItem::setQuantity()
     * @uses CashRefundItem::setUnits()
     * @uses CashRefundItem::setInventoryDetail()
     * @uses CashRefundItem::setBinNumbers()
     * @uses CashRefundItem::setSerialNumbers()
     * @uses CashRefundItem::setDescription()
     * @uses CashRefundItem::setPrice()
     * @uses CashRefundItem::setRate()
     * @uses CashRefundItem::setAmount()
     * @uses CashRefundItem::setTaxCode()
     * @uses CashRefundItem::setTaxRate1()
     * @uses CashRefundItem::setTaxRate2()
     * @uses CashRefundItem::setTax1Amt()
     * @uses CashRefundItem::setGrossAmt()
     * @uses CashRefundItem::setIsTaxable()
     * @uses CashRefundItem::setOptions()
     * @uses CashRefundItem::setDepartment()
     * @uses CashRefundItem::setClass()
     * @uses CashRefundItem::setLocation()
     * @uses CashRefundItem::setRevRecSchedule()
     * @uses CashRefundItem::setRevRecStartDate()
     * @uses CashRefundItem::setRevRecEndDate()
     * @uses CashRefundItem::setCatchUpPeriod()
     * @uses CashRefundItem::setDeferRevRec()
     * @uses CashRefundItem::setGiftCertFrom()
     * @uses CashRefundItem::setCostEstimateType()
     * @uses CashRefundItem::setCostEstimate()
     * @uses CashRefundItem::setTaxDetailsReference()
     * @uses CashRefundItem::setGiftCertRecipientName()
     * @uses CashRefundItem::setGiftCertRecipientEmail()
     * @uses CashRefundItem::setGiftCertMessage()
     * @uses CashRefundItem::setTaxAmount()
     * @uses CashRefundItem::setGiftCertNumber()
     * @uses CashRefundItem::setVsoeSopGroup()
     * @uses CashRefundItem::setVsoeIsEstimate()
     * @uses CashRefundItem::setVsoePrice()
     * @uses CashRefundItem::setVsoeAmount()
     * @uses CashRefundItem::setVsoeAllocation()
     * @uses CashRefundItem::setVsoeDeferral()
     * @uses CashRefundItem::setVsoePermitDiscount()
     * @uses CashRefundItem::setVsoeDelivered()
     * @uses CashRefundItem::setChargeType()
     * @uses CashRefundItem::setChargesList()
     * @uses CashRefundItem::setCustomFieldList()
     * @param \StructType\RecordRef $job
     * @param \StructType\RecordRef $item
     * @param int $line
     * @param int $orderLine
     * @param float $quantity
     * @param \StructType\RecordRef $units
     * @param \StructType\InventoryDetail $inventoryDetail
     * @param string $binNumbers
     * @param string $serialNumbers
     * @param string $description
     * @param \StructType\RecordRef $price
     * @param string $rate
     * @param float $amount
     * @param \StructType\RecordRef $taxCode
     * @param string $taxRate1
     * @param string $taxRate2
     * @param float $tax1Amt
     * @param float $grossAmt
     * @param bool $isTaxable
     * @param \StructType\CustomFieldList $options
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $revRecSchedule
     * @param string $revRecStartDate
     * @param string $revRecEndDate
     * @param \StructType\RecordRef $catchUpPeriod
     * @param bool $deferRevRec
     * @param string $giftCertFrom
     * @param string $costEstimateType
     * @param float $costEstimate
     * @param string $taxDetailsReference
     * @param string $giftCertRecipientName
     * @param string $giftCertRecipientEmail
     * @param string $giftCertMessage
     * @param float $taxAmount
     * @param string $giftCertNumber
     * @param string $vsoeSopGroup
     * @param bool $vsoeIsEstimate
     * @param float $vsoePrice
     * @param float $vsoeAmount
     * @param float $vsoeAllocation
     * @param string $vsoeDeferral
     * @param string $vsoePermitDiscount
     * @param bool $vsoeDelivered
     * @param \StructType\RecordRef $chargeType
     * @param \StructType\RecordRefList $chargesList
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct(\StructType\RecordRef $job = null, \StructType\RecordRef $item = null, $line = null, $orderLine = null, $quantity = null, \StructType\RecordRef $units = null, \StructType\InventoryDetail $inventoryDetail = null, $binNumbers = null, $serialNumbers = null, $description = null, \StructType\RecordRef $price = null, $rate = null, $amount = null, \StructType\RecordRef $taxCode = null, $taxRate1 = null, $taxRate2 = null, $tax1Amt = null, $grossAmt = null, $isTaxable = null, \StructType\CustomFieldList $options = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $revRecSchedule = null, $revRecStartDate = null, $revRecEndDate = null, \StructType\RecordRef $catchUpPeriod = null, $deferRevRec = null, $giftCertFrom = null, $costEstimateType = null, $costEstimate = null, $taxDetailsReference = null, $giftCertRecipientName = null, $giftCertRecipientEmail = null, $giftCertMessage = null, $taxAmount = null, $giftCertNumber = null, $vsoeSopGroup = null, $vsoeIsEstimate = null, $vsoePrice = null, $vsoeAmount = null, $vsoeAllocation = null, $vsoeDeferral = null, $vsoePermitDiscount = null, $vsoeDelivered = null, \StructType\RecordRef $chargeType = null, \StructType\RecordRefList $chargesList = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setJob($job)
            ->setItem($item)
            ->setLine($line)
            ->setOrderLine($orderLine)
            ->setQuantity($quantity)
            ->setUnits($units)
            ->setInventoryDetail($inventoryDetail)
            ->setBinNumbers($binNumbers)
            ->setSerialNumbers($serialNumbers)
            ->setDescription($description)
            ->setPrice($price)
            ->setRate($rate)
            ->setAmount($amount)
            ->setTaxCode($taxCode)
            ->setTaxRate1($taxRate1)
            ->setTaxRate2($taxRate2)
            ->setTax1Amt($tax1Amt)
            ->setGrossAmt($grossAmt)
            ->setIsTaxable($isTaxable)
            ->setOptions($options)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setRevRecSchedule($revRecSchedule)
            ->setRevRecStartDate($revRecStartDate)
            ->setRevRecEndDate($revRecEndDate)
            ->setCatchUpPeriod($catchUpPeriod)
            ->setDeferRevRec($deferRevRec)
            ->setGiftCertFrom($giftCertFrom)
            ->setCostEstimateType($costEstimateType)
            ->setCostEstimate($costEstimate)
            ->setTaxDetailsReference($taxDetailsReference)
            ->setGiftCertRecipientName($giftCertRecipientName)
            ->setGiftCertRecipientEmail($giftCertRecipientEmail)
            ->setGiftCertMessage($giftCertMessage)
            ->setTaxAmount($taxAmount)
            ->setGiftCertNumber($giftCertNumber)
            ->setVsoeSopGroup($vsoeSopGroup)
            ->setVsoeIsEstimate($vsoeIsEstimate)
            ->setVsoePrice($vsoePrice)
            ->setVsoeAmount($vsoeAmount)
            ->setVsoeAllocation($vsoeAllocation)
            ->setVsoeDeferral($vsoeDeferral)
            ->setVsoePermitDiscount($vsoePermitDiscount)
            ->setVsoeDelivered($vsoeDelivered)
            ->setChargeType($chargeType)
            ->setChargesList($chargesList)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get job value
     * @return \StructType\RecordRef|null
     */
    public function getJob()
    {
        return $this->job;
    }
    /**
     * Set job value
     * @param \StructType\RecordRef $job
     * @return \StructType\CashRefundItem
     */
    public function setJob(\StructType\RecordRef $job = null)
    {
        $this->job = $job;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\CashRefundItem
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\CashRefundItem
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get orderLine value
     * @return int|null
     */
    public function getOrderLine()
    {
        return $this->orderLine;
    }
    /**
     * Set orderLine value
     * @param int $orderLine
     * @return \StructType\CashRefundItem
     */
    public function setOrderLine($orderLine = null)
    {
        // validation for constraint: int
        if (!is_null($orderLine) && !(is_int($orderLine) || ctype_digit($orderLine))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderLine, true), gettype($orderLine)), __LINE__);
        }
        $this->orderLine = $orderLine;
        return $this;
    }
    /**
     * Get quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param float $quantity
     * @return \StructType\CashRefundItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\RecordRef|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\RecordRef $units
     * @return \StructType\CashRefundItem
     */
    public function setUnits(\StructType\RecordRef $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get inventoryDetail value
     * @return \StructType\InventoryDetail|null
     */
    public function getInventoryDetail()
    {
        return $this->inventoryDetail;
    }
    /**
     * Set inventoryDetail value
     * @param \StructType\InventoryDetail $inventoryDetail
     * @return \StructType\CashRefundItem
     */
    public function setInventoryDetail(\StructType\InventoryDetail $inventoryDetail = null)
    {
        $this->inventoryDetail = $inventoryDetail;
        return $this;
    }
    /**
     * Get binNumbers value
     * @return string|null
     */
    public function getBinNumbers()
    {
        return $this->binNumbers;
    }
    /**
     * Set binNumbers value
     * @param string $binNumbers
     * @return \StructType\CashRefundItem
     */
    public function setBinNumbers($binNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($binNumbers) && !is_string($binNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binNumbers, true), gettype($binNumbers)), __LINE__);
        }
        $this->binNumbers = $binNumbers;
        return $this;
    }
    /**
     * Get serialNumbers value
     * @return string|null
     */
    public function getSerialNumbers()
    {
        return $this->serialNumbers;
    }
    /**
     * Set serialNumbers value
     * @param string $serialNumbers
     * @return \StructType\CashRefundItem
     */
    public function setSerialNumbers($serialNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumbers) && !is_string($serialNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumbers, true), gettype($serialNumbers)), __LINE__);
        }
        $this->serialNumbers = $serialNumbers;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CashRefundItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get price value
     * @return \StructType\RecordRef|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param \StructType\RecordRef $price
     * @return \StructType\CashRefundItem
     */
    public function setPrice(\StructType\RecordRef $price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \StructType\CashRefundItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\CashRefundItem
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get taxCode value
     * @return \StructType\RecordRef|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param \StructType\RecordRef $taxCode
     * @return \StructType\CashRefundItem
     */
    public function setTaxCode(\StructType\RecordRef $taxCode = null)
    {
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get taxRate1 value
     * @return string|null
     */
    public function getTaxRate1()
    {
        return $this->taxRate1;
    }
    /**
     * Set taxRate1 value
     * @param string $taxRate1
     * @return \StructType\CashRefundItem
     */
    public function setTaxRate1($taxRate1 = null)
    {
        // validation for constraint: string
        if (!is_null($taxRate1) && !is_string($taxRate1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxRate1, true), gettype($taxRate1)), __LINE__);
        }
        $this->taxRate1 = $taxRate1;
        return $this;
    }
    /**
     * Get taxRate2 value
     * @return string|null
     */
    public function getTaxRate2()
    {
        return $this->taxRate2;
    }
    /**
     * Set taxRate2 value
     * @param string $taxRate2
     * @return \StructType\CashRefundItem
     */
    public function setTaxRate2($taxRate2 = null)
    {
        // validation for constraint: string
        if (!is_null($taxRate2) && !is_string($taxRate2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxRate2, true), gettype($taxRate2)), __LINE__);
        }
        $this->taxRate2 = $taxRate2;
        return $this;
    }
    /**
     * Get tax1Amt value
     * @return float|null
     */
    public function getTax1Amt()
    {
        return $this->tax1Amt;
    }
    /**
     * Set tax1Amt value
     * @param float $tax1Amt
     * @return \StructType\CashRefundItem
     */
    public function setTax1Amt($tax1Amt = null)
    {
        // validation for constraint: float
        if (!is_null($tax1Amt) && !(is_float($tax1Amt) || is_numeric($tax1Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax1Amt, true), gettype($tax1Amt)), __LINE__);
        }
        $this->tax1Amt = $tax1Amt;
        return $this;
    }
    /**
     * Get grossAmt value
     * @return float|null
     */
    public function getGrossAmt()
    {
        return $this->grossAmt;
    }
    /**
     * Set grossAmt value
     * @param float $grossAmt
     * @return \StructType\CashRefundItem
     */
    public function setGrossAmt($grossAmt = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmt) && !(is_float($grossAmt) || is_numeric($grossAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmt, true), gettype($grossAmt)), __LINE__);
        }
        $this->grossAmt = $grossAmt;
        return $this;
    }
    /**
     * Get isTaxable value
     * @return bool|null
     */
    public function getIsTaxable()
    {
        return $this->isTaxable;
    }
    /**
     * Set isTaxable value
     * @param bool $isTaxable
     * @return \StructType\CashRefundItem
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTaxable, true), gettype($isTaxable)), __LINE__);
        }
        $this->isTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\CustomFieldList|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\CustomFieldList $options
     * @return \StructType\CashRefundItem
     */
    public function setOptions(\StructType\CustomFieldList $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\CashRefundItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\CashRefundItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\CashRefundItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get revRecSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getRevRecSchedule()
    {
        return $this->revRecSchedule;
    }
    /**
     * Set revRecSchedule value
     * @param \StructType\RecordRef $revRecSchedule
     * @return \StructType\CashRefundItem
     */
    public function setRevRecSchedule(\StructType\RecordRef $revRecSchedule = null)
    {
        $this->revRecSchedule = $revRecSchedule;
        return $this;
    }
    /**
     * Get revRecStartDate value
     * @return string|null
     */
    public function getRevRecStartDate()
    {
        return $this->revRecStartDate;
    }
    /**
     * Set revRecStartDate value
     * @param string $revRecStartDate
     * @return \StructType\CashRefundItem
     */
    public function setRevRecStartDate($revRecStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($revRecStartDate) && !is_string($revRecStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revRecStartDate, true), gettype($revRecStartDate)), __LINE__);
        }
        $this->revRecStartDate = $revRecStartDate;
        return $this;
    }
    /**
     * Get revRecEndDate value
     * @return string|null
     */
    public function getRevRecEndDate()
    {
        return $this->revRecEndDate;
    }
    /**
     * Set revRecEndDate value
     * @param string $revRecEndDate
     * @return \StructType\CashRefundItem
     */
    public function setRevRecEndDate($revRecEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($revRecEndDate) && !is_string($revRecEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revRecEndDate, true), gettype($revRecEndDate)), __LINE__);
        }
        $this->revRecEndDate = $revRecEndDate;
        return $this;
    }
    /**
     * Get catchUpPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getCatchUpPeriod()
    {
        return $this->catchUpPeriod;
    }
    /**
     * Set catchUpPeriod value
     * @param \StructType\RecordRef $catchUpPeriod
     * @return \StructType\CashRefundItem
     */
    public function setCatchUpPeriod(\StructType\RecordRef $catchUpPeriod = null)
    {
        $this->catchUpPeriod = $catchUpPeriod;
        return $this;
    }
    /**
     * Get deferRevRec value
     * @return bool|null
     */
    public function getDeferRevRec()
    {
        return $this->deferRevRec;
    }
    /**
     * Set deferRevRec value
     * @param bool $deferRevRec
     * @return \StructType\CashRefundItem
     */
    public function setDeferRevRec($deferRevRec = null)
    {
        // validation for constraint: boolean
        if (!is_null($deferRevRec) && !is_bool($deferRevRec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deferRevRec, true), gettype($deferRevRec)), __LINE__);
        }
        $this->deferRevRec = $deferRevRec;
        return $this;
    }
    /**
     * Get giftCertFrom value
     * @return string|null
     */
    public function getGiftCertFrom()
    {
        return $this->giftCertFrom;
    }
    /**
     * Set giftCertFrom value
     * @param string $giftCertFrom
     * @return \StructType\CashRefundItem
     */
    public function setGiftCertFrom($giftCertFrom = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertFrom) && !is_string($giftCertFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertFrom, true), gettype($giftCertFrom)), __LINE__);
        }
        $this->giftCertFrom = $giftCertFrom;
        return $this;
    }
    /**
     * Get costEstimateType value
     * @return string|null
     */
    public function getCostEstimateType()
    {
        return $this->costEstimateType;
    }
    /**
     * Set costEstimateType value
     * @uses \EnumType\ItemCostEstimateType::valueIsValid()
     * @uses \EnumType\ItemCostEstimateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $costEstimateType
     * @return \StructType\CashRefundItem
     */
    public function setCostEstimateType($costEstimateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemCostEstimateType::valueIsValid($costEstimateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemCostEstimateType', is_array($costEstimateType) ? implode(', ', $costEstimateType) : var_export($costEstimateType, true), implode(', ', \EnumType\ItemCostEstimateType::getValidValues())), __LINE__);
        }
        $this->costEstimateType = $costEstimateType;
        return $this;
    }
    /**
     * Get costEstimate value
     * @return float|null
     */
    public function getCostEstimate()
    {
        return $this->costEstimate;
    }
    /**
     * Set costEstimate value
     * @param float $costEstimate
     * @return \StructType\CashRefundItem
     */
    public function setCostEstimate($costEstimate = null)
    {
        // validation for constraint: float
        if (!is_null($costEstimate) && !(is_float($costEstimate) || is_numeric($costEstimate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costEstimate, true), gettype($costEstimate)), __LINE__);
        }
        $this->costEstimate = $costEstimate;
        return $this;
    }
    /**
     * Get taxDetailsReference value
     * @return string|null
     */
    public function getTaxDetailsReference()
    {
        return $this->taxDetailsReference;
    }
    /**
     * Set taxDetailsReference value
     * @param string $taxDetailsReference
     * @return \StructType\CashRefundItem
     */
    public function setTaxDetailsReference($taxDetailsReference = null)
    {
        // validation for constraint: string
        if (!is_null($taxDetailsReference) && !is_string($taxDetailsReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxDetailsReference, true), gettype($taxDetailsReference)), __LINE__);
        }
        $this->taxDetailsReference = $taxDetailsReference;
        return $this;
    }
    /**
     * Get giftCertRecipientName value
     * @return string|null
     */
    public function getGiftCertRecipientName()
    {
        return $this->giftCertRecipientName;
    }
    /**
     * Set giftCertRecipientName value
     * @param string $giftCertRecipientName
     * @return \StructType\CashRefundItem
     */
    public function setGiftCertRecipientName($giftCertRecipientName = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertRecipientName) && !is_string($giftCertRecipientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertRecipientName, true), gettype($giftCertRecipientName)), __LINE__);
        }
        $this->giftCertRecipientName = $giftCertRecipientName;
        return $this;
    }
    /**
     * Get giftCertRecipientEmail value
     * @return string|null
     */
    public function getGiftCertRecipientEmail()
    {
        return $this->giftCertRecipientEmail;
    }
    /**
     * Set giftCertRecipientEmail value
     * @param string $giftCertRecipientEmail
     * @return \StructType\CashRefundItem
     */
    public function setGiftCertRecipientEmail($giftCertRecipientEmail = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertRecipientEmail) && !is_string($giftCertRecipientEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertRecipientEmail, true), gettype($giftCertRecipientEmail)), __LINE__);
        }
        $this->giftCertRecipientEmail = $giftCertRecipientEmail;
        return $this;
    }
    /**
     * Get giftCertMessage value
     * @return string|null
     */
    public function getGiftCertMessage()
    {
        return $this->giftCertMessage;
    }
    /**
     * Set giftCertMessage value
     * @param string $giftCertMessage
     * @return \StructType\CashRefundItem
     */
    public function setGiftCertMessage($giftCertMessage = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertMessage) && !is_string($giftCertMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertMessage, true), gettype($giftCertMessage)), __LINE__);
        }
        $this->giftCertMessage = $giftCertMessage;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \StructType\CashRefundItem
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get giftCertNumber value
     * @return string|null
     */
    public function getGiftCertNumber()
    {
        return $this->giftCertNumber;
    }
    /**
     * Set giftCertNumber value
     * @param string $giftCertNumber
     * @return \StructType\CashRefundItem
     */
    public function setGiftCertNumber($giftCertNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giftCertNumber) && !is_string($giftCertNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftCertNumber, true), gettype($giftCertNumber)), __LINE__);
        }
        $this->giftCertNumber = $giftCertNumber;
        return $this;
    }
    /**
     * Get vsoeSopGroup value
     * @return string|null
     */
    public function getVsoeSopGroup()
    {
        return $this->vsoeSopGroup;
    }
    /**
     * Set vsoeSopGroup value
     * @uses \EnumType\VsoeSopGroup::valueIsValid()
     * @uses \EnumType\VsoeSopGroup::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeSopGroup
     * @return \StructType\CashRefundItem
     */
    public function setVsoeSopGroup($vsoeSopGroup = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeSopGroup::valueIsValid($vsoeSopGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeSopGroup', is_array($vsoeSopGroup) ? implode(', ', $vsoeSopGroup) : var_export($vsoeSopGroup, true), implode(', ', \EnumType\VsoeSopGroup::getValidValues())), __LINE__);
        }
        $this->vsoeSopGroup = $vsoeSopGroup;
        return $this;
    }
    /**
     * Get vsoeIsEstimate value
     * @return bool|null
     */
    public function getVsoeIsEstimate()
    {
        return $this->vsoeIsEstimate;
    }
    /**
     * Set vsoeIsEstimate value
     * @param bool $vsoeIsEstimate
     * @return \StructType\CashRefundItem
     */
    public function setVsoeIsEstimate($vsoeIsEstimate = null)
    {
        // validation for constraint: boolean
        if (!is_null($vsoeIsEstimate) && !is_bool($vsoeIsEstimate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vsoeIsEstimate, true), gettype($vsoeIsEstimate)), __LINE__);
        }
        $this->vsoeIsEstimate = $vsoeIsEstimate;
        return $this;
    }
    /**
     * Get vsoePrice value
     * @return float|null
     */
    public function getVsoePrice()
    {
        return $this->vsoePrice;
    }
    /**
     * Set vsoePrice value
     * @param float $vsoePrice
     * @return \StructType\CashRefundItem
     */
    public function setVsoePrice($vsoePrice = null)
    {
        // validation for constraint: float
        if (!is_null($vsoePrice) && !(is_float($vsoePrice) || is_numeric($vsoePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vsoePrice, true), gettype($vsoePrice)), __LINE__);
        }
        $this->vsoePrice = $vsoePrice;
        return $this;
    }
    /**
     * Get vsoeAmount value
     * @return float|null
     */
    public function getVsoeAmount()
    {
        return $this->vsoeAmount;
    }
    /**
     * Set vsoeAmount value
     * @param float $vsoeAmount
     * @return \StructType\CashRefundItem
     */
    public function setVsoeAmount($vsoeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($vsoeAmount) && !(is_float($vsoeAmount) || is_numeric($vsoeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vsoeAmount, true), gettype($vsoeAmount)), __LINE__);
        }
        $this->vsoeAmount = $vsoeAmount;
        return $this;
    }
    /**
     * Get vsoeAllocation value
     * @return float|null
     */
    public function getVsoeAllocation()
    {
        return $this->vsoeAllocation;
    }
    /**
     * Set vsoeAllocation value
     * @param float $vsoeAllocation
     * @return \StructType\CashRefundItem
     */
    public function setVsoeAllocation($vsoeAllocation = null)
    {
        // validation for constraint: float
        if (!is_null($vsoeAllocation) && !(is_float($vsoeAllocation) || is_numeric($vsoeAllocation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vsoeAllocation, true), gettype($vsoeAllocation)), __LINE__);
        }
        $this->vsoeAllocation = $vsoeAllocation;
        return $this;
    }
    /**
     * Get vsoeDeferral value
     * @return string|null
     */
    public function getVsoeDeferral()
    {
        return $this->vsoeDeferral;
    }
    /**
     * Set vsoeDeferral value
     * @uses \EnumType\VsoeDeferral::valueIsValid()
     * @uses \EnumType\VsoeDeferral::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeDeferral
     * @return \StructType\CashRefundItem
     */
    public function setVsoeDeferral($vsoeDeferral = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeDeferral::valueIsValid($vsoeDeferral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeDeferral', is_array($vsoeDeferral) ? implode(', ', $vsoeDeferral) : var_export($vsoeDeferral, true), implode(', ', \EnumType\VsoeDeferral::getValidValues())), __LINE__);
        }
        $this->vsoeDeferral = $vsoeDeferral;
        return $this;
    }
    /**
     * Get vsoePermitDiscount value
     * @return string|null
     */
    public function getVsoePermitDiscount()
    {
        return $this->vsoePermitDiscount;
    }
    /**
     * Set vsoePermitDiscount value
     * @uses \EnumType\VsoePermitDiscount::valueIsValid()
     * @uses \EnumType\VsoePermitDiscount::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoePermitDiscount
     * @return \StructType\CashRefundItem
     */
    public function setVsoePermitDiscount($vsoePermitDiscount = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoePermitDiscount::valueIsValid($vsoePermitDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoePermitDiscount', is_array($vsoePermitDiscount) ? implode(', ', $vsoePermitDiscount) : var_export($vsoePermitDiscount, true), implode(', ', \EnumType\VsoePermitDiscount::getValidValues())), __LINE__);
        }
        $this->vsoePermitDiscount = $vsoePermitDiscount;
        return $this;
    }
    /**
     * Get vsoeDelivered value
     * @return bool|null
     */
    public function getVsoeDelivered()
    {
        return $this->vsoeDelivered;
    }
    /**
     * Set vsoeDelivered value
     * @param bool $vsoeDelivered
     * @return \StructType\CashRefundItem
     */
    public function setVsoeDelivered($vsoeDelivered = null)
    {
        // validation for constraint: boolean
        if (!is_null($vsoeDelivered) && !is_bool($vsoeDelivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vsoeDelivered, true), gettype($vsoeDelivered)), __LINE__);
        }
        $this->vsoeDelivered = $vsoeDelivered;
        return $this;
    }
    /**
     * Get chargeType value
     * @return \StructType\RecordRef|null
     */
    public function getChargeType()
    {
        return $this->chargeType;
    }
    /**
     * Set chargeType value
     * @param \StructType\RecordRef $chargeType
     * @return \StructType\CashRefundItem
     */
    public function setChargeType(\StructType\RecordRef $chargeType = null)
    {
        $this->chargeType = $chargeType;
        return $this;
    }
    /**
     * Get chargesList value
     * @return \StructType\RecordRefList|null
     */
    public function getChargesList()
    {
        return $this->chargesList;
    }
    /**
     * Set chargesList value
     * @param \StructType\RecordRefList $chargesList
     * @return \StructType\CashRefundItem
     */
    public function setChargesList(\StructType\RecordRefList $chargesList = null)
    {
        $this->chargesList = $chargesList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\CashRefundItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
