<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignEventResponse StructType
 * @subpackage Structs
 */
class CampaignEventResponse extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The dateSent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateSent;
    /**
     * The sent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $sent;
    /**
     * The opened
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $opened;
    /**
     * The openedRatio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $openedRatio;
    /**
     * The clickedThru
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $clickedThru;
    /**
     * The clickedThruRatio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $clickedThruRatio;
    /**
     * The responded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $responded;
    /**
     * The respondedRatio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $respondedRatio;
    /**
     * The unsubscribed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $unsubscribed;
    /**
     * The unsubscribedRatio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $unsubscribedRatio;
    /**
     * The bounced
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $bounced;
    /**
     * The bouncedRatio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $bouncedRatio;
    /**
     * Constructor method for CampaignEventResponse
     * @uses CampaignEventResponse::setName()
     * @uses CampaignEventResponse::setType()
     * @uses CampaignEventResponse::setDateSent()
     * @uses CampaignEventResponse::setSent()
     * @uses CampaignEventResponse::setOpened()
     * @uses CampaignEventResponse::setOpenedRatio()
     * @uses CampaignEventResponse::setClickedThru()
     * @uses CampaignEventResponse::setClickedThruRatio()
     * @uses CampaignEventResponse::setResponded()
     * @uses CampaignEventResponse::setRespondedRatio()
     * @uses CampaignEventResponse::setUnsubscribed()
     * @uses CampaignEventResponse::setUnsubscribedRatio()
     * @uses CampaignEventResponse::setBounced()
     * @uses CampaignEventResponse::setBouncedRatio()
     * @param string $name
     * @param string $type
     * @param string $dateSent
     * @param float $sent
     * @param float $opened
     * @param float $openedRatio
     * @param float $clickedThru
     * @param float $clickedThruRatio
     * @param int $responded
     * @param float $respondedRatio
     * @param int $unsubscribed
     * @param float $unsubscribedRatio
     * @param int $bounced
     * @param float $bouncedRatio
     */
    public function __construct($name = null, $type = null, $dateSent = null, $sent = null, $opened = null, $openedRatio = null, $clickedThru = null, $clickedThruRatio = null, $responded = null, $respondedRatio = null, $unsubscribed = null, $unsubscribedRatio = null, $bounced = null, $bouncedRatio = null)
    {
        $this
            ->setName($name)
            ->setType($type)
            ->setDateSent($dateSent)
            ->setSent($sent)
            ->setOpened($opened)
            ->setOpenedRatio($openedRatio)
            ->setClickedThru($clickedThru)
            ->setClickedThruRatio($clickedThruRatio)
            ->setResponded($responded)
            ->setRespondedRatio($respondedRatio)
            ->setUnsubscribed($unsubscribed)
            ->setUnsubscribedRatio($unsubscribedRatio)
            ->setBounced($bounced)
            ->setBouncedRatio($bouncedRatio);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CampaignEventResponse
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\CampaignEventResponse
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get dateSent value
     * @return string|null
     */
    public function getDateSent()
    {
        return $this->dateSent;
    }
    /**
     * Set dateSent value
     * @param string $dateSent
     * @return \StructType\CampaignEventResponse
     */
    public function setDateSent($dateSent = null)
    {
        // validation for constraint: string
        if (!is_null($dateSent) && !is_string($dateSent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateSent, true), gettype($dateSent)), __LINE__);
        }
        $this->dateSent = $dateSent;
        return $this;
    }
    /**
     * Get sent value
     * @return float|null
     */
    public function getSent()
    {
        return $this->sent;
    }
    /**
     * Set sent value
     * @param float $sent
     * @return \StructType\CampaignEventResponse
     */
    public function setSent($sent = null)
    {
        // validation for constraint: float
        if (!is_null($sent) && !(is_float($sent) || is_numeric($sent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sent, true), gettype($sent)), __LINE__);
        }
        $this->sent = $sent;
        return $this;
    }
    /**
     * Get opened value
     * @return float|null
     */
    public function getOpened()
    {
        return $this->opened;
    }
    /**
     * Set opened value
     * @param float $opened
     * @return \StructType\CampaignEventResponse
     */
    public function setOpened($opened = null)
    {
        // validation for constraint: float
        if (!is_null($opened) && !(is_float($opened) || is_numeric($opened))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($opened, true), gettype($opened)), __LINE__);
        }
        $this->opened = $opened;
        return $this;
    }
    /**
     * Get openedRatio value
     * @return float|null
     */
    public function getOpenedRatio()
    {
        return $this->openedRatio;
    }
    /**
     * Set openedRatio value
     * @param float $openedRatio
     * @return \StructType\CampaignEventResponse
     */
    public function setOpenedRatio($openedRatio = null)
    {
        // validation for constraint: float
        if (!is_null($openedRatio) && !(is_float($openedRatio) || is_numeric($openedRatio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($openedRatio, true), gettype($openedRatio)), __LINE__);
        }
        $this->openedRatio = $openedRatio;
        return $this;
    }
    /**
     * Get clickedThru value
     * @return float|null
     */
    public function getClickedThru()
    {
        return $this->clickedThru;
    }
    /**
     * Set clickedThru value
     * @param float $clickedThru
     * @return \StructType\CampaignEventResponse
     */
    public function setClickedThru($clickedThru = null)
    {
        // validation for constraint: float
        if (!is_null($clickedThru) && !(is_float($clickedThru) || is_numeric($clickedThru))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($clickedThru, true), gettype($clickedThru)), __LINE__);
        }
        $this->clickedThru = $clickedThru;
        return $this;
    }
    /**
     * Get clickedThruRatio value
     * @return float|null
     */
    public function getClickedThruRatio()
    {
        return $this->clickedThruRatio;
    }
    /**
     * Set clickedThruRatio value
     * @param float $clickedThruRatio
     * @return \StructType\CampaignEventResponse
     */
    public function setClickedThruRatio($clickedThruRatio = null)
    {
        // validation for constraint: float
        if (!is_null($clickedThruRatio) && !(is_float($clickedThruRatio) || is_numeric($clickedThruRatio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($clickedThruRatio, true), gettype($clickedThruRatio)), __LINE__);
        }
        $this->clickedThruRatio = $clickedThruRatio;
        return $this;
    }
    /**
     * Get responded value
     * @return int|null
     */
    public function getResponded()
    {
        return $this->responded;
    }
    /**
     * Set responded value
     * @param int $responded
     * @return \StructType\CampaignEventResponse
     */
    public function setResponded($responded = null)
    {
        // validation for constraint: int
        if (!is_null($responded) && !(is_int($responded) || ctype_digit($responded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($responded, true), gettype($responded)), __LINE__);
        }
        $this->responded = $responded;
        return $this;
    }
    /**
     * Get respondedRatio value
     * @return float|null
     */
    public function getRespondedRatio()
    {
        return $this->respondedRatio;
    }
    /**
     * Set respondedRatio value
     * @param float $respondedRatio
     * @return \StructType\CampaignEventResponse
     */
    public function setRespondedRatio($respondedRatio = null)
    {
        // validation for constraint: float
        if (!is_null($respondedRatio) && !(is_float($respondedRatio) || is_numeric($respondedRatio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($respondedRatio, true), gettype($respondedRatio)), __LINE__);
        }
        $this->respondedRatio = $respondedRatio;
        return $this;
    }
    /**
     * Get unsubscribed value
     * @return int|null
     */
    public function getUnsubscribed()
    {
        return $this->unsubscribed;
    }
    /**
     * Set unsubscribed value
     * @param int $unsubscribed
     * @return \StructType\CampaignEventResponse
     */
    public function setUnsubscribed($unsubscribed = null)
    {
        // validation for constraint: int
        if (!is_null($unsubscribed) && !(is_int($unsubscribed) || ctype_digit($unsubscribed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unsubscribed, true), gettype($unsubscribed)), __LINE__);
        }
        $this->unsubscribed = $unsubscribed;
        return $this;
    }
    /**
     * Get unsubscribedRatio value
     * @return float|null
     */
    public function getUnsubscribedRatio()
    {
        return $this->unsubscribedRatio;
    }
    /**
     * Set unsubscribedRatio value
     * @param float $unsubscribedRatio
     * @return \StructType\CampaignEventResponse
     */
    public function setUnsubscribedRatio($unsubscribedRatio = null)
    {
        // validation for constraint: float
        if (!is_null($unsubscribedRatio) && !(is_float($unsubscribedRatio) || is_numeric($unsubscribedRatio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unsubscribedRatio, true), gettype($unsubscribedRatio)), __LINE__);
        }
        $this->unsubscribedRatio = $unsubscribedRatio;
        return $this;
    }
    /**
     * Get bounced value
     * @return int|null
     */
    public function getBounced()
    {
        return $this->bounced;
    }
    /**
     * Set bounced value
     * @param int $bounced
     * @return \StructType\CampaignEventResponse
     */
    public function setBounced($bounced = null)
    {
        // validation for constraint: int
        if (!is_null($bounced) && !(is_int($bounced) || ctype_digit($bounced))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bounced, true), gettype($bounced)), __LINE__);
        }
        $this->bounced = $bounced;
        return $this;
    }
    /**
     * Get bouncedRatio value
     * @return float|null
     */
    public function getBouncedRatio()
    {
        return $this->bouncedRatio;
    }
    /**
     * Set bouncedRatio value
     * @param float $bouncedRatio
     * @return \StructType\CampaignEventResponse
     */
    public function setBouncedRatio($bouncedRatio = null)
    {
        // validation for constraint: float
        if (!is_null($bouncedRatio) && !(is_float($bouncedRatio) || is_numeric($bouncedRatio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bouncedRatio, true), gettype($bouncedRatio)), __LINE__);
        }
        $this->bouncedRatio = $bouncedRatio;
        return $this;
    }
}
