<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignDirectMail StructType
 * @subpackage Structs
 */
class CampaignDirectMail extends AbstractStructBase
{
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $internalId;
    /**
     * The campaignGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $campaignGroup;
    /**
     * The template
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $template;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The subscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subscription;
    /**
     * The channel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $channel;
    /**
     * The cost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $cost;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The dateScheduled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateScheduled;
    /**
     * The promoCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $promoCode;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for CampaignDirectMail
     * @uses CampaignDirectMail::setInternalId()
     * @uses CampaignDirectMail::setCampaignGroup()
     * @uses CampaignDirectMail::setTemplate()
     * @uses CampaignDirectMail::setDescription()
     * @uses CampaignDirectMail::setSubscription()
     * @uses CampaignDirectMail::setChannel()
     * @uses CampaignDirectMail::setCost()
     * @uses CampaignDirectMail::setStatus()
     * @uses CampaignDirectMail::setDateScheduled()
     * @uses CampaignDirectMail::setPromoCode()
     * @uses CampaignDirectMail::setCustomFieldList()
     * @param string $internalId
     * @param \StructType\RecordRef $campaignGroup
     * @param \StructType\RecordRef $template
     * @param string $description
     * @param \StructType\RecordRef $subscription
     * @param \StructType\RecordRef $channel
     * @param float $cost
     * @param string $status
     * @param string $dateScheduled
     * @param \StructType\RecordRef $promoCode
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct($internalId = null, \StructType\RecordRef $campaignGroup = null, \StructType\RecordRef $template = null, $description = null, \StructType\RecordRef $subscription = null, \StructType\RecordRef $channel = null, $cost = null, $status = null, $dateScheduled = null, \StructType\RecordRef $promoCode = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setInternalId($internalId)
            ->setCampaignGroup($campaignGroup)
            ->setTemplate($template)
            ->setDescription($description)
            ->setSubscription($subscription)
            ->setChannel($channel)
            ->setCost($cost)
            ->setStatus($status)
            ->setDateScheduled($dateScheduled)
            ->setPromoCode($promoCode)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\CampaignDirectMail
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get campaignGroup value
     * @return \StructType\RecordRef|null
     */
    public function getCampaignGroup()
    {
        return $this->campaignGroup;
    }
    /**
     * Set campaignGroup value
     * @param \StructType\RecordRef $campaignGroup
     * @return \StructType\CampaignDirectMail
     */
    public function setCampaignGroup(\StructType\RecordRef $campaignGroup = null)
    {
        $this->campaignGroup = $campaignGroup;
        return $this;
    }
    /**
     * Get template value
     * @return \StructType\RecordRef|null
     */
    public function getTemplate()
    {
        return $this->template;
    }
    /**
     * Set template value
     * @param \StructType\RecordRef $template
     * @return \StructType\CampaignDirectMail
     */
    public function setTemplate(\StructType\RecordRef $template = null)
    {
        $this->template = $template;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CampaignDirectMail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get subscription value
     * @return \StructType\RecordRef|null
     */
    public function getSubscription()
    {
        return $this->subscription;
    }
    /**
     * Set subscription value
     * @param \StructType\RecordRef $subscription
     * @return \StructType\CampaignDirectMail
     */
    public function setSubscription(\StructType\RecordRef $subscription = null)
    {
        $this->subscription = $subscription;
        return $this;
    }
    /**
     * Get channel value
     * @return \StructType\RecordRef|null
     */
    public function getChannel()
    {
        return $this->channel;
    }
    /**
     * Set channel value
     * @param \StructType\RecordRef $channel
     * @return \StructType\CampaignDirectMail
     */
    public function setChannel(\StructType\RecordRef $channel = null)
    {
        $this->channel = $channel;
        return $this;
    }
    /**
     * Get cost value
     * @return float|null
     */
    public function getCost()
    {
        return $this->cost;
    }
    /**
     * Set cost value
     * @param float $cost
     * @return \StructType\CampaignDirectMail
     */
    public function setCost($cost = null)
    {
        // validation for constraint: float
        if (!is_null($cost) && !(is_float($cost) || is_numeric($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->cost = $cost;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\CampaignCampaignDirectMailStatus::valueIsValid()
     * @uses \EnumType\CampaignCampaignDirectMailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\CampaignDirectMail
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignCampaignDirectMailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignCampaignDirectMailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\CampaignCampaignDirectMailStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get dateScheduled value
     * @return string|null
     */
    public function getDateScheduled()
    {
        return $this->dateScheduled;
    }
    /**
     * Set dateScheduled value
     * @param string $dateScheduled
     * @return \StructType\CampaignDirectMail
     */
    public function setDateScheduled($dateScheduled = null)
    {
        // validation for constraint: string
        if (!is_null($dateScheduled) && !is_string($dateScheduled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateScheduled, true), gettype($dateScheduled)), __LINE__);
        }
        $this->dateScheduled = $dateScheduled;
        return $this;
    }
    /**
     * Get promoCode value
     * @return \StructType\RecordRef|null
     */
    public function getPromoCode()
    {
        return $this->promoCode;
    }
    /**
     * Set promoCode value
     * @param \StructType\RecordRef $promoCode
     * @return \StructType\CampaignDirectMail
     */
    public function setPromoCode(\StructType\RecordRef $promoCode = null)
    {
        $this->promoCode = $promoCode;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\CampaignDirectMail
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
