<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalendarEventSearch StructType
 * @subpackage Structs
 */
class CalendarEventSearch extends SearchRecord
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CalendarEventSearchBasic
     */
    public $basic;
    /**
     * The attendeeJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EntitySearchBasic
     */
    public $attendeeJoin;
    /**
     * The attendeeContactJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContactSearchBasic
     */
    public $attendeeContactJoin;
    /**
     * The attendeeCustomerJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerSearchBasic
     */
    public $attendeeCustomerJoin;
    /**
     * The caseJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SupportCaseSearchBasic
     */
    public $caseJoin;
    /**
     * The fileJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FileSearchBasic
     */
    public $fileJoin;
    /**
     * The opportunityJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OpportunitySearchBasic
     */
    public $opportunityJoin;
    /**
     * The originatingLeadJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OriginatingLeadSearchBasic
     */
    public $originatingLeadJoin;
    /**
     * The timeJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TimeBillSearchBasic
     */
    public $timeJoin;
    /**
     * The transactionJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransactionSearchBasic
     */
    public $transactionJoin;
    /**
     * The userJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchBasic
     */
    public $userJoin;
    /**
     * The userNotesJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NoteSearchBasic
     */
    public $userNotesJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchJoin[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for CalendarEventSearch
     * @uses CalendarEventSearch::setBasic()
     * @uses CalendarEventSearch::setAttendeeJoin()
     * @uses CalendarEventSearch::setAttendeeContactJoin()
     * @uses CalendarEventSearch::setAttendeeCustomerJoin()
     * @uses CalendarEventSearch::setCaseJoin()
     * @uses CalendarEventSearch::setFileJoin()
     * @uses CalendarEventSearch::setOpportunityJoin()
     * @uses CalendarEventSearch::setOriginatingLeadJoin()
     * @uses CalendarEventSearch::setTimeJoin()
     * @uses CalendarEventSearch::setTransactionJoin()
     * @uses CalendarEventSearch::setUserJoin()
     * @uses CalendarEventSearch::setUserNotesJoin()
     * @uses CalendarEventSearch::setCustomSearchJoin()
     * @param \StructType\CalendarEventSearchBasic $basic
     * @param \StructType\EntitySearchBasic $attendeeJoin
     * @param \StructType\ContactSearchBasic $attendeeContactJoin
     * @param \StructType\CustomerSearchBasic $attendeeCustomerJoin
     * @param \StructType\SupportCaseSearchBasic $caseJoin
     * @param \StructType\FileSearchBasic $fileJoin
     * @param \StructType\OpportunitySearchBasic $opportunityJoin
     * @param \StructType\OriginatingLeadSearchBasic $originatingLeadJoin
     * @param \StructType\TimeBillSearchBasic $timeJoin
     * @param \StructType\TransactionSearchBasic $transactionJoin
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @param \StructType\NoteSearchBasic $userNotesJoin
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     */
    public function __construct(\StructType\CalendarEventSearchBasic $basic = null, \StructType\EntitySearchBasic $attendeeJoin = null, \StructType\ContactSearchBasic $attendeeContactJoin = null, \StructType\CustomerSearchBasic $attendeeCustomerJoin = null, \StructType\SupportCaseSearchBasic $caseJoin = null, \StructType\FileSearchBasic $fileJoin = null, \StructType\OpportunitySearchBasic $opportunityJoin = null, \StructType\OriginatingLeadSearchBasic $originatingLeadJoin = null, \StructType\TimeBillSearchBasic $timeJoin = null, \StructType\TransactionSearchBasic $transactionJoin = null, \StructType\EmployeeSearchBasic $userJoin = null, \StructType\NoteSearchBasic $userNotesJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setAttendeeJoin($attendeeJoin)
            ->setAttendeeContactJoin($attendeeContactJoin)
            ->setAttendeeCustomerJoin($attendeeCustomerJoin)
            ->setCaseJoin($caseJoin)
            ->setFileJoin($fileJoin)
            ->setOpportunityJoin($opportunityJoin)
            ->setOriginatingLeadJoin($originatingLeadJoin)
            ->setTimeJoin($timeJoin)
            ->setTransactionJoin($transactionJoin)
            ->setUserJoin($userJoin)
            ->setUserNotesJoin($userNotesJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\CalendarEventSearchBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\CalendarEventSearchBasic $basic
     * @return \StructType\CalendarEventSearch
     */
    public function setBasic(\StructType\CalendarEventSearchBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get attendeeJoin value
     * @return \StructType\EntitySearchBasic|null
     */
    public function getAttendeeJoin()
    {
        return $this->attendeeJoin;
    }
    /**
     * Set attendeeJoin value
     * @param \StructType\EntitySearchBasic $attendeeJoin
     * @return \StructType\CalendarEventSearch
     */
    public function setAttendeeJoin(\StructType\EntitySearchBasic $attendeeJoin = null)
    {
        $this->attendeeJoin = $attendeeJoin;
        return $this;
    }
    /**
     * Get attendeeContactJoin value
     * @return \StructType\ContactSearchBasic|null
     */
    public function getAttendeeContactJoin()
    {
        return $this->attendeeContactJoin;
    }
    /**
     * Set attendeeContactJoin value
     * @param \StructType\ContactSearchBasic $attendeeContactJoin
     * @return \StructType\CalendarEventSearch
     */
    public function setAttendeeContactJoin(\StructType\ContactSearchBasic $attendeeContactJoin = null)
    {
        $this->attendeeContactJoin = $attendeeContactJoin;
        return $this;
    }
    /**
     * Get attendeeCustomerJoin value
     * @return \StructType\CustomerSearchBasic|null
     */
    public function getAttendeeCustomerJoin()
    {
        return $this->attendeeCustomerJoin;
    }
    /**
     * Set attendeeCustomerJoin value
     * @param \StructType\CustomerSearchBasic $attendeeCustomerJoin
     * @return \StructType\CalendarEventSearch
     */
    public function setAttendeeCustomerJoin(\StructType\CustomerSearchBasic $attendeeCustomerJoin = null)
    {
        $this->attendeeCustomerJoin = $attendeeCustomerJoin;
        return $this;
    }
    /**
     * Get caseJoin value
     * @return \StructType\SupportCaseSearchBasic|null
     */
    public function getCaseJoin()
    {
        return $this->caseJoin;
    }
    /**
     * Set caseJoin value
     * @param \StructType\SupportCaseSearchBasic $caseJoin
     * @return \StructType\CalendarEventSearch
     */
    public function setCaseJoin(\StructType\SupportCaseSearchBasic $caseJoin = null)
    {
        $this->caseJoin = $caseJoin;
        return $this;
    }
    /**
     * Get fileJoin value
     * @return \StructType\FileSearchBasic|null
     */
    public function getFileJoin()
    {
        return $this->fileJoin;
    }
    /**
     * Set fileJoin value
     * @param \StructType\FileSearchBasic $fileJoin
     * @return \StructType\CalendarEventSearch
     */
    public function setFileJoin(\StructType\FileSearchBasic $fileJoin = null)
    {
        $this->fileJoin = $fileJoin;
        return $this;
    }
    /**
     * Get opportunityJoin value
     * @return \StructType\OpportunitySearchBasic|null
     */
    public function getOpportunityJoin()
    {
        return $this->opportunityJoin;
    }
    /**
     * Set opportunityJoin value
     * @param \StructType\OpportunitySearchBasic $opportunityJoin
     * @return \StructType\CalendarEventSearch
     */
    public function setOpportunityJoin(\StructType\OpportunitySearchBasic $opportunityJoin = null)
    {
        $this->opportunityJoin = $opportunityJoin;
        return $this;
    }
    /**
     * Get originatingLeadJoin value
     * @return \StructType\OriginatingLeadSearchBasic|null
     */
    public function getOriginatingLeadJoin()
    {
        return $this->originatingLeadJoin;
    }
    /**
     * Set originatingLeadJoin value
     * @param \StructType\OriginatingLeadSearchBasic $originatingLeadJoin
     * @return \StructType\CalendarEventSearch
     */
    public function setOriginatingLeadJoin(\StructType\OriginatingLeadSearchBasic $originatingLeadJoin = null)
    {
        $this->originatingLeadJoin = $originatingLeadJoin;
        return $this;
    }
    /**
     * Get timeJoin value
     * @return \StructType\TimeBillSearchBasic|null
     */
    public function getTimeJoin()
    {
        return $this->timeJoin;
    }
    /**
     * Set timeJoin value
     * @param \StructType\TimeBillSearchBasic $timeJoin
     * @return \StructType\CalendarEventSearch
     */
    public function setTimeJoin(\StructType\TimeBillSearchBasic $timeJoin = null)
    {
        $this->timeJoin = $timeJoin;
        return $this;
    }
    /**
     * Get transactionJoin value
     * @return \StructType\TransactionSearchBasic|null
     */
    public function getTransactionJoin()
    {
        return $this->transactionJoin;
    }
    /**
     * Set transactionJoin value
     * @param \StructType\TransactionSearchBasic $transactionJoin
     * @return \StructType\CalendarEventSearch
     */
    public function setTransactionJoin(\StructType\TransactionSearchBasic $transactionJoin = null)
    {
        $this->transactionJoin = $transactionJoin;
        return $this;
    }
    /**
     * Get userJoin value
     * @return \StructType\EmployeeSearchBasic|null
     */
    public function getUserJoin()
    {
        return $this->userJoin;
    }
    /**
     * Set userJoin value
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @return \StructType\CalendarEventSearch
     */
    public function setUserJoin(\StructType\EmployeeSearchBasic $userJoin = null)
    {
        $this->userJoin = $userJoin;
        return $this;
    }
    /**
     * Get userNotesJoin value
     * @return \StructType\NoteSearchBasic|null
     */
    public function getUserNotesJoin()
    {
        return $this->userNotesJoin;
    }
    /**
     * Set userNotesJoin value
     * @param \StructType\NoteSearchBasic $userNotesJoin
     * @return \StructType\CalendarEventSearch
     */
    public function setUserNotesJoin(\StructType\NoteSearchBasic $userNotesJoin = null)
    {
        $this->userNotesJoin = $userNotesJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchJoin[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $calendarEventSearchCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$calendarEventSearchCustomSearchJoinItem instanceof \StructType\CustomSearchJoin) {
                $invalidValues[] = is_object($calendarEventSearchCustomSearchJoinItem) ? get_class($calendarEventSearchCustomSearchJoinItem) : sprintf('%s(%s)', gettype($calendarEventSearchCustomSearchJoinItem), var_export($calendarEventSearchCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     * @return \StructType\CalendarEventSearch
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin $item
     * @return \StructType\CalendarEventSearch
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchJoin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchJoin) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
