<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalendarEventResource StructType
 * @subpackage Structs
 */
class CalendarEventResource extends AbstractStructBase
{
    /**
     * The resource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $resource;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $location;
    /**
     * Constructor method for CalendarEventResource
     * @uses CalendarEventResource::setResource()
     * @uses CalendarEventResource::setLocation()
     * @param \StructType\RecordRef $resource
     * @param string $location
     */
    public function __construct(\StructType\RecordRef $resource = null, $location = null)
    {
        $this
            ->setResource($resource)
            ->setLocation($location);
    }
    /**
     * Get resource value
     * @return \StructType\RecordRef|null
     */
    public function getResource()
    {
        return $this->resource;
    }
    /**
     * Set resource value
     * @param \StructType\RecordRef $resource
     * @return \StructType\CalendarEventResource
     */
    public function setResource(\StructType\RecordRef $resource = null)
    {
        $this->resource = $resource;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \StructType\CalendarEventResource
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
}
