<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BudgetSearchRow StructType
 * @subpackage Structs
 */
class BudgetSearchRow extends SearchRow
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BudgetSearchRowBasic
     */
    public $basic;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchRowBasic[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for BudgetSearchRow
     * @uses BudgetSearchRow::setBasic()
     * @uses BudgetSearchRow::setCustomSearchJoin()
     * @param \StructType\BudgetSearchRowBasic $basic
     * @param \StructType\CustomSearchRowBasic[] $customSearchJoin
     */
    public function __construct(\StructType\BudgetSearchRowBasic $basic = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\BudgetSearchRowBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\BudgetSearchRowBasic $basic
     * @return \StructType\BudgetSearchRow
     */
    public function setBasic(\StructType\BudgetSearchRowBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchRowBasic[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $budgetSearchRowCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$budgetSearchRowCustomSearchJoinItem instanceof \StructType\CustomSearchRowBasic) {
                $invalidValues[] = is_object($budgetSearchRowCustomSearchJoinItem) ? get_class($budgetSearchRowCustomSearchJoinItem) : sprintf('%s(%s)', gettype($budgetSearchRowCustomSearchJoinItem), var_export($budgetSearchRowCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchRowBasic, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchRowBasic[] $customSearchJoin
     * @return \StructType\BudgetSearchRow
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchRowBasic $item
     * @return \StructType\BudgetSearchRow
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchRowBasic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchRowBasic) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchRowBasic, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
