<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BudgetExchangeRate StructType
 * @subpackage Structs
 */
class BudgetExchangeRate extends AbstractStructBase
{
    /**
     * The period
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RecordRef
     */
    public $period;
    /**
     * The fromSubsidiary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RecordRef
     */
    public $fromSubsidiary;
    /**
     * The toSubsidiary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RecordRef
     */
    public $toSubsidiary;
    /**
     * The currentRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $currentRate;
    /**
     * The averageRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $averageRate;
    /**
     * The historicalRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $historicalRate;
    /**
     * Constructor method for BudgetExchangeRate
     * @uses BudgetExchangeRate::setPeriod()
     * @uses BudgetExchangeRate::setFromSubsidiary()
     * @uses BudgetExchangeRate::setToSubsidiary()
     * @uses BudgetExchangeRate::setCurrentRate()
     * @uses BudgetExchangeRate::setAverageRate()
     * @uses BudgetExchangeRate::setHistoricalRate()
     * @param \StructType\RecordRef $period
     * @param \StructType\RecordRef $fromSubsidiary
     * @param \StructType\RecordRef $toSubsidiary
     * @param float $currentRate
     * @param float $averageRate
     * @param float $historicalRate
     */
    public function __construct(\StructType\RecordRef $period = null, \StructType\RecordRef $fromSubsidiary = null, \StructType\RecordRef $toSubsidiary = null, $currentRate = null, $averageRate = null, $historicalRate = null)
    {
        $this
            ->setPeriod($period)
            ->setFromSubsidiary($fromSubsidiary)
            ->setToSubsidiary($toSubsidiary)
            ->setCurrentRate($currentRate)
            ->setAverageRate($averageRate)
            ->setHistoricalRate($historicalRate);
    }
    /**
     * Get period value
     * @return \StructType\RecordRef
     */
    public function getPeriod()
    {
        return $this->period;
    }
    /**
     * Set period value
     * @param \StructType\RecordRef $period
     * @return \StructType\BudgetExchangeRate
     */
    public function setPeriod(\StructType\RecordRef $period = null)
    {
        $this->period = $period;
        return $this;
    }
    /**
     * Get fromSubsidiary value
     * @return \StructType\RecordRef
     */
    public function getFromSubsidiary()
    {
        return $this->fromSubsidiary;
    }
    /**
     * Set fromSubsidiary value
     * @param \StructType\RecordRef $fromSubsidiary
     * @return \StructType\BudgetExchangeRate
     */
    public function setFromSubsidiary(\StructType\RecordRef $fromSubsidiary = null)
    {
        $this->fromSubsidiary = $fromSubsidiary;
        return $this;
    }
    /**
     * Get toSubsidiary value
     * @return \StructType\RecordRef
     */
    public function getToSubsidiary()
    {
        return $this->toSubsidiary;
    }
    /**
     * Set toSubsidiary value
     * @param \StructType\RecordRef $toSubsidiary
     * @return \StructType\BudgetExchangeRate
     */
    public function setToSubsidiary(\StructType\RecordRef $toSubsidiary = null)
    {
        $this->toSubsidiary = $toSubsidiary;
        return $this;
    }
    /**
     * Get currentRate value
     * @return float|null
     */
    public function getCurrentRate()
    {
        return $this->currentRate;
    }
    /**
     * Set currentRate value
     * @param float $currentRate
     * @return \StructType\BudgetExchangeRate
     */
    public function setCurrentRate($currentRate = null)
    {
        // validation for constraint: float
        if (!is_null($currentRate) && !(is_float($currentRate) || is_numeric($currentRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currentRate, true), gettype($currentRate)), __LINE__);
        }
        $this->currentRate = $currentRate;
        return $this;
    }
    /**
     * Get averageRate value
     * @return float|null
     */
    public function getAverageRate()
    {
        return $this->averageRate;
    }
    /**
     * Set averageRate value
     * @param float $averageRate
     * @return \StructType\BudgetExchangeRate
     */
    public function setAverageRate($averageRate = null)
    {
        // validation for constraint: float
        if (!is_null($averageRate) && !(is_float($averageRate) || is_numeric($averageRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($averageRate, true), gettype($averageRate)), __LINE__);
        }
        $this->averageRate = $averageRate;
        return $this;
    }
    /**
     * Get historicalRate value
     * @return float|null
     */
    public function getHistoricalRate()
    {
        return $this->historicalRate;
    }
    /**
     * Set historicalRate value
     * @param float $historicalRate
     * @return \StructType\BudgetExchangeRate
     */
    public function setHistoricalRate($historicalRate = null)
    {
        // validation for constraint: float
        if (!is_null($historicalRate) && !(is_float($historicalRate) || is_numeric($historicalRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($historicalRate, true), gettype($historicalRate)), __LINE__);
        }
        $this->historicalRate = $historicalRate;
        return $this;
    }
}
