<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BudgetCategory StructType
 * @subpackage Structs
 */
class BudgetCategory extends Record
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The budgetType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $budgetType;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * Constructor method for BudgetCategory
     * @uses BudgetCategory::setName()
     * @uses BudgetCategory::setBudgetType()
     * @uses BudgetCategory::setIsInactive()
     * @uses BudgetCategory::setInternalId()
     * @param string $name
     * @param bool $budgetType
     * @param bool $isInactive
     * @param string $internalId
     */
    public function __construct($name = null, $budgetType = null, $isInactive = null, $internalId = null)
    {
        $this
            ->setName($name)
            ->setBudgetType($budgetType)
            ->setIsInactive($isInactive)
            ->setInternalId($internalId);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\BudgetCategory
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get budgetType value
     * @return bool|null
     */
    public function getBudgetType()
    {
        return $this->budgetType;
    }
    /**
     * Set budgetType value
     * @param bool $budgetType
     * @return \StructType\BudgetCategory
     */
    public function setBudgetType($budgetType = null)
    {
        // validation for constraint: boolean
        if (!is_null($budgetType) && !is_bool($budgetType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($budgetType, true), gettype($budgetType)), __LINE__);
        }
        $this->budgetType = $budgetType;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\BudgetCategory
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\BudgetCategory
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
}
