<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BinTransferInventoryList StructType
 * @subpackage Structs
 */
class BinTransferInventoryList extends AbstractStructBase
{
    /**
     * The inventory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BinTransferInventory[]
     */
    public $inventory;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for BinTransferInventoryList
     * @uses BinTransferInventoryList::setInventory()
     * @uses BinTransferInventoryList::setReplaceAll()
     * @param \StructType\BinTransferInventory[] $inventory
     * @param bool $replaceAll
     */
    public function __construct(array $inventory = array(), $replaceAll = true)
    {
        $this
            ->setInventory($inventory)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get inventory value
     * @return \StructType\BinTransferInventory[]|null
     */
    public function getInventory()
    {
        return $this->inventory;
    }
    /**
     * This method is responsible for validating the values passed to the setInventory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInventory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInventoryForArrayConstraintsFromSetInventory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $binTransferInventoryListInventoryItem) {
            // validation for constraint: itemType
            if (!$binTransferInventoryListInventoryItem instanceof \StructType\BinTransferInventory) {
                $invalidValues[] = is_object($binTransferInventoryListInventoryItem) ? get_class($binTransferInventoryListInventoryItem) : sprintf('%s(%s)', gettype($binTransferInventoryListInventoryItem), var_export($binTransferInventoryListInventoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The inventory property can only contain items of type \StructType\BinTransferInventory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set inventory value
     * @throws \InvalidArgumentException
     * @param \StructType\BinTransferInventory[] $inventory
     * @return \StructType\BinTransferInventoryList
     */
    public function setInventory(array $inventory = array())
    {
        // validation for constraint: array
        if ('' !== ($inventoryArrayErrorMessage = self::validateInventoryForArrayConstraintsFromSetInventory($inventory))) {
            throw new \InvalidArgumentException($inventoryArrayErrorMessage, __LINE__);
        }
        $this->inventory = $inventory;
        return $this;
    }
    /**
     * Add item to inventory value
     * @throws \InvalidArgumentException
     * @param \StructType\BinTransferInventory $item
     * @return \StructType\BinTransferInventoryList
     */
    public function addToInventory(\StructType\BinTransferInventory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BinTransferInventory) {
            throw new \InvalidArgumentException(sprintf('The inventory property can only contain items of type \StructType\BinTransferInventory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->inventory[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\BinTransferInventoryList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
