<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AsyncGetListRequest StructType
 * @subpackage Structs
 */
class AsyncGetListRequest extends AbstractStructBase
{
    /**
     * The baseRef
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\BaseRef[]
     */
    public $baseRef;
    /**
     * Constructor method for AsyncGetListRequest
     * @uses AsyncGetListRequest::setBaseRef()
     * @param \StructType\BaseRef[] $baseRef
     */
    public function __construct(array $baseRef = array())
    {
        $this
            ->setBaseRef($baseRef);
    }
    /**
     * Get baseRef value
     * @return \StructType\BaseRef[]
     */
    public function getBaseRef()
    {
        return $this->baseRef;
    }
    /**
     * This method is responsible for validating the values passed to the setBaseRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaseRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaseRefForArrayConstraintsFromSetBaseRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asyncGetListRequestBaseRefItem) {
            // validation for constraint: itemType
            if (!$asyncGetListRequestBaseRefItem instanceof \StructType\BaseRef) {
                $invalidValues[] = is_object($asyncGetListRequestBaseRefItem) ? get_class($asyncGetListRequestBaseRefItem) : sprintf('%s(%s)', gettype($asyncGetListRequestBaseRefItem), var_export($asyncGetListRequestBaseRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The baseRef property can only contain items of type \StructType\BaseRef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set baseRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BaseRef[] $baseRef
     * @return \StructType\AsyncGetListRequest
     */
    public function setBaseRef(array $baseRef = array())
    {
        // validation for constraint: array
        if ('' !== ($baseRefArrayErrorMessage = self::validateBaseRefForArrayConstraintsFromSetBaseRef($baseRef))) {
            throw new \InvalidArgumentException($baseRefArrayErrorMessage, __LINE__);
        }
        $this->baseRef = $baseRef;
        return $this;
    }
    /**
     * Add item to baseRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BaseRef $item
     * @return \StructType\AsyncGetListRequest
     */
    public function addToBaseRef(\StructType\BaseRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BaseRef) {
            throw new \InvalidArgumentException(sprintf('The baseRef property can only contain items of type \StructType\BaseRef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->baseRef[] = $item;
        return $this;
    }
}
