<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressSearchRowBasic StructType
 * @subpackage Structs
 */
class AddressSearchRowBasic extends SearchRowBasic
{
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $address;
    /**
     * The address1
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $address1;
    /**
     * The address2
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $address2;
    /**
     * The address3
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $address3;
    /**
     * The addressee
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $addressee;
    /**
     * The attention
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $attention;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $city;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $country;
    /**
     * The countryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $countryCode;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The override
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $override;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $phone;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $state;
    /**
     * The zip
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $zip;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchColumnCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for AddressSearchRowBasic
     * @uses AddressSearchRowBasic::setAddress()
     * @uses AddressSearchRowBasic::setAddress1()
     * @uses AddressSearchRowBasic::setAddress2()
     * @uses AddressSearchRowBasic::setAddress3()
     * @uses AddressSearchRowBasic::setAddressee()
     * @uses AddressSearchRowBasic::setAttention()
     * @uses AddressSearchRowBasic::setCity()
     * @uses AddressSearchRowBasic::setCountry()
     * @uses AddressSearchRowBasic::setCountryCode()
     * @uses AddressSearchRowBasic::setExternalId()
     * @uses AddressSearchRowBasic::setInternalId()
     * @uses AddressSearchRowBasic::setOverride()
     * @uses AddressSearchRowBasic::setPhone()
     * @uses AddressSearchRowBasic::setState()
     * @uses AddressSearchRowBasic::setZip()
     * @uses AddressSearchRowBasic::setCustomFieldList()
     * @param \StructType\SearchColumnStringField[] $address
     * @param \StructType\SearchColumnStringField[] $address1
     * @param \StructType\SearchColumnStringField[] $address2
     * @param \StructType\SearchColumnStringField[] $address3
     * @param \StructType\SearchColumnStringField[] $addressee
     * @param \StructType\SearchColumnStringField[] $attention
     * @param \StructType\SearchColumnStringField[] $city
     * @param \StructType\SearchColumnEnumSelectField[] $country
     * @param \StructType\SearchColumnStringField[] $countryCode
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnBooleanField[] $override
     * @param \StructType\SearchColumnStringField[] $phone
     * @param \StructType\SearchColumnStringField[] $state
     * @param \StructType\SearchColumnStringField[] $zip
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     */
    public function __construct(array $address = array(), array $address1 = array(), array $address2 = array(), array $address3 = array(), array $addressee = array(), array $attention = array(), array $city = array(), array $country = array(), array $countryCode = array(), array $externalId = array(), array $internalId = array(), array $override = array(), array $phone = array(), array $state = array(), array $zip = array(), \StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this
            ->setAddress($address)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setAddressee($addressee)
            ->setAttention($attention)
            ->setCity($city)
            ->setCountry($country)
            ->setCountryCode($countryCode)
            ->setExternalId($externalId)
            ->setInternalId($internalId)
            ->setOverride($override)
            ->setPhone($phone)
            ->setState($state)
            ->setZip($zip)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get address value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressSearchRowBasicAddressItem) {
            // validation for constraint: itemType
            if (!$addressSearchRowBasicAddressItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($addressSearchRowBasicAddressItem) ? get_class($addressSearchRowBasicAddressItem) : sprintf('%s(%s)', gettype($addressSearchRowBasicAddressItem), var_export($addressSearchRowBasicAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The address property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set address value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $address
     * @return \StructType\AddressSearchRowBasic
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Add item to address value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AddressSearchRowBasic
     */
    public function addToAddress(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The address property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->address[] = $item;
        return $this;
    }
    /**
     * Get address1 value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getAddress1()
    {
        return $this->address1;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress1 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress1 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddress1ForArrayConstraintsFromSetAddress1(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressSearchRowBasicAddress1Item) {
            // validation for constraint: itemType
            if (!$addressSearchRowBasicAddress1Item instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($addressSearchRowBasicAddress1Item) ? get_class($addressSearchRowBasicAddress1Item) : sprintf('%s(%s)', gettype($addressSearchRowBasicAddress1Item), var_export($addressSearchRowBasicAddress1Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The address1 property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set address1 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $address1
     * @return \StructType\AddressSearchRowBasic
     */
    public function setAddress1(array $address1 = array())
    {
        // validation for constraint: array
        if ('' !== ($address1ArrayErrorMessage = self::validateAddress1ForArrayConstraintsFromSetAddress1($address1))) {
            throw new \InvalidArgumentException($address1ArrayErrorMessage, __LINE__);
        }
        $this->address1 = $address1;
        return $this;
    }
    /**
     * Add item to address1 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AddressSearchRowBasic
     */
    public function addToAddress1(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The address1 property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->address1[] = $item;
        return $this;
    }
    /**
     * Get address2 value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getAddress2()
    {
        return $this->address2;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress2 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress2 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddress2ForArrayConstraintsFromSetAddress2(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressSearchRowBasicAddress2Item) {
            // validation for constraint: itemType
            if (!$addressSearchRowBasicAddress2Item instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($addressSearchRowBasicAddress2Item) ? get_class($addressSearchRowBasicAddress2Item) : sprintf('%s(%s)', gettype($addressSearchRowBasicAddress2Item), var_export($addressSearchRowBasicAddress2Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The address2 property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set address2 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $address2
     * @return \StructType\AddressSearchRowBasic
     */
    public function setAddress2(array $address2 = array())
    {
        // validation for constraint: array
        if ('' !== ($address2ArrayErrorMessage = self::validateAddress2ForArrayConstraintsFromSetAddress2($address2))) {
            throw new \InvalidArgumentException($address2ArrayErrorMessage, __LINE__);
        }
        $this->address2 = $address2;
        return $this;
    }
    /**
     * Add item to address2 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AddressSearchRowBasic
     */
    public function addToAddress2(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The address2 property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->address2[] = $item;
        return $this;
    }
    /**
     * Get address3 value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getAddress3()
    {
        return $this->address3;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress3 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress3 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddress3ForArrayConstraintsFromSetAddress3(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressSearchRowBasicAddress3Item) {
            // validation for constraint: itemType
            if (!$addressSearchRowBasicAddress3Item instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($addressSearchRowBasicAddress3Item) ? get_class($addressSearchRowBasicAddress3Item) : sprintf('%s(%s)', gettype($addressSearchRowBasicAddress3Item), var_export($addressSearchRowBasicAddress3Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The address3 property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set address3 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $address3
     * @return \StructType\AddressSearchRowBasic
     */
    public function setAddress3(array $address3 = array())
    {
        // validation for constraint: array
        if ('' !== ($address3ArrayErrorMessage = self::validateAddress3ForArrayConstraintsFromSetAddress3($address3))) {
            throw new \InvalidArgumentException($address3ArrayErrorMessage, __LINE__);
        }
        $this->address3 = $address3;
        return $this;
    }
    /**
     * Add item to address3 value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AddressSearchRowBasic
     */
    public function addToAddress3(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The address3 property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->address3[] = $item;
        return $this;
    }
    /**
     * Get addressee value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getAddressee()
    {
        return $this->addressee;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddresseeForArrayConstraintsFromSetAddressee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressSearchRowBasicAddresseeItem) {
            // validation for constraint: itemType
            if (!$addressSearchRowBasicAddresseeItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($addressSearchRowBasicAddresseeItem) ? get_class($addressSearchRowBasicAddresseeItem) : sprintf('%s(%s)', gettype($addressSearchRowBasicAddresseeItem), var_export($addressSearchRowBasicAddresseeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The addressee property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set addressee value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $addressee
     * @return \StructType\AddressSearchRowBasic
     */
    public function setAddressee(array $addressee = array())
    {
        // validation for constraint: array
        if ('' !== ($addresseeArrayErrorMessage = self::validateAddresseeForArrayConstraintsFromSetAddressee($addressee))) {
            throw new \InvalidArgumentException($addresseeArrayErrorMessage, __LINE__);
        }
        $this->addressee = $addressee;
        return $this;
    }
    /**
     * Add item to addressee value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AddressSearchRowBasic
     */
    public function addToAddressee(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The addressee property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->addressee[] = $item;
        return $this;
    }
    /**
     * Get attention value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getAttention()
    {
        return $this->attention;
    }
    /**
     * This method is responsible for validating the values passed to the setAttention method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttention method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttentionForArrayConstraintsFromSetAttention(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressSearchRowBasicAttentionItem) {
            // validation for constraint: itemType
            if (!$addressSearchRowBasicAttentionItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($addressSearchRowBasicAttentionItem) ? get_class($addressSearchRowBasicAttentionItem) : sprintf('%s(%s)', gettype($addressSearchRowBasicAttentionItem), var_export($addressSearchRowBasicAttentionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attention property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attention value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $attention
     * @return \StructType\AddressSearchRowBasic
     */
    public function setAttention(array $attention = array())
    {
        // validation for constraint: array
        if ('' !== ($attentionArrayErrorMessage = self::validateAttentionForArrayConstraintsFromSetAttention($attention))) {
            throw new \InvalidArgumentException($attentionArrayErrorMessage, __LINE__);
        }
        $this->attention = $attention;
        return $this;
    }
    /**
     * Add item to attention value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AddressSearchRowBasic
     */
    public function addToAttention(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The attention property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->attention[] = $item;
        return $this;
    }
    /**
     * Get city value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * This method is responsible for validating the values passed to the setCity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCityForArrayConstraintsFromSetCity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressSearchRowBasicCityItem) {
            // validation for constraint: itemType
            if (!$addressSearchRowBasicCityItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($addressSearchRowBasicCityItem) ? get_class($addressSearchRowBasicCityItem) : sprintf('%s(%s)', gettype($addressSearchRowBasicCityItem), var_export($addressSearchRowBasicCityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The city property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set city value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $city
     * @return \StructType\AddressSearchRowBasic
     */
    public function setCity(array $city = array())
    {
        // validation for constraint: array
        if ('' !== ($cityArrayErrorMessage = self::validateCityForArrayConstraintsFromSetCity($city))) {
            throw new \InvalidArgumentException($cityArrayErrorMessage, __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Add item to city value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AddressSearchRowBasic
     */
    public function addToCity(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The city property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->city[] = $item;
        return $this;
    }
    /**
     * Get country value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * This method is responsible for validating the values passed to the setCountry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCountry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCountryForArrayConstraintsFromSetCountry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressSearchRowBasicCountryItem) {
            // validation for constraint: itemType
            if (!$addressSearchRowBasicCountryItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($addressSearchRowBasicCountryItem) ? get_class($addressSearchRowBasicCountryItem) : sprintf('%s(%s)', gettype($addressSearchRowBasicCountryItem), var_export($addressSearchRowBasicCountryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The country property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set country value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $country
     * @return \StructType\AddressSearchRowBasic
     */
    public function setCountry(array $country = array())
    {
        // validation for constraint: array
        if ('' !== ($countryArrayErrorMessage = self::validateCountryForArrayConstraintsFromSetCountry($country))) {
            throw new \InvalidArgumentException($countryArrayErrorMessage, __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Add item to country value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\AddressSearchRowBasic
     */
    public function addToCountry(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The country property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->country[] = $item;
        return $this;
    }
    /**
     * Get countryCode value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * This method is responsible for validating the values passed to the setCountryCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCountryCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCountryCodeForArrayConstraintsFromSetCountryCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressSearchRowBasicCountryCodeItem) {
            // validation for constraint: itemType
            if (!$addressSearchRowBasicCountryCodeItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($addressSearchRowBasicCountryCodeItem) ? get_class($addressSearchRowBasicCountryCodeItem) : sprintf('%s(%s)', gettype($addressSearchRowBasicCountryCodeItem), var_export($addressSearchRowBasicCountryCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The countryCode property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set countryCode value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $countryCode
     * @return \StructType\AddressSearchRowBasic
     */
    public function setCountryCode(array $countryCode = array())
    {
        // validation for constraint: array
        if ('' !== ($countryCodeArrayErrorMessage = self::validateCountryCodeForArrayConstraintsFromSetCountryCode($countryCode))) {
            throw new \InvalidArgumentException($countryCodeArrayErrorMessage, __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Add item to countryCode value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AddressSearchRowBasic
     */
    public function addToCountryCode(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The countryCode property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->countryCode[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$addressSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($addressSearchRowBasicExternalIdItem) ? get_class($addressSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($addressSearchRowBasicExternalIdItem), var_export($addressSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\AddressSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\AddressSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$addressSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($addressSearchRowBasicInternalIdItem) ? get_class($addressSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($addressSearchRowBasicInternalIdItem), var_export($addressSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\AddressSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\AddressSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get override value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getOverride()
    {
        return $this->override;
    }
    /**
     * This method is responsible for validating the values passed to the setOverride method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOverride method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOverrideForArrayConstraintsFromSetOverride(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressSearchRowBasicOverrideItem) {
            // validation for constraint: itemType
            if (!$addressSearchRowBasicOverrideItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($addressSearchRowBasicOverrideItem) ? get_class($addressSearchRowBasicOverrideItem) : sprintf('%s(%s)', gettype($addressSearchRowBasicOverrideItem), var_export($addressSearchRowBasicOverrideItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The override property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set override value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $override
     * @return \StructType\AddressSearchRowBasic
     */
    public function setOverride(array $override = array())
    {
        // validation for constraint: array
        if ('' !== ($overrideArrayErrorMessage = self::validateOverrideForArrayConstraintsFromSetOverride($override))) {
            throw new \InvalidArgumentException($overrideArrayErrorMessage, __LINE__);
        }
        $this->override = $override;
        return $this;
    }
    /**
     * Add item to override value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\AddressSearchRowBasic
     */
    public function addToOverride(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The override property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->override[] = $item;
        return $this;
    }
    /**
     * Get phone value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * This method is responsible for validating the values passed to the setPhone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhoneForArrayConstraintsFromSetPhone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressSearchRowBasicPhoneItem) {
            // validation for constraint: itemType
            if (!$addressSearchRowBasicPhoneItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($addressSearchRowBasicPhoneItem) ? get_class($addressSearchRowBasicPhoneItem) : sprintf('%s(%s)', gettype($addressSearchRowBasicPhoneItem), var_export($addressSearchRowBasicPhoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The phone property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set phone value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $phone
     * @return \StructType\AddressSearchRowBasic
     */
    public function setPhone(array $phone = array())
    {
        // validation for constraint: array
        if ('' !== ($phoneArrayErrorMessage = self::validatePhoneForArrayConstraintsFromSetPhone($phone))) {
            throw new \InvalidArgumentException($phoneArrayErrorMessage, __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Add item to phone value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AddressSearchRowBasic
     */
    public function addToPhone(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The phone property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->phone[] = $item;
        return $this;
    }
    /**
     * Get state value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * This method is responsible for validating the values passed to the setState method
     * This method is willingly generated in order to preserve the one-line inline validation within the setState method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStateForArrayConstraintsFromSetState(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressSearchRowBasicStateItem) {
            // validation for constraint: itemType
            if (!$addressSearchRowBasicStateItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($addressSearchRowBasicStateItem) ? get_class($addressSearchRowBasicStateItem) : sprintf('%s(%s)', gettype($addressSearchRowBasicStateItem), var_export($addressSearchRowBasicStateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The state property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set state value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $state
     * @return \StructType\AddressSearchRowBasic
     */
    public function setState(array $state = array())
    {
        // validation for constraint: array
        if ('' !== ($stateArrayErrorMessage = self::validateStateForArrayConstraintsFromSetState($state))) {
            throw new \InvalidArgumentException($stateArrayErrorMessage, __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Add item to state value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AddressSearchRowBasic
     */
    public function addToState(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The state property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->state[] = $item;
        return $this;
    }
    /**
     * Get zip value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * This method is responsible for validating the values passed to the setZip method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZip method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZipForArrayConstraintsFromSetZip(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressSearchRowBasicZipItem) {
            // validation for constraint: itemType
            if (!$addressSearchRowBasicZipItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($addressSearchRowBasicZipItem) ? get_class($addressSearchRowBasicZipItem) : sprintf('%s(%s)', gettype($addressSearchRowBasicZipItem), var_export($addressSearchRowBasicZipItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zip property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zip value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $zip
     * @return \StructType\AddressSearchRowBasic
     */
    public function setZip(array $zip = array())
    {
        // validation for constraint: array
        if ('' !== ($zipArrayErrorMessage = self::validateZipForArrayConstraintsFromSetZip($zip))) {
            throw new \InvalidArgumentException($zipArrayErrorMessage, __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Add item to zip value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AddressSearchRowBasic
     */
    public function addToZip(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The zip property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zip[] = $item;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchColumnCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     * @return \StructType\AddressSearchRowBasic
     */
    public function setCustomFieldList(\StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
