<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddListRequest StructType
 * @subpackage Structs
 */
class AddListRequest extends AbstractStructBase
{
    /**
     * The record
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Record[]
     */
    public $record;
    /**
     * Constructor method for AddListRequest
     * @uses AddListRequest::setRecord()
     * @param \StructType\Record[] $record
     */
    public function __construct(array $record = array())
    {
        $this
            ->setRecord($record);
    }
    /**
     * Get record value
     * @return \StructType\Record[]
     */
    public function getRecord()
    {
        return $this->record;
    }
    /**
     * This method is responsible for validating the values passed to the setRecord method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecord method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecordForArrayConstraintsFromSetRecord(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addListRequestRecordItem) {
            // validation for constraint: itemType
            if (!$addListRequestRecordItem instanceof \StructType\Record) {
                $invalidValues[] = is_object($addListRequestRecordItem) ? get_class($addListRequestRecordItem) : sprintf('%s(%s)', gettype($addListRequestRecordItem), var_export($addListRequestRecordItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The record property can only contain items of type \StructType\Record, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set record value
     * @throws \InvalidArgumentException
     * @param \StructType\Record[] $record
     * @return \StructType\AddListRequest
     */
    public function setRecord(array $record = array())
    {
        // validation for constraint: array
        if ('' !== ($recordArrayErrorMessage = self::validateRecordForArrayConstraintsFromSetRecord($record))) {
            throw new \InvalidArgumentException($recordArrayErrorMessage, __LINE__);
        }
        $this->record = $record;
        return $this;
    }
    /**
     * Add item to record value
     * @throws \InvalidArgumentException
     * @param \StructType\Record $item
     * @return \StructType\AddListRequest
     */
    public function addToRecord(\StructType\Record $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Record) {
            throw new \InvalidArgumentException(sprintf('The record property can only contain items of type \StructType\Record, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->record[] = $item;
        return $this;
    }
}
