<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountSearchRowBasic StructType
 * @subpackage Structs
 */
class AccountSearchRowBasic extends SearchRowBasic
{
    /**
     * The accountingContext
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $accountingContext;
    /**
     * The balance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnDoubleField[]
     */
    public $balance;
    /**
     * The cashFlowRateType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $cashFlowRateType;
    /**
     * The category1099Misc
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $category1099Misc;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $description;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The generalRateType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $generalRateType;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isInactive;
    /**
     * The legalName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $legalName;
    /**
     * The locale
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $locale;
    /**
     * The localizedLegalName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $localizedLegalName;
    /**
     * The localizedName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $localizedName;
    /**
     * The localizedNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $localizedNumber;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $name;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $number;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $subsidiary;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnEnumSelectField[]
     */
    public $type;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchColumnCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for AccountSearchRowBasic
     * @uses AccountSearchRowBasic::setAccountingContext()
     * @uses AccountSearchRowBasic::setBalance()
     * @uses AccountSearchRowBasic::setCashFlowRateType()
     * @uses AccountSearchRowBasic::setCategory1099Misc()
     * @uses AccountSearchRowBasic::setDescription()
     * @uses AccountSearchRowBasic::setExternalId()
     * @uses AccountSearchRowBasic::setGeneralRateType()
     * @uses AccountSearchRowBasic::setInternalId()
     * @uses AccountSearchRowBasic::setIsInactive()
     * @uses AccountSearchRowBasic::setLegalName()
     * @uses AccountSearchRowBasic::setLocale()
     * @uses AccountSearchRowBasic::setLocalizedLegalName()
     * @uses AccountSearchRowBasic::setLocalizedName()
     * @uses AccountSearchRowBasic::setLocalizedNumber()
     * @uses AccountSearchRowBasic::setName()
     * @uses AccountSearchRowBasic::setNumber()
     * @uses AccountSearchRowBasic::setSubsidiary()
     * @uses AccountSearchRowBasic::setType()
     * @uses AccountSearchRowBasic::setCustomFieldList()
     * @param \StructType\SearchColumnStringField[] $accountingContext
     * @param \StructType\SearchColumnDoubleField[] $balance
     * @param \StructType\SearchColumnEnumSelectField[] $cashFlowRateType
     * @param \StructType\SearchColumnSelectField[] $category1099Misc
     * @param \StructType\SearchColumnStringField[] $description
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnEnumSelectField[] $generalRateType
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @param \StructType\SearchColumnStringField[] $legalName
     * @param \StructType\SearchColumnStringField[] $locale
     * @param \StructType\SearchColumnStringField[] $localizedLegalName
     * @param \StructType\SearchColumnStringField[] $localizedName
     * @param \StructType\SearchColumnStringField[] $localizedNumber
     * @param \StructType\SearchColumnStringField[] $name
     * @param \StructType\SearchColumnStringField[] $number
     * @param \StructType\SearchColumnSelectField[] $subsidiary
     * @param \StructType\SearchColumnEnumSelectField[] $type
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     */
    public function __construct(array $accountingContext = array(), array $balance = array(), array $cashFlowRateType = array(), array $category1099Misc = array(), array $description = array(), array $externalId = array(), array $generalRateType = array(), array $internalId = array(), array $isInactive = array(), array $legalName = array(), array $locale = array(), array $localizedLegalName = array(), array $localizedName = array(), array $localizedNumber = array(), array $name = array(), array $number = array(), array $subsidiary = array(), array $type = array(), \StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this
            ->setAccountingContext($accountingContext)
            ->setBalance($balance)
            ->setCashFlowRateType($cashFlowRateType)
            ->setCategory1099Misc($category1099Misc)
            ->setDescription($description)
            ->setExternalId($externalId)
            ->setGeneralRateType($generalRateType)
            ->setInternalId($internalId)
            ->setIsInactive($isInactive)
            ->setLegalName($legalName)
            ->setLocale($locale)
            ->setLocalizedLegalName($localizedLegalName)
            ->setLocalizedName($localizedName)
            ->setLocalizedNumber($localizedNumber)
            ->setName($name)
            ->setNumber($number)
            ->setSubsidiary($subsidiary)
            ->setType($type)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get accountingContext value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getAccountingContext()
    {
        return $this->accountingContext;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountingContext method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountingContext method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountingContextForArrayConstraintsFromSetAccountingContext(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountSearchRowBasicAccountingContextItem) {
            // validation for constraint: itemType
            if (!$accountSearchRowBasicAccountingContextItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($accountSearchRowBasicAccountingContextItem) ? get_class($accountSearchRowBasicAccountingContextItem) : sprintf('%s(%s)', gettype($accountSearchRowBasicAccountingContextItem), var_export($accountSearchRowBasicAccountingContextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The accountingContext property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set accountingContext value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $accountingContext
     * @return \StructType\AccountSearchRowBasic
     */
    public function setAccountingContext(array $accountingContext = array())
    {
        // validation for constraint: array
        if ('' !== ($accountingContextArrayErrorMessage = self::validateAccountingContextForArrayConstraintsFromSetAccountingContext($accountingContext))) {
            throw new \InvalidArgumentException($accountingContextArrayErrorMessage, __LINE__);
        }
        $this->accountingContext = $accountingContext;
        return $this;
    }
    /**
     * Add item to accountingContext value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AccountSearchRowBasic
     */
    public function addToAccountingContext(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The accountingContext property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->accountingContext[] = $item;
        return $this;
    }
    /**
     * Get balance value
     * @return \StructType\SearchColumnDoubleField[]|null
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * This method is responsible for validating the values passed to the setBalance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBalance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBalanceForArrayConstraintsFromSetBalance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountSearchRowBasicBalanceItem) {
            // validation for constraint: itemType
            if (!$accountSearchRowBasicBalanceItem instanceof \StructType\SearchColumnDoubleField) {
                $invalidValues[] = is_object($accountSearchRowBasicBalanceItem) ? get_class($accountSearchRowBasicBalanceItem) : sprintf('%s(%s)', gettype($accountSearchRowBasicBalanceItem), var_export($accountSearchRowBasicBalanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The balance property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set balance value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField[] $balance
     * @return \StructType\AccountSearchRowBasic
     */
    public function setBalance(array $balance = array())
    {
        // validation for constraint: array
        if ('' !== ($balanceArrayErrorMessage = self::validateBalanceForArrayConstraintsFromSetBalance($balance))) {
            throw new \InvalidArgumentException($balanceArrayErrorMessage, __LINE__);
        }
        $this->balance = $balance;
        return $this;
    }
    /**
     * Add item to balance value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnDoubleField $item
     * @return \StructType\AccountSearchRowBasic
     */
    public function addToBalance(\StructType\SearchColumnDoubleField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnDoubleField) {
            throw new \InvalidArgumentException(sprintf('The balance property can only contain items of type \StructType\SearchColumnDoubleField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->balance[] = $item;
        return $this;
    }
    /**
     * Get cashFlowRateType value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getCashFlowRateType()
    {
        return $this->cashFlowRateType;
    }
    /**
     * This method is responsible for validating the values passed to the setCashFlowRateType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCashFlowRateType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCashFlowRateTypeForArrayConstraintsFromSetCashFlowRateType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountSearchRowBasicCashFlowRateTypeItem) {
            // validation for constraint: itemType
            if (!$accountSearchRowBasicCashFlowRateTypeItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($accountSearchRowBasicCashFlowRateTypeItem) ? get_class($accountSearchRowBasicCashFlowRateTypeItem) : sprintf('%s(%s)', gettype($accountSearchRowBasicCashFlowRateTypeItem), var_export($accountSearchRowBasicCashFlowRateTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The cashFlowRateType property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set cashFlowRateType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $cashFlowRateType
     * @return \StructType\AccountSearchRowBasic
     */
    public function setCashFlowRateType(array $cashFlowRateType = array())
    {
        // validation for constraint: array
        if ('' !== ($cashFlowRateTypeArrayErrorMessage = self::validateCashFlowRateTypeForArrayConstraintsFromSetCashFlowRateType($cashFlowRateType))) {
            throw new \InvalidArgumentException($cashFlowRateTypeArrayErrorMessage, __LINE__);
        }
        $this->cashFlowRateType = $cashFlowRateType;
        return $this;
    }
    /**
     * Add item to cashFlowRateType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\AccountSearchRowBasic
     */
    public function addToCashFlowRateType(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The cashFlowRateType property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->cashFlowRateType[] = $item;
        return $this;
    }
    /**
     * Get category1099Misc value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getCategory1099Misc()
    {
        return $this->category1099Misc;
    }
    /**
     * This method is responsible for validating the values passed to the setCategory1099Misc method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategory1099Misc method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCategory1099MiscForArrayConstraintsFromSetCategory1099Misc(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountSearchRowBasicCategory1099MiscItem) {
            // validation for constraint: itemType
            if (!$accountSearchRowBasicCategory1099MiscItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($accountSearchRowBasicCategory1099MiscItem) ? get_class($accountSearchRowBasicCategory1099MiscItem) : sprintf('%s(%s)', gettype($accountSearchRowBasicCategory1099MiscItem), var_export($accountSearchRowBasicCategory1099MiscItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The category1099Misc property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set category1099Misc value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $category1099Misc
     * @return \StructType\AccountSearchRowBasic
     */
    public function setCategory1099Misc(array $category1099Misc = array())
    {
        // validation for constraint: array
        if ('' !== ($category1099MiscArrayErrorMessage = self::validateCategory1099MiscForArrayConstraintsFromSetCategory1099Misc($category1099Misc))) {
            throw new \InvalidArgumentException($category1099MiscArrayErrorMessage, __LINE__);
        }
        $this->category1099Misc = $category1099Misc;
        return $this;
    }
    /**
     * Add item to category1099Misc value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\AccountSearchRowBasic
     */
    public function addToCategory1099Misc(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The category1099Misc property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->category1099Misc[] = $item;
        return $this;
    }
    /**
     * Get description value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountSearchRowBasicDescriptionItem) {
            // validation for constraint: itemType
            if (!$accountSearchRowBasicDescriptionItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($accountSearchRowBasicDescriptionItem) ? get_class($accountSearchRowBasicDescriptionItem) : sprintf('%s(%s)', gettype($accountSearchRowBasicDescriptionItem), var_export($accountSearchRowBasicDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The description property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set description value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $description
     * @return \StructType\AccountSearchRowBasic
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Add item to description value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AccountSearchRowBasic
     */
    public function addToDescription(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The description property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->description[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$accountSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($accountSearchRowBasicExternalIdItem) ? get_class($accountSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($accountSearchRowBasicExternalIdItem), var_export($accountSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\AccountSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\AccountSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get generalRateType value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getGeneralRateType()
    {
        return $this->generalRateType;
    }
    /**
     * This method is responsible for validating the values passed to the setGeneralRateType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeneralRateType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGeneralRateTypeForArrayConstraintsFromSetGeneralRateType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountSearchRowBasicGeneralRateTypeItem) {
            // validation for constraint: itemType
            if (!$accountSearchRowBasicGeneralRateTypeItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($accountSearchRowBasicGeneralRateTypeItem) ? get_class($accountSearchRowBasicGeneralRateTypeItem) : sprintf('%s(%s)', gettype($accountSearchRowBasicGeneralRateTypeItem), var_export($accountSearchRowBasicGeneralRateTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The generalRateType property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set generalRateType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $generalRateType
     * @return \StructType\AccountSearchRowBasic
     */
    public function setGeneralRateType(array $generalRateType = array())
    {
        // validation for constraint: array
        if ('' !== ($generalRateTypeArrayErrorMessage = self::validateGeneralRateTypeForArrayConstraintsFromSetGeneralRateType($generalRateType))) {
            throw new \InvalidArgumentException($generalRateTypeArrayErrorMessage, __LINE__);
        }
        $this->generalRateType = $generalRateType;
        return $this;
    }
    /**
     * Add item to generalRateType value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\AccountSearchRowBasic
     */
    public function addToGeneralRateType(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The generalRateType property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->generalRateType[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$accountSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($accountSearchRowBasicInternalIdItem) ? get_class($accountSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($accountSearchRowBasicInternalIdItem), var_export($accountSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\AccountSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\AccountSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get isInactive value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * This method is responsible for validating the values passed to the setIsInactive method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsInactive method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsInactiveForArrayConstraintsFromSetIsInactive(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountSearchRowBasicIsInactiveItem) {
            // validation for constraint: itemType
            if (!$accountSearchRowBasicIsInactiveItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($accountSearchRowBasicIsInactiveItem) ? get_class($accountSearchRowBasicIsInactiveItem) : sprintf('%s(%s)', gettype($accountSearchRowBasicIsInactiveItem), var_export($accountSearchRowBasicIsInactiveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isInactive
     * @return \StructType\AccountSearchRowBasic
     */
    public function setIsInactive(array $isInactive = array())
    {
        // validation for constraint: array
        if ('' !== ($isInactiveArrayErrorMessage = self::validateIsInactiveForArrayConstraintsFromSetIsInactive($isInactive))) {
            throw new \InvalidArgumentException($isInactiveArrayErrorMessage, __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Add item to isInactive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\AccountSearchRowBasic
     */
    public function addToIsInactive(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isInactive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isInactive[] = $item;
        return $this;
    }
    /**
     * Get legalName value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getLegalName()
    {
        return $this->legalName;
    }
    /**
     * This method is responsible for validating the values passed to the setLegalName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLegalName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLegalNameForArrayConstraintsFromSetLegalName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountSearchRowBasicLegalNameItem) {
            // validation for constraint: itemType
            if (!$accountSearchRowBasicLegalNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($accountSearchRowBasicLegalNameItem) ? get_class($accountSearchRowBasicLegalNameItem) : sprintf('%s(%s)', gettype($accountSearchRowBasicLegalNameItem), var_export($accountSearchRowBasicLegalNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The legalName property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set legalName value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $legalName
     * @return \StructType\AccountSearchRowBasic
     */
    public function setLegalName(array $legalName = array())
    {
        // validation for constraint: array
        if ('' !== ($legalNameArrayErrorMessage = self::validateLegalNameForArrayConstraintsFromSetLegalName($legalName))) {
            throw new \InvalidArgumentException($legalNameArrayErrorMessage, __LINE__);
        }
        $this->legalName = $legalName;
        return $this;
    }
    /**
     * Add item to legalName value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AccountSearchRowBasic
     */
    public function addToLegalName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The legalName property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->legalName[] = $item;
        return $this;
    }
    /**
     * Get locale value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getLocale()
    {
        return $this->locale;
    }
    /**
     * This method is responsible for validating the values passed to the setLocale method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocale method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocaleForArrayConstraintsFromSetLocale(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountSearchRowBasicLocaleItem) {
            // validation for constraint: itemType
            if (!$accountSearchRowBasicLocaleItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($accountSearchRowBasicLocaleItem) ? get_class($accountSearchRowBasicLocaleItem) : sprintf('%s(%s)', gettype($accountSearchRowBasicLocaleItem), var_export($accountSearchRowBasicLocaleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The locale property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set locale value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $locale
     * @return \StructType\AccountSearchRowBasic
     */
    public function setLocale(array $locale = array())
    {
        // validation for constraint: array
        if ('' !== ($localeArrayErrorMessage = self::validateLocaleForArrayConstraintsFromSetLocale($locale))) {
            throw new \InvalidArgumentException($localeArrayErrorMessage, __LINE__);
        }
        $this->locale = $locale;
        return $this;
    }
    /**
     * Add item to locale value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AccountSearchRowBasic
     */
    public function addToLocale(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The locale property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->locale[] = $item;
        return $this;
    }
    /**
     * Get localizedLegalName value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getLocalizedLegalName()
    {
        return $this->localizedLegalName;
    }
    /**
     * This method is responsible for validating the values passed to the setLocalizedLegalName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocalizedLegalName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocalizedLegalNameForArrayConstraintsFromSetLocalizedLegalName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountSearchRowBasicLocalizedLegalNameItem) {
            // validation for constraint: itemType
            if (!$accountSearchRowBasicLocalizedLegalNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($accountSearchRowBasicLocalizedLegalNameItem) ? get_class($accountSearchRowBasicLocalizedLegalNameItem) : sprintf('%s(%s)', gettype($accountSearchRowBasicLocalizedLegalNameItem), var_export($accountSearchRowBasicLocalizedLegalNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The localizedLegalName property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set localizedLegalName value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $localizedLegalName
     * @return \StructType\AccountSearchRowBasic
     */
    public function setLocalizedLegalName(array $localizedLegalName = array())
    {
        // validation for constraint: array
        if ('' !== ($localizedLegalNameArrayErrorMessage = self::validateLocalizedLegalNameForArrayConstraintsFromSetLocalizedLegalName($localizedLegalName))) {
            throw new \InvalidArgumentException($localizedLegalNameArrayErrorMessage, __LINE__);
        }
        $this->localizedLegalName = $localizedLegalName;
        return $this;
    }
    /**
     * Add item to localizedLegalName value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AccountSearchRowBasic
     */
    public function addToLocalizedLegalName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The localizedLegalName property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->localizedLegalName[] = $item;
        return $this;
    }
    /**
     * Get localizedName value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getLocalizedName()
    {
        return $this->localizedName;
    }
    /**
     * This method is responsible for validating the values passed to the setLocalizedName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocalizedName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocalizedNameForArrayConstraintsFromSetLocalizedName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountSearchRowBasicLocalizedNameItem) {
            // validation for constraint: itemType
            if (!$accountSearchRowBasicLocalizedNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($accountSearchRowBasicLocalizedNameItem) ? get_class($accountSearchRowBasicLocalizedNameItem) : sprintf('%s(%s)', gettype($accountSearchRowBasicLocalizedNameItem), var_export($accountSearchRowBasicLocalizedNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The localizedName property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set localizedName value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $localizedName
     * @return \StructType\AccountSearchRowBasic
     */
    public function setLocalizedName(array $localizedName = array())
    {
        // validation for constraint: array
        if ('' !== ($localizedNameArrayErrorMessage = self::validateLocalizedNameForArrayConstraintsFromSetLocalizedName($localizedName))) {
            throw new \InvalidArgumentException($localizedNameArrayErrorMessage, __LINE__);
        }
        $this->localizedName = $localizedName;
        return $this;
    }
    /**
     * Add item to localizedName value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AccountSearchRowBasic
     */
    public function addToLocalizedName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The localizedName property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->localizedName[] = $item;
        return $this;
    }
    /**
     * Get localizedNumber value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getLocalizedNumber()
    {
        return $this->localizedNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setLocalizedNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocalizedNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocalizedNumberForArrayConstraintsFromSetLocalizedNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountSearchRowBasicLocalizedNumberItem) {
            // validation for constraint: itemType
            if (!$accountSearchRowBasicLocalizedNumberItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($accountSearchRowBasicLocalizedNumberItem) ? get_class($accountSearchRowBasicLocalizedNumberItem) : sprintf('%s(%s)', gettype($accountSearchRowBasicLocalizedNumberItem), var_export($accountSearchRowBasicLocalizedNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The localizedNumber property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set localizedNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $localizedNumber
     * @return \StructType\AccountSearchRowBasic
     */
    public function setLocalizedNumber(array $localizedNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($localizedNumberArrayErrorMessage = self::validateLocalizedNumberForArrayConstraintsFromSetLocalizedNumber($localizedNumber))) {
            throw new \InvalidArgumentException($localizedNumberArrayErrorMessage, __LINE__);
        }
        $this->localizedNumber = $localizedNumber;
        return $this;
    }
    /**
     * Add item to localizedNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AccountSearchRowBasic
     */
    public function addToLocalizedNumber(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The localizedNumber property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->localizedNumber[] = $item;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * This method is responsible for validating the values passed to the setName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameForArrayConstraintsFromSetName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountSearchRowBasicNameItem) {
            // validation for constraint: itemType
            if (!$accountSearchRowBasicNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($accountSearchRowBasicNameItem) ? get_class($accountSearchRowBasicNameItem) : sprintf('%s(%s)', gettype($accountSearchRowBasicNameItem), var_export($accountSearchRowBasicNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $name
     * @return \StructType\AccountSearchRowBasic
     */
    public function setName(array $name = array())
    {
        // validation for constraint: array
        if ('' !== ($nameArrayErrorMessage = self::validateNameForArrayConstraintsFromSetName($name))) {
            throw new \InvalidArgumentException($nameArrayErrorMessage, __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Add item to name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AccountSearchRowBasic
     */
    public function addToName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->name[] = $item;
        return $this;
    }
    /**
     * Get number value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * This method is responsible for validating the values passed to the setNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNumberForArrayConstraintsFromSetNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountSearchRowBasicNumberItem) {
            // validation for constraint: itemType
            if (!$accountSearchRowBasicNumberItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($accountSearchRowBasicNumberItem) ? get_class($accountSearchRowBasicNumberItem) : sprintf('%s(%s)', gettype($accountSearchRowBasicNumberItem), var_export($accountSearchRowBasicNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The number property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set number value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $number
     * @return \StructType\AccountSearchRowBasic
     */
    public function setNumber(array $number = array())
    {
        // validation for constraint: array
        if ('' !== ($numberArrayErrorMessage = self::validateNumberForArrayConstraintsFromSetNumber($number))) {
            throw new \InvalidArgumentException($numberArrayErrorMessage, __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Add item to number value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\AccountSearchRowBasic
     */
    public function addToNumber(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The number property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->number[] = $item;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * This method is responsible for validating the values passed to the setSubsidiary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubsidiary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubsidiaryForArrayConstraintsFromSetSubsidiary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountSearchRowBasicSubsidiaryItem) {
            // validation for constraint: itemType
            if (!$accountSearchRowBasicSubsidiaryItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($accountSearchRowBasicSubsidiaryItem) ? get_class($accountSearchRowBasicSubsidiaryItem) : sprintf('%s(%s)', gettype($accountSearchRowBasicSubsidiaryItem), var_export($accountSearchRowBasicSubsidiaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $subsidiary
     * @return \StructType\AccountSearchRowBasic
     */
    public function setSubsidiary(array $subsidiary = array())
    {
        // validation for constraint: array
        if ('' !== ($subsidiaryArrayErrorMessage = self::validateSubsidiaryForArrayConstraintsFromSetSubsidiary($subsidiary))) {
            throw new \InvalidArgumentException($subsidiaryArrayErrorMessage, __LINE__);
        }
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Add item to subsidiary value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\AccountSearchRowBasic
     */
    public function addToSubsidiary(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The subsidiary property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subsidiary[] = $item;
        return $this;
    }
    /**
     * Get type value
     * @return \StructType\SearchColumnEnumSelectField[]|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * This method is responsible for validating the values passed to the setType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeForArrayConstraintsFromSetType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountSearchRowBasicTypeItem) {
            // validation for constraint: itemType
            if (!$accountSearchRowBasicTypeItem instanceof \StructType\SearchColumnEnumSelectField) {
                $invalidValues[] = is_object($accountSearchRowBasicTypeItem) ? get_class($accountSearchRowBasicTypeItem) : sprintf('%s(%s)', gettype($accountSearchRowBasicTypeItem), var_export($accountSearchRowBasicTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The type property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set type value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField[] $type
     * @return \StructType\AccountSearchRowBasic
     */
    public function setType(array $type = array())
    {
        // validation for constraint: array
        if ('' !== ($typeArrayErrorMessage = self::validateTypeForArrayConstraintsFromSetType($type))) {
            throw new \InvalidArgumentException($typeArrayErrorMessage, __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Add item to type value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnEnumSelectField $item
     * @return \StructType\AccountSearchRowBasic
     */
    public function addToType(\StructType\SearchColumnEnumSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnEnumSelectField) {
            throw new \InvalidArgumentException(sprintf('The type property can only contain items of type \StructType\SearchColumnEnumSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->type[] = $item;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchColumnCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchColumnCustomFieldList $customFieldList
     * @return \StructType\AccountSearchRowBasic
     */
    public function setCustomFieldList(\StructType\SearchColumnCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
