<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TransferOrderOrderStatus EnumType
 * @subpackage Enumerations
 */
class TransferOrderOrderStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value '_pendingApproval'
     * @return string '_pendingApproval'
     */
    const VALUE_PENDING_APPROVAL = '_pendingApproval';
    /**
     * Constant for value '_pendingFulfillment'
     * @return string '_pendingFulfillment'
     */
    const VALUE_PENDING_FULFILLMENT = '_pendingFulfillment';
    /**
     * Constant for value '_rejected'
     * @return string '_rejected'
     */
    const VALUE_REJECTED = '_rejected';
    /**
     * Constant for value '_partiallyFulfilled'
     * @return string '_partiallyFulfilled'
     */
    const VALUE_PARTIALLY_FULFILLED = '_partiallyFulfilled';
    /**
     * Constant for value '_pendingReceiptPartFulfilled'
     * @return string '_pendingReceiptPartFulfilled'
     */
    const VALUE_PENDING_RECEIPT_PART_FULFILLED = '_pendingReceiptPartFulfilled';
    /**
     * Constant for value '_pendingReceipt'
     * @return string '_pendingReceipt'
     */
    const VALUE_PENDING_RECEIPT = '_pendingReceipt';
    /**
     * Constant for value '_received'
     * @return string '_received'
     */
    const VALUE_RECEIVED = '_received';
    /**
     * Constant for value '_closed'
     * @return string '_closed'
     */
    const VALUE_CLOSED = '_closed';
    /**
     * Constant for value '_undefined'
     * @return string '_undefined'
     */
    const VALUE_UNDEFINED = '_undefined';
    /**
     * Return allowed values
     * @uses self::VALUE_PENDING_APPROVAL
     * @uses self::VALUE_PENDING_FULFILLMENT
     * @uses self::VALUE_REJECTED
     * @uses self::VALUE_PARTIALLY_FULFILLED
     * @uses self::VALUE_PENDING_RECEIPT_PART_FULFILLED
     * @uses self::VALUE_PENDING_RECEIPT
     * @uses self::VALUE_RECEIVED
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_UNDEFINED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PENDING_APPROVAL,
            self::VALUE_PENDING_FULFILLMENT,
            self::VALUE_REJECTED,
            self::VALUE_PARTIALLY_FULFILLED,
            self::VALUE_PENDING_RECEIPT_PART_FULFILLED,
            self::VALUE_PENDING_RECEIPT,
            self::VALUE_RECEIVED,
            self::VALUE_CLOSED,
            self::VALUE_UNDEFINED,
        );
    }
}
