<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PurchaseOrderOrderStatus EnumType
 * @subpackage Enumerations
 */
class PurchaseOrderOrderStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value '_closed'
     * @return string '_closed'
     */
    const VALUE_CLOSED = '_closed';
    /**
     * Constant for value '_fullyBilled'
     * @return string '_fullyBilled'
     */
    const VALUE_FULLY_BILLED = '_fullyBilled';
    /**
     * Constant for value '_partiallyReceived'
     * @return string '_partiallyReceived'
     */
    const VALUE_PARTIALLY_RECEIVED = '_partiallyReceived';
    /**
     * Constant for value '_pendingBillingPartiallyReceived'
     * @return string '_pendingBillingPartiallyReceived'
     */
    const VALUE_PENDING_BILLING_PARTIALLY_RECEIVED = '_pendingBillingPartiallyReceived';
    /**
     * Constant for value '_pendingBilling'
     * @return string '_pendingBilling'
     */
    const VALUE_PENDING_BILLING = '_pendingBilling';
    /**
     * Constant for value '_pendingReceipt'
     * @return string '_pendingReceipt'
     */
    const VALUE_PENDING_RECEIPT = '_pendingReceipt';
    /**
     * Constant for value '_pendingSupervisorApproval'
     * @return string '_pendingSupervisorApproval'
     */
    const VALUE_PENDING_SUPERVISOR_APPROVAL = '_pendingSupervisorApproval';
    /**
     * Constant for value '_rejectedBySupervisor'
     * @return string '_rejectedBySupervisor'
     */
    const VALUE_REJECTED_BY_SUPERVISOR = '_rejectedBySupervisor';
    /**
     * Return allowed values
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_FULLY_BILLED
     * @uses self::VALUE_PARTIALLY_RECEIVED
     * @uses self::VALUE_PENDING_BILLING_PARTIALLY_RECEIVED
     * @uses self::VALUE_PENDING_BILLING
     * @uses self::VALUE_PENDING_RECEIPT
     * @uses self::VALUE_PENDING_SUPERVISOR_APPROVAL
     * @uses self::VALUE_REJECTED_BY_SUPERVISOR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLOSED,
            self::VALUE_FULLY_BILLED,
            self::VALUE_PARTIALLY_RECEIVED,
            self::VALUE_PENDING_BILLING_PARTIALLY_RECEIVED,
            self::VALUE_PENDING_BILLING,
            self::VALUE_PENDING_RECEIPT,
            self::VALUE_PENDING_SUPERVISOR_APPROVAL,
            self::VALUE_REJECTED_BY_SUPERVISOR,
        );
    }
}
