<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PaymentInstrumentType EnumType
 * @subpackage Enumerations
 */
class PaymentInstrumentType extends AbstractStructEnumBase
{
    /**
     * Constant for value '_paymentCard'
     * @return string '_paymentCard'
     */
    const VALUE_PAYMENT_CARD = '_paymentCard';
    /**
     * Constant for value '_generalToken'
     * @return string '_generalToken'
     */
    const VALUE_GENERAL_TOKEN = '_generalToken';
    /**
     * Constant for value '_paymentCardToken'
     * @return string '_paymentCardToken'
     */
    const VALUE_PAYMENT_CARD_TOKEN = '_paymentCardToken';
    /**
     * Constant for value '_paymentCardSwipe'
     * @return string '_paymentCardSwipe'
     */
    const VALUE_PAYMENT_CARD_SWIPE = '_paymentCardSwipe';
    /**
     * Constant for value '_emv'
     * @return string '_emv'
     */
    const VALUE_EMV = '_emv';
    /**
     * Constant for value '_externalCheckout'
     * @return string '_externalCheckout'
     */
    const VALUE_EXTERNAL_CHECKOUT = '_externalCheckout';
    /**
     * Constant for value '_cash'
     * @return string '_cash'
     */
    const VALUE_CASH = '_cash';
    /**
     * Constant for value '_check'
     * @return string '_check'
     */
    const VALUE_CHECK = '_check';
    /**
     * Constant for value '_offline'
     * @return string '_offline'
     */
    const VALUE_OFFLINE = '_offline';
    /**
     * Constant for value '_payByReference'
     * @return string '_payByReference'
     */
    const VALUE_PAY_BY_REFERENCE = '_payByReference';
    /**
     * Constant for value '_ach'
     * @return string '_ach'
     */
    const VALUE_ACH = '_ach';
    /**
     * Constant for value '_payPal'
     * @return string '_payPal'
     */
    const VALUE_PAY_PAL = '_payPal';
    /**
     * Return allowed values
     * @uses self::VALUE_PAYMENT_CARD
     * @uses self::VALUE_GENERAL_TOKEN
     * @uses self::VALUE_PAYMENT_CARD_TOKEN
     * @uses self::VALUE_PAYMENT_CARD_SWIPE
     * @uses self::VALUE_EMV
     * @uses self::VALUE_EXTERNAL_CHECKOUT
     * @uses self::VALUE_CASH
     * @uses self::VALUE_CHECK
     * @uses self::VALUE_OFFLINE
     * @uses self::VALUE_PAY_BY_REFERENCE
     * @uses self::VALUE_ACH
     * @uses self::VALUE_PAY_PAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PAYMENT_CARD,
            self::VALUE_GENERAL_TOKEN,
            self::VALUE_PAYMENT_CARD_TOKEN,
            self::VALUE_PAYMENT_CARD_SWIPE,
            self::VALUE_EMV,
            self::VALUE_EXTERNAL_CHECKOUT,
            self::VALUE_CASH,
            self::VALUE_CHECK,
            self::VALUE_OFFLINE,
            self::VALUE_PAY_BY_REFERENCE,
            self::VALUE_ACH,
            self::VALUE_PAY_PAL,
        );
    }
}
