<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PaymentInstrumentState EnumType
 * @subpackage Enumerations
 */
class PaymentInstrumentState extends AbstractStructEnumBase
{
    /**
     * Constant for value '_expired'
     * @return string '_expired'
     */
    const VALUE_EXPIRED = '_expired';
    /**
     * Constant for value '_invalid'
     * @return string '_invalid'
     */
    const VALUE_INVALID = '_invalid';
    /**
     * Constant for value '_unknown'
     * @return string '_unknown'
     */
    const VALUE_UNKNOWN = '_unknown';
    /**
     * Constant for value '_verified'
     * @return string '_verified'
     */
    const VALUE_VERIFIED = '_verified';
    /**
     * Return allowed values
     * @uses self::VALUE_EXPIRED
     * @uses self::VALUE_INVALID
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_VERIFIED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EXPIRED,
            self::VALUE_INVALID,
            self::VALUE_UNKNOWN,
            self::VALUE_VERIFIED,
        );
    }
}
