<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for IssueEventStatus EnumType
 * @subpackage Enumerations
 */
class IssueEventStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value '_closed'
     * @return string '_closed'
     */
    const VALUE_CLOSED = '_closed';
    /**
     * Constant for value '_onHold'
     * @return string '_onHold'
     */
    const VALUE_ON_HOLD = '_onHold';
    /**
     * Constant for value '_open'
     * @return string '_open'
     */
    const VALUE_OPEN = '_open';
    /**
     * Constant for value '_resolved'
     * @return string '_resolved'
     */
    const VALUE_RESOLVED = '_resolved';
    /**
     * Return allowed values
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_ON_HOLD
     * @uses self::VALUE_OPEN
     * @uses self::VALUE_RESOLVED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLOSED,
            self::VALUE_ON_HOLD,
            self::VALUE_OPEN,
            self::VALUE_RESOLVED,
        );
    }
}
