<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for CampaignResponse EnumType
 * @subpackage Enumerations
 */
class CampaignResponse extends AbstractStructEnumBase
{
    /**
     * Constant for value '_clickedThrough'
     * @return string '_clickedThrough'
     */
    const VALUE_CLICKED_THROUGH = '_clickedThrough';
    /**
     * Constant for value '_failedDeliveryFailure'
     * @return string '_failedDeliveryFailure'
     */
    const VALUE_FAILED_DELIVERY_FAILURE = '_failedDeliveryFailure';
    /**
     * Constant for value '_failedInvalidAddress'
     * @return string '_failedInvalidAddress'
     */
    const VALUE_FAILED_INVALID_ADDRESS = '_failedInvalidAddress';
    /**
     * Constant for value '_failedOther'
     * @return string '_failedOther'
     */
    const VALUE_FAILED_OTHER = '_failedOther';
    /**
     * Constant for value '_failedSpam'
     * @return string '_failedSpam'
     */
    const VALUE_FAILED_SPAM = '_failedSpam';
    /**
     * Constant for value '_failedTemplateError'
     * @return string '_failedTemplateError'
     */
    const VALUE_FAILED_TEMPLATE_ERROR = '_failedTemplateError';
    /**
     * Constant for value '_failedUnexpectedError'
     * @return string '_failedUnexpectedError'
     */
    const VALUE_FAILED_UNEXPECTED_ERROR = '_failedUnexpectedError';
    /**
     * Constant for value '_invalidSenderAddress'
     * @return string '_invalidSenderAddress'
     */
    const VALUE_INVALID_SENDER_ADDRESS = '_invalidSenderAddress';
    /**
     * Constant for value '_mailboxDisabled'
     * @return string '_mailboxDisabled'
     */
    const VALUE_MAILBOX_DISABLED = '_mailboxDisabled';
    /**
     * Constant for value '_mailboxIsFull'
     * @return string '_mailboxIsFull'
     */
    const VALUE_MAILBOX_IS_FULL = '_mailboxIsFull';
    /**
     * Constant for value '_mailboxNotAcceptingMessages'
     * @return string '_mailboxNotAcceptingMessages'
     */
    const VALUE_MAILBOX_NOT_ACCEPTING_MESSAGES = '_mailboxNotAcceptingMessages';
    /**
     * Constant for value '_mailProtocolIssues'
     * @return string '_mailProtocolIssues'
     */
    const VALUE_MAIL_PROTOCOL_ISSUES = '_mailProtocolIssues';
    /**
     * Constant for value '_mediaError'
     * @return string '_mediaError'
     */
    const VALUE_MEDIA_ERROR = '_mediaError';
    /**
     * Constant for value '_messageExceedsSizeLengthLimits'
     * @return string '_messageExceedsSizeLengthLimits'
     */
    const VALUE_MESSAGE_EXCEEDS_SIZE_LENGTH_LIMITS = '_messageExceedsSizeLengthLimits';
    /**
     * Constant for value '_networkServerIssues'
     * @return string '_networkServerIssues'
     */
    const VALUE_NETWORK_SERVER_ISSUES = '_networkServerIssues';
    /**
     * Constant for value '_opened'
     * @return string '_opened'
     */
    const VALUE_OPENED = '_opened';
    /**
     * Constant for value '_purchased'
     * @return string '_purchased'
     */
    const VALUE_PURCHASED = '_purchased';
    /**
     * Constant for value '_queued'
     * @return string '_queued'
     */
    const VALUE_QUEUED = '_queued';
    /**
     * Constant for value '_received'
     * @return string '_received'
     */
    const VALUE_RECEIVED = '_received';
    /**
     * Constant for value '_responded'
     * @return string '_responded'
     */
    const VALUE_RESPONDED = '_responded';
    /**
     * Constant for value '_securityIssues'
     * @return string '_securityIssues'
     */
    const VALUE_SECURITY_ISSUES = '_securityIssues';
    /**
     * Constant for value '_sent'
     * @return string '_sent'
     */
    const VALUE_SENT = '_sent';
    /**
     * Constant for value '_skippedDueToPreviousHardBounce'
     * @return string '_skippedDueToPreviousHardBounce'
     */
    const VALUE_SKIPPED_DUE_TO_PREVIOUS_HARD_BOUNCE = '_skippedDueToPreviousHardBounce';
    /**
     * Constant for value '_subscribed'
     * @return string '_subscribed'
     */
    const VALUE_SUBSCRIBED = '_subscribed';
    /**
     * Constant for value '_tooManyRecipients'
     * @return string '_tooManyRecipients'
     */
    const VALUE_TOO_MANY_RECIPIENTS = '_tooManyRecipients';
    /**
     * Constant for value '_unsubscribed'
     * @return string '_unsubscribed'
     */
    const VALUE_UNSUBSCRIBED = '_unsubscribed';
    /**
     * Constant for value '_unsubscribedByFeedbackLoop'
     * @return string '_unsubscribedByFeedbackLoop'
     */
    const VALUE_UNSUBSCRIBED_BY_FEEDBACK_LOOP = '_unsubscribedByFeedbackLoop';
    /**
     * Return allowed values
     * @uses self::VALUE_CLICKED_THROUGH
     * @uses self::VALUE_FAILED_DELIVERY_FAILURE
     * @uses self::VALUE_FAILED_INVALID_ADDRESS
     * @uses self::VALUE_FAILED_OTHER
     * @uses self::VALUE_FAILED_SPAM
     * @uses self::VALUE_FAILED_TEMPLATE_ERROR
     * @uses self::VALUE_FAILED_UNEXPECTED_ERROR
     * @uses self::VALUE_INVALID_SENDER_ADDRESS
     * @uses self::VALUE_MAILBOX_DISABLED
     * @uses self::VALUE_MAILBOX_IS_FULL
     * @uses self::VALUE_MAILBOX_NOT_ACCEPTING_MESSAGES
     * @uses self::VALUE_MAIL_PROTOCOL_ISSUES
     * @uses self::VALUE_MEDIA_ERROR
     * @uses self::VALUE_MESSAGE_EXCEEDS_SIZE_LENGTH_LIMITS
     * @uses self::VALUE_NETWORK_SERVER_ISSUES
     * @uses self::VALUE_OPENED
     * @uses self::VALUE_PURCHASED
     * @uses self::VALUE_QUEUED
     * @uses self::VALUE_RECEIVED
     * @uses self::VALUE_RESPONDED
     * @uses self::VALUE_SECURITY_ISSUES
     * @uses self::VALUE_SENT
     * @uses self::VALUE_SKIPPED_DUE_TO_PREVIOUS_HARD_BOUNCE
     * @uses self::VALUE_SUBSCRIBED
     * @uses self::VALUE_TOO_MANY_RECIPIENTS
     * @uses self::VALUE_UNSUBSCRIBED
     * @uses self::VALUE_UNSUBSCRIBED_BY_FEEDBACK_LOOP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLICKED_THROUGH,
            self::VALUE_FAILED_DELIVERY_FAILURE,
            self::VALUE_FAILED_INVALID_ADDRESS,
            self::VALUE_FAILED_OTHER,
            self::VALUE_FAILED_SPAM,
            self::VALUE_FAILED_TEMPLATE_ERROR,
            self::VALUE_FAILED_UNEXPECTED_ERROR,
            self::VALUE_INVALID_SENDER_ADDRESS,
            self::VALUE_MAILBOX_DISABLED,
            self::VALUE_MAILBOX_IS_FULL,
            self::VALUE_MAILBOX_NOT_ACCEPTING_MESSAGES,
            self::VALUE_MAIL_PROTOCOL_ISSUES,
            self::VALUE_MEDIA_ERROR,
            self::VALUE_MESSAGE_EXCEEDS_SIZE_LENGTH_LIMITS,
            self::VALUE_NETWORK_SERVER_ISSUES,
            self::VALUE_OPENED,
            self::VALUE_PURCHASED,
            self::VALUE_QUEUED,
            self::VALUE_RECEIVED,
            self::VALUE_RESPONDED,
            self::VALUE_SECURITY_ISSUES,
            self::VALUE_SENT,
            self::VALUE_SKIPPED_DUE_TO_PREVIOUS_HARD_BOUNCE,
            self::VALUE_SUBSCRIBED,
            self::VALUE_TOO_MANY_RECIPIENTS,
            self::VALUE_UNSUBSCRIBED,
            self::VALUE_UNSUBSCRIBED_BY_FEEDBACK_LOOP,
        );
    }
}
