<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for AsyncStatusType EnumType
 * @subpackage Enumerations
 */
class AsyncStatusType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'failed'
     * @return string 'failed'
     */
    const VALUE_FAILED = 'failed';
    /**
     * Constant for value 'finishedWithErrors'
     * @return string 'finishedWithErrors'
     */
    const VALUE_FINISHED_WITH_ERRORS = 'finishedWithErrors';
    /**
     * Constant for value 'pending'
     * @return string 'pending'
     */
    const VALUE_PENDING = 'pending';
    /**
     * Constant for value 'processing'
     * @return string 'processing'
     */
    const VALUE_PROCESSING = 'processing';
    /**
     * Constant for value 'finished'
     * @return string 'finished'
     */
    const VALUE_FINISHED = 'finished';
    /**
     * Constant for value 'retry'
     * @return string 'retry'
     */
    const VALUE_RETRY = 'retry';
    /**
     * Return allowed values
     * @uses self::VALUE_FAILED
     * @uses self::VALUE_FINISHED_WITH_ERRORS
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_PROCESSING
     * @uses self::VALUE_FINISHED
     * @uses self::VALUE_RETRY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FAILED,
            self::VALUE_FINISHED_WITH_ERRORS,
            self::VALUE_PENDING,
            self::VALUE_PROCESSING,
            self::VALUE_FINISHED,
            self::VALUE_RETRY,
        );
    }
}
