<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WorkOrderCompletionOperation StructType
 * @subpackage Structs
 */
class WorkOrderCompletionOperation extends AbstractStructBase
{
    /**
     * The operationSequence
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $operationSequence;
    /**
     * The operationName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $operationName;
    /**
     * The workCenter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $workCenter;
    /**
     * The machineResources
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $machineResources;
    /**
     * The laborResources
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $laborResources;
    /**
     * The inputQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $inputQuantity;
    /**
     * The quantityRemaining
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $quantityRemaining;
    /**
     * The predecessorCompletedQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $predecessorCompletedQuantity;
    /**
     * The completedQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $completedQuantity;
    /**
     * The recordSetup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $recordSetup;
    /**
     * The machineSetupTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $machineSetupTime;
    /**
     * The laborSetupTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $laborSetupTime;
    /**
     * The machineRunTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $machineRunTime;
    /**
     * The laborRunTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $laborRunTime;
    /**
     * Constructor method for WorkOrderCompletionOperation
     * @uses WorkOrderCompletionOperation::setOperationSequence()
     * @uses WorkOrderCompletionOperation::setOperationName()
     * @uses WorkOrderCompletionOperation::setWorkCenter()
     * @uses WorkOrderCompletionOperation::setMachineResources()
     * @uses WorkOrderCompletionOperation::setLaborResources()
     * @uses WorkOrderCompletionOperation::setInputQuantity()
     * @uses WorkOrderCompletionOperation::setQuantityRemaining()
     * @uses WorkOrderCompletionOperation::setPredecessorCompletedQuantity()
     * @uses WorkOrderCompletionOperation::setCompletedQuantity()
     * @uses WorkOrderCompletionOperation::setRecordSetup()
     * @uses WorkOrderCompletionOperation::setMachineSetupTime()
     * @uses WorkOrderCompletionOperation::setLaborSetupTime()
     * @uses WorkOrderCompletionOperation::setMachineRunTime()
     * @uses WorkOrderCompletionOperation::setLaborRunTime()
     * @param int $operationSequence
     * @param string $operationName
     * @param string $workCenter
     * @param float $machineResources
     * @param float $laborResources
     * @param float $inputQuantity
     * @param float $quantityRemaining
     * @param float $predecessorCompletedQuantity
     * @param float $completedQuantity
     * @param bool $recordSetup
     * @param float $machineSetupTime
     * @param float $laborSetupTime
     * @param float $machineRunTime
     * @param float $laborRunTime
     */
    public function __construct($operationSequence = null, $operationName = null, $workCenter = null, $machineResources = null, $laborResources = null, $inputQuantity = null, $quantityRemaining = null, $predecessorCompletedQuantity = null, $completedQuantity = null, $recordSetup = null, $machineSetupTime = null, $laborSetupTime = null, $machineRunTime = null, $laborRunTime = null)
    {
        $this
            ->setOperationSequence($operationSequence)
            ->setOperationName($operationName)
            ->setWorkCenter($workCenter)
            ->setMachineResources($machineResources)
            ->setLaborResources($laborResources)
            ->setInputQuantity($inputQuantity)
            ->setQuantityRemaining($quantityRemaining)
            ->setPredecessorCompletedQuantity($predecessorCompletedQuantity)
            ->setCompletedQuantity($completedQuantity)
            ->setRecordSetup($recordSetup)
            ->setMachineSetupTime($machineSetupTime)
            ->setLaborSetupTime($laborSetupTime)
            ->setMachineRunTime($machineRunTime)
            ->setLaborRunTime($laborRunTime);
    }
    /**
     * Get operationSequence value
     * @return int|null
     */
    public function getOperationSequence()
    {
        return $this->operationSequence;
    }
    /**
     * Set operationSequence value
     * @param int $operationSequence
     * @return \StructType\WorkOrderCompletionOperation
     */
    public function setOperationSequence($operationSequence = null)
    {
        // validation for constraint: int
        if (!is_null($operationSequence) && !(is_int($operationSequence) || ctype_digit($operationSequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($operationSequence, true), gettype($operationSequence)), __LINE__);
        }
        $this->operationSequence = $operationSequence;
        return $this;
    }
    /**
     * Get operationName value
     * @return string|null
     */
    public function getOperationName()
    {
        return $this->operationName;
    }
    /**
     * Set operationName value
     * @param string $operationName
     * @return \StructType\WorkOrderCompletionOperation
     */
    public function setOperationName($operationName = null)
    {
        // validation for constraint: string
        if (!is_null($operationName) && !is_string($operationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationName, true), gettype($operationName)), __LINE__);
        }
        $this->operationName = $operationName;
        return $this;
    }
    /**
     * Get workCenter value
     * @return string|null
     */
    public function getWorkCenter()
    {
        return $this->workCenter;
    }
    /**
     * Set workCenter value
     * @param string $workCenter
     * @return \StructType\WorkOrderCompletionOperation
     */
    public function setWorkCenter($workCenter = null)
    {
        // validation for constraint: string
        if (!is_null($workCenter) && !is_string($workCenter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workCenter, true), gettype($workCenter)), __LINE__);
        }
        $this->workCenter = $workCenter;
        return $this;
    }
    /**
     * Get machineResources value
     * @return float|null
     */
    public function getMachineResources()
    {
        return $this->machineResources;
    }
    /**
     * Set machineResources value
     * @param float $machineResources
     * @return \StructType\WorkOrderCompletionOperation
     */
    public function setMachineResources($machineResources = null)
    {
        // validation for constraint: float
        if (!is_null($machineResources) && !(is_float($machineResources) || is_numeric($machineResources))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($machineResources, true), gettype($machineResources)), __LINE__);
        }
        $this->machineResources = $machineResources;
        return $this;
    }
    /**
     * Get laborResources value
     * @return float|null
     */
    public function getLaborResources()
    {
        return $this->laborResources;
    }
    /**
     * Set laborResources value
     * @param float $laborResources
     * @return \StructType\WorkOrderCompletionOperation
     */
    public function setLaborResources($laborResources = null)
    {
        // validation for constraint: float
        if (!is_null($laborResources) && !(is_float($laborResources) || is_numeric($laborResources))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($laborResources, true), gettype($laborResources)), __LINE__);
        }
        $this->laborResources = $laborResources;
        return $this;
    }
    /**
     * Get inputQuantity value
     * @return float|null
     */
    public function getInputQuantity()
    {
        return $this->inputQuantity;
    }
    /**
     * Set inputQuantity value
     * @param float $inputQuantity
     * @return \StructType\WorkOrderCompletionOperation
     */
    public function setInputQuantity($inputQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($inputQuantity) && !(is_float($inputQuantity) || is_numeric($inputQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inputQuantity, true), gettype($inputQuantity)), __LINE__);
        }
        $this->inputQuantity = $inputQuantity;
        return $this;
    }
    /**
     * Get quantityRemaining value
     * @return float|null
     */
    public function getQuantityRemaining()
    {
        return $this->quantityRemaining;
    }
    /**
     * Set quantityRemaining value
     * @param float $quantityRemaining
     * @return \StructType\WorkOrderCompletionOperation
     */
    public function setQuantityRemaining($quantityRemaining = null)
    {
        // validation for constraint: float
        if (!is_null($quantityRemaining) && !(is_float($quantityRemaining) || is_numeric($quantityRemaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityRemaining, true), gettype($quantityRemaining)), __LINE__);
        }
        $this->quantityRemaining = $quantityRemaining;
        return $this;
    }
    /**
     * Get predecessorCompletedQuantity value
     * @return float|null
     */
    public function getPredecessorCompletedQuantity()
    {
        return $this->predecessorCompletedQuantity;
    }
    /**
     * Set predecessorCompletedQuantity value
     * @param float $predecessorCompletedQuantity
     * @return \StructType\WorkOrderCompletionOperation
     */
    public function setPredecessorCompletedQuantity($predecessorCompletedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($predecessorCompletedQuantity) && !(is_float($predecessorCompletedQuantity) || is_numeric($predecessorCompletedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($predecessorCompletedQuantity, true), gettype($predecessorCompletedQuantity)), __LINE__);
        }
        $this->predecessorCompletedQuantity = $predecessorCompletedQuantity;
        return $this;
    }
    /**
     * Get completedQuantity value
     * @return float|null
     */
    public function getCompletedQuantity()
    {
        return $this->completedQuantity;
    }
    /**
     * Set completedQuantity value
     * @param float $completedQuantity
     * @return \StructType\WorkOrderCompletionOperation
     */
    public function setCompletedQuantity($completedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($completedQuantity) && !(is_float($completedQuantity) || is_numeric($completedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($completedQuantity, true), gettype($completedQuantity)), __LINE__);
        }
        $this->completedQuantity = $completedQuantity;
        return $this;
    }
    /**
     * Get recordSetup value
     * @return bool|null
     */
    public function getRecordSetup()
    {
        return $this->recordSetup;
    }
    /**
     * Set recordSetup value
     * @param bool $recordSetup
     * @return \StructType\WorkOrderCompletionOperation
     */
    public function setRecordSetup($recordSetup = null)
    {
        // validation for constraint: boolean
        if (!is_null($recordSetup) && !is_bool($recordSetup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recordSetup, true), gettype($recordSetup)), __LINE__);
        }
        $this->recordSetup = $recordSetup;
        return $this;
    }
    /**
     * Get machineSetupTime value
     * @return float|null
     */
    public function getMachineSetupTime()
    {
        return $this->machineSetupTime;
    }
    /**
     * Set machineSetupTime value
     * @param float $machineSetupTime
     * @return \StructType\WorkOrderCompletionOperation
     */
    public function setMachineSetupTime($machineSetupTime = null)
    {
        // validation for constraint: float
        if (!is_null($machineSetupTime) && !(is_float($machineSetupTime) || is_numeric($machineSetupTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($machineSetupTime, true), gettype($machineSetupTime)), __LINE__);
        }
        $this->machineSetupTime = $machineSetupTime;
        return $this;
    }
    /**
     * Get laborSetupTime value
     * @return float|null
     */
    public function getLaborSetupTime()
    {
        return $this->laborSetupTime;
    }
    /**
     * Set laborSetupTime value
     * @param float $laborSetupTime
     * @return \StructType\WorkOrderCompletionOperation
     */
    public function setLaborSetupTime($laborSetupTime = null)
    {
        // validation for constraint: float
        if (!is_null($laborSetupTime) && !(is_float($laborSetupTime) || is_numeric($laborSetupTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($laborSetupTime, true), gettype($laborSetupTime)), __LINE__);
        }
        $this->laborSetupTime = $laborSetupTime;
        return $this;
    }
    /**
     * Get machineRunTime value
     * @return float|null
     */
    public function getMachineRunTime()
    {
        return $this->machineRunTime;
    }
    /**
     * Set machineRunTime value
     * @param float $machineRunTime
     * @return \StructType\WorkOrderCompletionOperation
     */
    public function setMachineRunTime($machineRunTime = null)
    {
        // validation for constraint: float
        if (!is_null($machineRunTime) && !(is_float($machineRunTime) || is_numeric($machineRunTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($machineRunTime, true), gettype($machineRunTime)), __LINE__);
        }
        $this->machineRunTime = $machineRunTime;
        return $this;
    }
    /**
     * Get laborRunTime value
     * @return float|null
     */
    public function getLaborRunTime()
    {
        return $this->laborRunTime;
    }
    /**
     * Set laborRunTime value
     * @param float $laborRunTime
     * @return \StructType\WorkOrderCompletionOperation
     */
    public function setLaborRunTime($laborRunTime = null)
    {
        // validation for constraint: float
        if (!is_null($laborRunTime) && !(is_float($laborRunTime) || is_numeric($laborRunTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($laborRunTime, true), gettype($laborRunTime)), __LINE__);
        }
        $this->laborRunTime = $laborRunTime;
        return $this;
    }
}
