<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorReturnAuthorizationExpenseList StructType
 * @subpackage Structs
 */
class VendorReturnAuthorizationExpenseList extends AbstractStructBase
{
    /**
     * The expense
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VendorReturnAuthorizationExpense[]
     */
    public $expense;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for VendorReturnAuthorizationExpenseList
     * @uses VendorReturnAuthorizationExpenseList::setExpense()
     * @uses VendorReturnAuthorizationExpenseList::setReplaceAll()
     * @param \StructType\VendorReturnAuthorizationExpense[] $expense
     * @param bool $replaceAll
     */
    public function __construct(array $expense = array(), $replaceAll = true)
    {
        $this
            ->setExpense($expense)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get expense value
     * @return \StructType\VendorReturnAuthorizationExpense[]|null
     */
    public function getExpense()
    {
        return $this->expense;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpenseForArrayConstraintsFromSetExpense(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vendorReturnAuthorizationExpenseListExpenseItem) {
            // validation for constraint: itemType
            if (!$vendorReturnAuthorizationExpenseListExpenseItem instanceof \StructType\VendorReturnAuthorizationExpense) {
                $invalidValues[] = is_object($vendorReturnAuthorizationExpenseListExpenseItem) ? get_class($vendorReturnAuthorizationExpenseListExpenseItem) : sprintf('%s(%s)', gettype($vendorReturnAuthorizationExpenseListExpenseItem), var_export($vendorReturnAuthorizationExpenseListExpenseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The expense property can only contain items of type \StructType\VendorReturnAuthorizationExpense, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set expense value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorReturnAuthorizationExpense[] $expense
     * @return \StructType\VendorReturnAuthorizationExpenseList
     */
    public function setExpense(array $expense = array())
    {
        // validation for constraint: array
        if ('' !== ($expenseArrayErrorMessage = self::validateExpenseForArrayConstraintsFromSetExpense($expense))) {
            throw new \InvalidArgumentException($expenseArrayErrorMessage, __LINE__);
        }
        $this->expense = $expense;
        return $this;
    }
    /**
     * Add item to expense value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorReturnAuthorizationExpense $item
     * @return \StructType\VendorReturnAuthorizationExpenseList
     */
    public function addToExpense(\StructType\VendorReturnAuthorizationExpense $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VendorReturnAuthorizationExpense) {
            throw new \InvalidArgumentException(sprintf('The expense property can only contain items of type \StructType\VendorReturnAuthorizationExpense, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->expense[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\VendorReturnAuthorizationExpenseList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
