<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorPricingScheduleList StructType
 * @subpackage Structs
 */
class VendorPricingScheduleList extends AbstractStructBase
{
    /**
     * The pricingSchedule
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VendorPricingSchedule[]
     */
    public $pricingSchedule;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for VendorPricingScheduleList
     * @uses VendorPricingScheduleList::setPricingSchedule()
     * @uses VendorPricingScheduleList::setReplaceAll()
     * @param \StructType\VendorPricingSchedule[] $pricingSchedule
     * @param bool $replaceAll
     */
    public function __construct(array $pricingSchedule = array(), $replaceAll = true)
    {
        $this
            ->setPricingSchedule($pricingSchedule)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get pricingSchedule value
     * @return \StructType\VendorPricingSchedule[]|null
     */
    public function getPricingSchedule()
    {
        return $this->pricingSchedule;
    }
    /**
     * This method is responsible for validating the values passed to the setPricingSchedule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPricingSchedule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricingScheduleForArrayConstraintsFromSetPricingSchedule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vendorPricingScheduleListPricingScheduleItem) {
            // validation for constraint: itemType
            if (!$vendorPricingScheduleListPricingScheduleItem instanceof \StructType\VendorPricingSchedule) {
                $invalidValues[] = is_object($vendorPricingScheduleListPricingScheduleItem) ? get_class($vendorPricingScheduleListPricingScheduleItem) : sprintf('%s(%s)', gettype($vendorPricingScheduleListPricingScheduleItem), var_export($vendorPricingScheduleListPricingScheduleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The pricingSchedule property can only contain items of type \StructType\VendorPricingSchedule, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set pricingSchedule value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorPricingSchedule[] $pricingSchedule
     * @return \StructType\VendorPricingScheduleList
     */
    public function setPricingSchedule(array $pricingSchedule = array())
    {
        // validation for constraint: array
        if ('' !== ($pricingScheduleArrayErrorMessage = self::validatePricingScheduleForArrayConstraintsFromSetPricingSchedule($pricingSchedule))) {
            throw new \InvalidArgumentException($pricingScheduleArrayErrorMessage, __LINE__);
        }
        $this->pricingSchedule = $pricingSchedule;
        return $this;
    }
    /**
     * Add item to pricingSchedule value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorPricingSchedule $item
     * @return \StructType\VendorPricingScheduleList
     */
    public function addToPricingSchedule(\StructType\VendorPricingSchedule $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VendorPricingSchedule) {
            throw new \InvalidArgumentException(sprintf('The pricingSchedule property can only contain items of type \StructType\VendorPricingSchedule, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->pricingSchedule[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\VendorPricingScheduleList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
