<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorBill StructType
 * Meta information extracted from the WSDL
 * - type: tranPurch:VendorBill
 * @subpackage Structs
 */
class VendorBill extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The nexus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nexus;
    /**
     * The subsidiaryTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiaryTaxRegNum;
    /**
     * The taxRegOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxRegOverride;
    /**
     * The taxDetailsOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxDetailsOverride;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The billAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billAddressList;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The approvalStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $approvalStatus;
    /**
     * The nextApprover
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nextApprover;
    /**
     * The vatRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vatRegNum;
    /**
     * The postingPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $postingPeriod;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The currencyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currencyName;
    /**
     * The billingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $billingAddress;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The entityTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entityTaxRegNum;
    /**
     * The taxPointDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxPointDate;
    /**
     * The terms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $terms;
    /**
     * The dueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dueDate;
    /**
     * The discountDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $discountDate;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The userTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $userTotal;
    /**
     * The discountAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountAmount;
    /**
     * The taxTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxTotal;
    /**
     * The paymentHold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $paymentHold;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The tax2Total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax2Total;
    /**
     * The creditLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $creditLimit;
    /**
     * The availableVendorCredit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $availableVendorCredit;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The landedCostMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $landedCostMethod;
    /**
     * The landedCostPerLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $landedCostPerLine;
    /**
     * The transactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transactionNumber;
    /**
     * The expenseList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorBillExpenseList
     */
    public $expenseList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The itemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorBillItemList
     */
    public $itemList;
    /**
     * The installmentList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InstallmentList
     */
    public $installmentList;
    /**
     * The landedCostsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PurchLandedCostList
     */
    public $landedCostsList;
    /**
     * The purchaseOrderList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $purchaseOrderList;
    /**
     * The taxDetailsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxDetailsList
     */
    public $taxDetailsList;
    /**
     * The overrideInstallments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $overrideInstallments;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for VendorBill
     * @uses VendorBill::setCreatedDate()
     * @uses VendorBill::setLastModifiedDate()
     * @uses VendorBill::setNexus()
     * @uses VendorBill::setSubsidiaryTaxRegNum()
     * @uses VendorBill::setTaxRegOverride()
     * @uses VendorBill::setTaxDetailsOverride()
     * @uses VendorBill::setCustomForm()
     * @uses VendorBill::setBillAddressList()
     * @uses VendorBill::setAccount()
     * @uses VendorBill::setEntity()
     * @uses VendorBill::setSubsidiary()
     * @uses VendorBill::setApprovalStatus()
     * @uses VendorBill::setNextApprover()
     * @uses VendorBill::setVatRegNum()
     * @uses VendorBill::setPostingPeriod()
     * @uses VendorBill::setTranDate()
     * @uses VendorBill::setCurrencyName()
     * @uses VendorBill::setBillingAddress()
     * @uses VendorBill::setExchangeRate()
     * @uses VendorBill::setEntityTaxRegNum()
     * @uses VendorBill::setTaxPointDate()
     * @uses VendorBill::setTerms()
     * @uses VendorBill::setDueDate()
     * @uses VendorBill::setDiscountDate()
     * @uses VendorBill::setTranId()
     * @uses VendorBill::setUserTotal()
     * @uses VendorBill::setDiscountAmount()
     * @uses VendorBill::setTaxTotal()
     * @uses VendorBill::setPaymentHold()
     * @uses VendorBill::setMemo()
     * @uses VendorBill::setTax2Total()
     * @uses VendorBill::setCreditLimit()
     * @uses VendorBill::setAvailableVendorCredit()
     * @uses VendorBill::setCurrency()
     * @uses VendorBill::setClass()
     * @uses VendorBill::setDepartment()
     * @uses VendorBill::setLocation()
     * @uses VendorBill::setStatus()
     * @uses VendorBill::setLandedCostMethod()
     * @uses VendorBill::setLandedCostPerLine()
     * @uses VendorBill::setTransactionNumber()
     * @uses VendorBill::setExpenseList()
     * @uses VendorBill::setAccountingBookDetailList()
     * @uses VendorBill::setItemList()
     * @uses VendorBill::setInstallmentList()
     * @uses VendorBill::setLandedCostsList()
     * @uses VendorBill::setPurchaseOrderList()
     * @uses VendorBill::setTaxDetailsList()
     * @uses VendorBill::setOverrideInstallments()
     * @uses VendorBill::setCustomFieldList()
     * @uses VendorBill::setInternalId()
     * @uses VendorBill::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $nexus
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @param bool $taxRegOverride
     * @param bool $taxDetailsOverride
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $billAddressList
     * @param \StructType\RecordRef $account
     * @param \StructType\RecordRef $entity
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $approvalStatus
     * @param \StructType\RecordRef $nextApprover
     * @param string $vatRegNum
     * @param \StructType\RecordRef $postingPeriod
     * @param string $tranDate
     * @param string $currencyName
     * @param \StructType\Address $billingAddress
     * @param float $exchangeRate
     * @param \StructType\RecordRef $entityTaxRegNum
     * @param string $taxPointDate
     * @param \StructType\RecordRef $terms
     * @param string $dueDate
     * @param string $discountDate
     * @param string $tranId
     * @param float $userTotal
     * @param float $discountAmount
     * @param float $taxTotal
     * @param bool $paymentHold
     * @param string $memo
     * @param float $tax2Total
     * @param float $creditLimit
     * @param float $availableVendorCredit
     * @param \StructType\RecordRef $currency
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $location
     * @param string $status
     * @param string $landedCostMethod
     * @param bool $landedCostPerLine
     * @param string $transactionNumber
     * @param \StructType\VendorBillExpenseList $expenseList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\VendorBillItemList $itemList
     * @param \StructType\InstallmentList $installmentList
     * @param \StructType\PurchLandedCostList $landedCostsList
     * @param \StructType\RecordRefList $purchaseOrderList
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @param bool $overrideInstallments
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $nexus = null, \StructType\RecordRef $subsidiaryTaxRegNum = null, $taxRegOverride = null, $taxDetailsOverride = null, \StructType\RecordRef $customForm = null, \StructType\RecordRef $billAddressList = null, \StructType\RecordRef $account = null, \StructType\RecordRef $entity = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $approvalStatus = null, \StructType\RecordRef $nextApprover = null, $vatRegNum = null, \StructType\RecordRef $postingPeriod = null, $tranDate = null, $currencyName = null, \StructType\Address $billingAddress = null, $exchangeRate = null, \StructType\RecordRef $entityTaxRegNum = null, $taxPointDate = null, \StructType\RecordRef $terms = null, $dueDate = null, $discountDate = null, $tranId = null, $userTotal = null, $discountAmount = null, $taxTotal = null, $paymentHold = null, $memo = null, $tax2Total = null, $creditLimit = null, $availableVendorCredit = null, \StructType\RecordRef $currency = null, \StructType\RecordRef $class = null, \StructType\RecordRef $department = null, \StructType\RecordRef $location = null, $status = null, $landedCostMethod = null, $landedCostPerLine = null, $transactionNumber = null, \StructType\VendorBillExpenseList $expenseList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\VendorBillItemList $itemList = null, \StructType\InstallmentList $installmentList = null, \StructType\PurchLandedCostList $landedCostsList = null, \StructType\RecordRefList $purchaseOrderList = null, \StructType\TaxDetailsList $taxDetailsList = null, $overrideInstallments = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setNexus($nexus)
            ->setSubsidiaryTaxRegNum($subsidiaryTaxRegNum)
            ->setTaxRegOverride($taxRegOverride)
            ->setTaxDetailsOverride($taxDetailsOverride)
            ->setCustomForm($customForm)
            ->setBillAddressList($billAddressList)
            ->setAccount($account)
            ->setEntity($entity)
            ->setSubsidiary($subsidiary)
            ->setApprovalStatus($approvalStatus)
            ->setNextApprover($nextApprover)
            ->setVatRegNum($vatRegNum)
            ->setPostingPeriod($postingPeriod)
            ->setTranDate($tranDate)
            ->setCurrencyName($currencyName)
            ->setBillingAddress($billingAddress)
            ->setExchangeRate($exchangeRate)
            ->setEntityTaxRegNum($entityTaxRegNum)
            ->setTaxPointDate($taxPointDate)
            ->setTerms($terms)
            ->setDueDate($dueDate)
            ->setDiscountDate($discountDate)
            ->setTranId($tranId)
            ->setUserTotal($userTotal)
            ->setDiscountAmount($discountAmount)
            ->setTaxTotal($taxTotal)
            ->setPaymentHold($paymentHold)
            ->setMemo($memo)
            ->setTax2Total($tax2Total)
            ->setCreditLimit($creditLimit)
            ->setAvailableVendorCredit($availableVendorCredit)
            ->setCurrency($currency)
            ->setClass($class)
            ->setDepartment($department)
            ->setLocation($location)
            ->setStatus($status)
            ->setLandedCostMethod($landedCostMethod)
            ->setLandedCostPerLine($landedCostPerLine)
            ->setTransactionNumber($transactionNumber)
            ->setExpenseList($expenseList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setItemList($itemList)
            ->setInstallmentList($installmentList)
            ->setLandedCostsList($landedCostsList)
            ->setPurchaseOrderList($purchaseOrderList)
            ->setTaxDetailsList($taxDetailsList)
            ->setOverrideInstallments($overrideInstallments)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\VendorBill
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\VendorBill
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get nexus value
     * @return \StructType\RecordRef|null
     */
    public function getNexus()
    {
        return $this->nexus;
    }
    /**
     * Set nexus value
     * @param \StructType\RecordRef $nexus
     * @return \StructType\VendorBill
     */
    public function setNexus(\StructType\RecordRef $nexus = null)
    {
        $this->nexus = $nexus;
        return $this;
    }
    /**
     * Get subsidiaryTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiaryTaxRegNum()
    {
        return $this->subsidiaryTaxRegNum;
    }
    /**
     * Set subsidiaryTaxRegNum value
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @return \StructType\VendorBill
     */
    public function setSubsidiaryTaxRegNum(\StructType\RecordRef $subsidiaryTaxRegNum = null)
    {
        $this->subsidiaryTaxRegNum = $subsidiaryTaxRegNum;
        return $this;
    }
    /**
     * Get taxRegOverride value
     * @return bool|null
     */
    public function getTaxRegOverride()
    {
        return $this->taxRegOverride;
    }
    /**
     * Set taxRegOverride value
     * @param bool $taxRegOverride
     * @return \StructType\VendorBill
     */
    public function setTaxRegOverride($taxRegOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxRegOverride) && !is_bool($taxRegOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxRegOverride, true), gettype($taxRegOverride)), __LINE__);
        }
        $this->taxRegOverride = $taxRegOverride;
        return $this;
    }
    /**
     * Get taxDetailsOverride value
     * @return bool|null
     */
    public function getTaxDetailsOverride()
    {
        return $this->taxDetailsOverride;
    }
    /**
     * Set taxDetailsOverride value
     * @param bool $taxDetailsOverride
     * @return \StructType\VendorBill
     */
    public function setTaxDetailsOverride($taxDetailsOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxDetailsOverride) && !is_bool($taxDetailsOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxDetailsOverride, true), gettype($taxDetailsOverride)), __LINE__);
        }
        $this->taxDetailsOverride = $taxDetailsOverride;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\VendorBill
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get billAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getBillAddressList()
    {
        return $this->billAddressList;
    }
    /**
     * Set billAddressList value
     * @param \StructType\RecordRef $billAddressList
     * @return \StructType\VendorBill
     */
    public function setBillAddressList(\StructType\RecordRef $billAddressList = null)
    {
        $this->billAddressList = $billAddressList;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\VendorBill
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\VendorBill
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\VendorBill
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get approvalStatus value
     * @return \StructType\RecordRef|null
     */
    public function getApprovalStatus()
    {
        return $this->approvalStatus;
    }
    /**
     * Set approvalStatus value
     * @param \StructType\RecordRef $approvalStatus
     * @return \StructType\VendorBill
     */
    public function setApprovalStatus(\StructType\RecordRef $approvalStatus = null)
    {
        $this->approvalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Get nextApprover value
     * @return \StructType\RecordRef|null
     */
    public function getNextApprover()
    {
        return $this->nextApprover;
    }
    /**
     * Set nextApprover value
     * @param \StructType\RecordRef $nextApprover
     * @return \StructType\VendorBill
     */
    public function setNextApprover(\StructType\RecordRef $nextApprover = null)
    {
        $this->nextApprover = $nextApprover;
        return $this;
    }
    /**
     * Get vatRegNum value
     * @return string|null
     */
    public function getVatRegNum()
    {
        return $this->vatRegNum;
    }
    /**
     * Set vatRegNum value
     * @param string $vatRegNum
     * @return \StructType\VendorBill
     */
    public function setVatRegNum($vatRegNum = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegNum) && !is_string($vatRegNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegNum, true), gettype($vatRegNum)), __LINE__);
        }
        $this->vatRegNum = $vatRegNum;
        return $this;
    }
    /**
     * Get postingPeriod value
     * @return \StructType\RecordRef|null
     */
    public function getPostingPeriod()
    {
        return $this->postingPeriod;
    }
    /**
     * Set postingPeriod value
     * @param \StructType\RecordRef $postingPeriod
     * @return \StructType\VendorBill
     */
    public function setPostingPeriod(\StructType\RecordRef $postingPeriod = null)
    {
        $this->postingPeriod = $postingPeriod;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\VendorBill
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get currencyName value
     * @return string|null
     */
    public function getCurrencyName()
    {
        return $this->currencyName;
    }
    /**
     * Set currencyName value
     * @param string $currencyName
     * @return \StructType\VendorBill
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        $this->currencyName = $currencyName;
        return $this;
    }
    /**
     * Get billingAddress value
     * @return \StructType\Address|null
     */
    public function getBillingAddress()
    {
        return $this->billingAddress;
    }
    /**
     * Set billingAddress value
     * @param \StructType\Address $billingAddress
     * @return \StructType\VendorBill
     */
    public function setBillingAddress(\StructType\Address $billingAddress = null)
    {
        $this->billingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\VendorBill
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get entityTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getEntityTaxRegNum()
    {
        return $this->entityTaxRegNum;
    }
    /**
     * Set entityTaxRegNum value
     * @param \StructType\RecordRef $entityTaxRegNum
     * @return \StructType\VendorBill
     */
    public function setEntityTaxRegNum(\StructType\RecordRef $entityTaxRegNum = null)
    {
        $this->entityTaxRegNum = $entityTaxRegNum;
        return $this;
    }
    /**
     * Get taxPointDate value
     * @return string|null
     */
    public function getTaxPointDate()
    {
        return $this->taxPointDate;
    }
    /**
     * Set taxPointDate value
     * @param string $taxPointDate
     * @return \StructType\VendorBill
     */
    public function setTaxPointDate($taxPointDate = null)
    {
        // validation for constraint: string
        if (!is_null($taxPointDate) && !is_string($taxPointDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxPointDate, true), gettype($taxPointDate)), __LINE__);
        }
        $this->taxPointDate = $taxPointDate;
        return $this;
    }
    /**
     * Get terms value
     * @return \StructType\RecordRef|null
     */
    public function getTerms()
    {
        return $this->terms;
    }
    /**
     * Set terms value
     * @param \StructType\RecordRef $terms
     * @return \StructType\VendorBill
     */
    public function setTerms(\StructType\RecordRef $terms = null)
    {
        $this->terms = $terms;
        return $this;
    }
    /**
     * Get dueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }
    /**
     * Set dueDate value
     * @param string $dueDate
     * @return \StructType\VendorBill
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->dueDate = $dueDate;
        return $this;
    }
    /**
     * Get discountDate value
     * @return string|null
     */
    public function getDiscountDate()
    {
        return $this->discountDate;
    }
    /**
     * Set discountDate value
     * @param string $discountDate
     * @return \StructType\VendorBill
     */
    public function setDiscountDate($discountDate = null)
    {
        // validation for constraint: string
        if (!is_null($discountDate) && !is_string($discountDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountDate, true), gettype($discountDate)), __LINE__);
        }
        $this->discountDate = $discountDate;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\VendorBill
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get userTotal value
     * @return float|null
     */
    public function getUserTotal()
    {
        return $this->userTotal;
    }
    /**
     * Set userTotal value
     * @param float $userTotal
     * @return \StructType\VendorBill
     */
    public function setUserTotal($userTotal = null)
    {
        // validation for constraint: float
        if (!is_null($userTotal) && !(is_float($userTotal) || is_numeric($userTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($userTotal, true), gettype($userTotal)), __LINE__);
        }
        $this->userTotal = $userTotal;
        return $this;
    }
    /**
     * Get discountAmount value
     * @return float|null
     */
    public function getDiscountAmount()
    {
        return $this->discountAmount;
    }
    /**
     * Set discountAmount value
     * @param float $discountAmount
     * @return \StructType\VendorBill
     */
    public function setDiscountAmount($discountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($discountAmount) && !(is_float($discountAmount) || is_numeric($discountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountAmount, true), gettype($discountAmount)), __LINE__);
        }
        $this->discountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get taxTotal value
     * @return float|null
     */
    public function getTaxTotal()
    {
        return $this->taxTotal;
    }
    /**
     * Set taxTotal value
     * @param float $taxTotal
     * @return \StructType\VendorBill
     */
    public function setTaxTotal($taxTotal = null)
    {
        // validation for constraint: float
        if (!is_null($taxTotal) && !(is_float($taxTotal) || is_numeric($taxTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxTotal, true), gettype($taxTotal)), __LINE__);
        }
        $this->taxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get paymentHold value
     * @return bool|null
     */
    public function getPaymentHold()
    {
        return $this->paymentHold;
    }
    /**
     * Set paymentHold value
     * @param bool $paymentHold
     * @return \StructType\VendorBill
     */
    public function setPaymentHold($paymentHold = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentHold) && !is_bool($paymentHold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paymentHold, true), gettype($paymentHold)), __LINE__);
        }
        $this->paymentHold = $paymentHold;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\VendorBill
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get tax2Total value
     * @return float|null
     */
    public function getTax2Total()
    {
        return $this->tax2Total;
    }
    /**
     * Set tax2Total value
     * @param float $tax2Total
     * @return \StructType\VendorBill
     */
    public function setTax2Total($tax2Total = null)
    {
        // validation for constraint: float
        if (!is_null($tax2Total) && !(is_float($tax2Total) || is_numeric($tax2Total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax2Total, true), gettype($tax2Total)), __LINE__);
        }
        $this->tax2Total = $tax2Total;
        return $this;
    }
    /**
     * Get creditLimit value
     * @return float|null
     */
    public function getCreditLimit()
    {
        return $this->creditLimit;
    }
    /**
     * Set creditLimit value
     * @param float $creditLimit
     * @return \StructType\VendorBill
     */
    public function setCreditLimit($creditLimit = null)
    {
        // validation for constraint: float
        if (!is_null($creditLimit) && !(is_float($creditLimit) || is_numeric($creditLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($creditLimit, true), gettype($creditLimit)), __LINE__);
        }
        $this->creditLimit = $creditLimit;
        return $this;
    }
    /**
     * Get availableVendorCredit value
     * @return float|null
     */
    public function getAvailableVendorCredit()
    {
        return $this->availableVendorCredit;
    }
    /**
     * Set availableVendorCredit value
     * @param float $availableVendorCredit
     * @return \StructType\VendorBill
     */
    public function setAvailableVendorCredit($availableVendorCredit = null)
    {
        // validation for constraint: float
        if (!is_null($availableVendorCredit) && !(is_float($availableVendorCredit) || is_numeric($availableVendorCredit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($availableVendorCredit, true), gettype($availableVendorCredit)), __LINE__);
        }
        $this->availableVendorCredit = $availableVendorCredit;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\VendorBill
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\VendorBill
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\VendorBill
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\VendorBill
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\VendorBill
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get landedCostMethod value
     * @return string|null
     */
    public function getLandedCostMethod()
    {
        return $this->landedCostMethod;
    }
    /**
     * Set landedCostMethod value
     * @uses \EnumType\LandedCostMethod::valueIsValid()
     * @uses \EnumType\LandedCostMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $landedCostMethod
     * @return \StructType\VendorBill
     */
    public function setLandedCostMethod($landedCostMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LandedCostMethod::valueIsValid($landedCostMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LandedCostMethod', is_array($landedCostMethod) ? implode(', ', $landedCostMethod) : var_export($landedCostMethod, true), implode(', ', \EnumType\LandedCostMethod::getValidValues())), __LINE__);
        }
        $this->landedCostMethod = $landedCostMethod;
        return $this;
    }
    /**
     * Get landedCostPerLine value
     * @return bool|null
     */
    public function getLandedCostPerLine()
    {
        return $this->landedCostPerLine;
    }
    /**
     * Set landedCostPerLine value
     * @param bool $landedCostPerLine
     * @return \StructType\VendorBill
     */
    public function setLandedCostPerLine($landedCostPerLine = null)
    {
        // validation for constraint: boolean
        if (!is_null($landedCostPerLine) && !is_bool($landedCostPerLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($landedCostPerLine, true), gettype($landedCostPerLine)), __LINE__);
        }
        $this->landedCostPerLine = $landedCostPerLine;
        return $this;
    }
    /**
     * Get transactionNumber value
     * @return string|null
     */
    public function getTransactionNumber()
    {
        return $this->transactionNumber;
    }
    /**
     * Set transactionNumber value
     * @param string $transactionNumber
     * @return \StructType\VendorBill
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNumber) && !is_string($transactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        $this->transactionNumber = $transactionNumber;
        return $this;
    }
    /**
     * Get expenseList value
     * @return \StructType\VendorBillExpenseList|null
     */
    public function getExpenseList()
    {
        return $this->expenseList;
    }
    /**
     * Set expenseList value
     * @param \StructType\VendorBillExpenseList $expenseList
     * @return \StructType\VendorBill
     */
    public function setExpenseList(\StructType\VendorBillExpenseList $expenseList = null)
    {
        $this->expenseList = $expenseList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\VendorBill
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get itemList value
     * @return \StructType\VendorBillItemList|null
     */
    public function getItemList()
    {
        return $this->itemList;
    }
    /**
     * Set itemList value
     * @param \StructType\VendorBillItemList $itemList
     * @return \StructType\VendorBill
     */
    public function setItemList(\StructType\VendorBillItemList $itemList = null)
    {
        $this->itemList = $itemList;
        return $this;
    }
    /**
     * Get installmentList value
     * @return \StructType\InstallmentList|null
     */
    public function getInstallmentList()
    {
        return $this->installmentList;
    }
    /**
     * Set installmentList value
     * @param \StructType\InstallmentList $installmentList
     * @return \StructType\VendorBill
     */
    public function setInstallmentList(\StructType\InstallmentList $installmentList = null)
    {
        $this->installmentList = $installmentList;
        return $this;
    }
    /**
     * Get landedCostsList value
     * @return \StructType\PurchLandedCostList|null
     */
    public function getLandedCostsList()
    {
        return $this->landedCostsList;
    }
    /**
     * Set landedCostsList value
     * @param \StructType\PurchLandedCostList $landedCostsList
     * @return \StructType\VendorBill
     */
    public function setLandedCostsList(\StructType\PurchLandedCostList $landedCostsList = null)
    {
        $this->landedCostsList = $landedCostsList;
        return $this;
    }
    /**
     * Get purchaseOrderList value
     * @return \StructType\RecordRefList|null
     */
    public function getPurchaseOrderList()
    {
        return $this->purchaseOrderList;
    }
    /**
     * Set purchaseOrderList value
     * @param \StructType\RecordRefList $purchaseOrderList
     * @return \StructType\VendorBill
     */
    public function setPurchaseOrderList(\StructType\RecordRefList $purchaseOrderList = null)
    {
        $this->purchaseOrderList = $purchaseOrderList;
        return $this;
    }
    /**
     * Get taxDetailsList value
     * @return \StructType\TaxDetailsList|null
     */
    public function getTaxDetailsList()
    {
        return $this->taxDetailsList;
    }
    /**
     * Set taxDetailsList value
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @return \StructType\VendorBill
     */
    public function setTaxDetailsList(\StructType\TaxDetailsList $taxDetailsList = null)
    {
        $this->taxDetailsList = $taxDetailsList;
        return $this;
    }
    /**
     * Get overrideInstallments value
     * @return bool|null
     */
    public function getOverrideInstallments()
    {
        return $this->overrideInstallments;
    }
    /**
     * Set overrideInstallments value
     * @param bool $overrideInstallments
     * @return \StructType\VendorBill
     */
    public function setOverrideInstallments($overrideInstallments = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideInstallments) && !is_bool($overrideInstallments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideInstallments, true), gettype($overrideInstallments)), __LINE__);
        }
        $this->overrideInstallments = $overrideInstallments;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\VendorBill
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\VendorBill
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\VendorBill
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
