<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateInviteeStatusReference StructType
 * @subpackage Structs
 */
class UpdateInviteeStatusReference extends AbstractStructBase
{
    /**
     * The eventId
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var \StructType\RecordRef
     */
    public $eventId;
    /**
     * The responseCode
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $responseCode;
    /**
     * Constructor method for UpdateInviteeStatusReference
     * @uses UpdateInviteeStatusReference::setEventId()
     * @uses UpdateInviteeStatusReference::setResponseCode()
     * @param \StructType\RecordRef $eventId
     * @param string $responseCode
     */
    public function __construct(\StructType\RecordRef $eventId = null, $responseCode = null)
    {
        $this
            ->setEventId($eventId)
            ->setResponseCode($responseCode);
    }
    /**
     * Get eventId value
     * @return \StructType\RecordRef
     */
    public function getEventId()
    {
        return $this->eventId;
    }
    /**
     * Set eventId value
     * @param \StructType\RecordRef $eventId
     * @return \StructType\UpdateInviteeStatusReference
     */
    public function setEventId(\StructType\RecordRef $eventId = null)
    {
        $this->eventId = $eventId;
        return $this;
    }
    /**
     * Get responseCode value
     * @return string
     */
    public function getResponseCode()
    {
        return $this->responseCode;
    }
    /**
     * Set responseCode value
     * @uses \EnumType\CalendarEventAttendeeResponse::valueIsValid()
     * @uses \EnumType\CalendarEventAttendeeResponse::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $responseCode
     * @return \StructType\UpdateInviteeStatusReference
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CalendarEventAttendeeResponse::valueIsValid($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CalendarEventAttendeeResponse', is_array($responseCode) ? implode(', ', $responseCode) : var_export($responseCode, true), implode(', ', \EnumType\CalendarEventAttendeeResponse::getValidValues())), __LINE__);
        }
        $this->responseCode = $responseCode;
        return $this;
    }
}
