<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitsTypeSearchRowBasic StructType
 * @subpackage Structs
 */
class UnitsTypeSearchRowBasic extends SearchRowBasic
{
    /**
     * The abbreviation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $abbreviation;
    /**
     * The baseUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $baseUnit;
    /**
     * The conversionRate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $conversionRate;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $externalId;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnSelectField[]
     */
    public $internalId;
    /**
     * The isInActive
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnBooleanField[]
     */
    public $isInActive;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $name;
    /**
     * The pluralAbbreviation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $pluralAbbreviation;
    /**
     * The pluralName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $pluralName;
    /**
     * The unitName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SearchColumnStringField[]
     */
    public $unitName;
    /**
     * Constructor method for UnitsTypeSearchRowBasic
     * @uses UnitsTypeSearchRowBasic::setAbbreviation()
     * @uses UnitsTypeSearchRowBasic::setBaseUnit()
     * @uses UnitsTypeSearchRowBasic::setConversionRate()
     * @uses UnitsTypeSearchRowBasic::setExternalId()
     * @uses UnitsTypeSearchRowBasic::setInternalId()
     * @uses UnitsTypeSearchRowBasic::setIsInActive()
     * @uses UnitsTypeSearchRowBasic::setName()
     * @uses UnitsTypeSearchRowBasic::setPluralAbbreviation()
     * @uses UnitsTypeSearchRowBasic::setPluralName()
     * @uses UnitsTypeSearchRowBasic::setUnitName()
     * @param \StructType\SearchColumnStringField[] $abbreviation
     * @param \StructType\SearchColumnBooleanField[] $baseUnit
     * @param \StructType\SearchColumnStringField[] $conversionRate
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @param \StructType\SearchColumnBooleanField[] $isInActive
     * @param \StructType\SearchColumnStringField[] $name
     * @param \StructType\SearchColumnStringField[] $pluralAbbreviation
     * @param \StructType\SearchColumnStringField[] $pluralName
     * @param \StructType\SearchColumnStringField[] $unitName
     */
    public function __construct(array $abbreviation = array(), array $baseUnit = array(), array $conversionRate = array(), array $externalId = array(), array $internalId = array(), array $isInActive = array(), array $name = array(), array $pluralAbbreviation = array(), array $pluralName = array(), array $unitName = array())
    {
        $this
            ->setAbbreviation($abbreviation)
            ->setBaseUnit($baseUnit)
            ->setConversionRate($conversionRate)
            ->setExternalId($externalId)
            ->setInternalId($internalId)
            ->setIsInActive($isInActive)
            ->setName($name)
            ->setPluralAbbreviation($pluralAbbreviation)
            ->setPluralName($pluralName)
            ->setUnitName($unitName);
    }
    /**
     * Get abbreviation value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getAbbreviation()
    {
        return $this->abbreviation;
    }
    /**
     * This method is responsible for validating the values passed to the setAbbreviation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAbbreviation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAbbreviationForArrayConstraintsFromSetAbbreviation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitsTypeSearchRowBasicAbbreviationItem) {
            // validation for constraint: itemType
            if (!$unitsTypeSearchRowBasicAbbreviationItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($unitsTypeSearchRowBasicAbbreviationItem) ? get_class($unitsTypeSearchRowBasicAbbreviationItem) : sprintf('%s(%s)', gettype($unitsTypeSearchRowBasicAbbreviationItem), var_export($unitsTypeSearchRowBasicAbbreviationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The abbreviation property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set abbreviation value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $abbreviation
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function setAbbreviation(array $abbreviation = array())
    {
        // validation for constraint: array
        if ('' !== ($abbreviationArrayErrorMessage = self::validateAbbreviationForArrayConstraintsFromSetAbbreviation($abbreviation))) {
            throw new \InvalidArgumentException($abbreviationArrayErrorMessage, __LINE__);
        }
        $this->abbreviation = $abbreviation;
        return $this;
    }
    /**
     * Add item to abbreviation value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function addToAbbreviation(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The abbreviation property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->abbreviation[] = $item;
        return $this;
    }
    /**
     * Get baseUnit value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getBaseUnit()
    {
        return $this->baseUnit;
    }
    /**
     * This method is responsible for validating the values passed to the setBaseUnit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaseUnit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaseUnitForArrayConstraintsFromSetBaseUnit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitsTypeSearchRowBasicBaseUnitItem) {
            // validation for constraint: itemType
            if (!$unitsTypeSearchRowBasicBaseUnitItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($unitsTypeSearchRowBasicBaseUnitItem) ? get_class($unitsTypeSearchRowBasicBaseUnitItem) : sprintf('%s(%s)', gettype($unitsTypeSearchRowBasicBaseUnitItem), var_export($unitsTypeSearchRowBasicBaseUnitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The baseUnit property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set baseUnit value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $baseUnit
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function setBaseUnit(array $baseUnit = array())
    {
        // validation for constraint: array
        if ('' !== ($baseUnitArrayErrorMessage = self::validateBaseUnitForArrayConstraintsFromSetBaseUnit($baseUnit))) {
            throw new \InvalidArgumentException($baseUnitArrayErrorMessage, __LINE__);
        }
        $this->baseUnit = $baseUnit;
        return $this;
    }
    /**
     * Add item to baseUnit value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function addToBaseUnit(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The baseUnit property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->baseUnit[] = $item;
        return $this;
    }
    /**
     * Get conversionRate value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getConversionRate()
    {
        return $this->conversionRate;
    }
    /**
     * This method is responsible for validating the values passed to the setConversionRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConversionRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConversionRateForArrayConstraintsFromSetConversionRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitsTypeSearchRowBasicConversionRateItem) {
            // validation for constraint: itemType
            if (!$unitsTypeSearchRowBasicConversionRateItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($unitsTypeSearchRowBasicConversionRateItem) ? get_class($unitsTypeSearchRowBasicConversionRateItem) : sprintf('%s(%s)', gettype($unitsTypeSearchRowBasicConversionRateItem), var_export($unitsTypeSearchRowBasicConversionRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The conversionRate property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set conversionRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $conversionRate
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function setConversionRate(array $conversionRate = array())
    {
        // validation for constraint: array
        if ('' !== ($conversionRateArrayErrorMessage = self::validateConversionRateForArrayConstraintsFromSetConversionRate($conversionRate))) {
            throw new \InvalidArgumentException($conversionRateArrayErrorMessage, __LINE__);
        }
        $this->conversionRate = $conversionRate;
        return $this;
    }
    /**
     * Add item to conversionRate value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function addToConversionRate(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The conversionRate property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->conversionRate[] = $item;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * This method is responsible for validating the values passed to the setExternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternalIdForArrayConstraintsFromSetExternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitsTypeSearchRowBasicExternalIdItem) {
            // validation for constraint: itemType
            if (!$unitsTypeSearchRowBasicExternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($unitsTypeSearchRowBasicExternalIdItem) ? get_class($unitsTypeSearchRowBasicExternalIdItem) : sprintf('%s(%s)', gettype($unitsTypeSearchRowBasicExternalIdItem), var_export($unitsTypeSearchRowBasicExternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $externalId
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function setExternalId(array $externalId = array())
    {
        // validation for constraint: array
        if ('' !== ($externalIdArrayErrorMessage = self::validateExternalIdForArrayConstraintsFromSetExternalId($externalId))) {
            throw new \InvalidArgumentException($externalIdArrayErrorMessage, __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Add item to externalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function addToExternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The externalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->externalId[] = $item;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchColumnSelectField[]|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * This method is responsible for validating the values passed to the setInternalId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternalId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternalIdForArrayConstraintsFromSetInternalId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitsTypeSearchRowBasicInternalIdItem) {
            // validation for constraint: itemType
            if (!$unitsTypeSearchRowBasicInternalIdItem instanceof \StructType\SearchColumnSelectField) {
                $invalidValues[] = is_object($unitsTypeSearchRowBasicInternalIdItem) ? get_class($unitsTypeSearchRowBasicInternalIdItem) : sprintf('%s(%s)', gettype($unitsTypeSearchRowBasicInternalIdItem), var_export($unitsTypeSearchRowBasicInternalIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField[] $internalId
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function setInternalId(array $internalId = array())
    {
        // validation for constraint: array
        if ('' !== ($internalIdArrayErrorMessage = self::validateInternalIdForArrayConstraintsFromSetInternalId($internalId))) {
            throw new \InvalidArgumentException($internalIdArrayErrorMessage, __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Add item to internalId value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnSelectField $item
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function addToInternalId(\StructType\SearchColumnSelectField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnSelectField) {
            throw new \InvalidArgumentException(sprintf('The internalId property can only contain items of type \StructType\SearchColumnSelectField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internalId[] = $item;
        return $this;
    }
    /**
     * Get isInActive value
     * @return \StructType\SearchColumnBooleanField[]|null
     */
    public function getIsInActive()
    {
        return $this->isInActive;
    }
    /**
     * This method is responsible for validating the values passed to the setIsInActive method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsInActive method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIsInActiveForArrayConstraintsFromSetIsInActive(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitsTypeSearchRowBasicIsInActiveItem) {
            // validation for constraint: itemType
            if (!$unitsTypeSearchRowBasicIsInActiveItem instanceof \StructType\SearchColumnBooleanField) {
                $invalidValues[] = is_object($unitsTypeSearchRowBasicIsInActiveItem) ? get_class($unitsTypeSearchRowBasicIsInActiveItem) : sprintf('%s(%s)', gettype($unitsTypeSearchRowBasicIsInActiveItem), var_export($unitsTypeSearchRowBasicIsInActiveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The isInActive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set isInActive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField[] $isInActive
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function setIsInActive(array $isInActive = array())
    {
        // validation for constraint: array
        if ('' !== ($isInActiveArrayErrorMessage = self::validateIsInActiveForArrayConstraintsFromSetIsInActive($isInActive))) {
            throw new \InvalidArgumentException($isInActiveArrayErrorMessage, __LINE__);
        }
        $this->isInActive = $isInActive;
        return $this;
    }
    /**
     * Add item to isInActive value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnBooleanField $item
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function addToIsInActive(\StructType\SearchColumnBooleanField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnBooleanField) {
            throw new \InvalidArgumentException(sprintf('The isInActive property can only contain items of type \StructType\SearchColumnBooleanField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->isInActive[] = $item;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * This method is responsible for validating the values passed to the setName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameForArrayConstraintsFromSetName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitsTypeSearchRowBasicNameItem) {
            // validation for constraint: itemType
            if (!$unitsTypeSearchRowBasicNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($unitsTypeSearchRowBasicNameItem) ? get_class($unitsTypeSearchRowBasicNameItem) : sprintf('%s(%s)', gettype($unitsTypeSearchRowBasicNameItem), var_export($unitsTypeSearchRowBasicNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $name
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function setName(array $name = array())
    {
        // validation for constraint: array
        if ('' !== ($nameArrayErrorMessage = self::validateNameForArrayConstraintsFromSetName($name))) {
            throw new \InvalidArgumentException($nameArrayErrorMessage, __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Add item to name value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function addToName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The name property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->name[] = $item;
        return $this;
    }
    /**
     * Get pluralAbbreviation value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getPluralAbbreviation()
    {
        return $this->pluralAbbreviation;
    }
    /**
     * This method is responsible for validating the values passed to the setPluralAbbreviation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPluralAbbreviation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePluralAbbreviationForArrayConstraintsFromSetPluralAbbreviation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitsTypeSearchRowBasicPluralAbbreviationItem) {
            // validation for constraint: itemType
            if (!$unitsTypeSearchRowBasicPluralAbbreviationItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($unitsTypeSearchRowBasicPluralAbbreviationItem) ? get_class($unitsTypeSearchRowBasicPluralAbbreviationItem) : sprintf('%s(%s)', gettype($unitsTypeSearchRowBasicPluralAbbreviationItem), var_export($unitsTypeSearchRowBasicPluralAbbreviationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The pluralAbbreviation property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set pluralAbbreviation value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $pluralAbbreviation
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function setPluralAbbreviation(array $pluralAbbreviation = array())
    {
        // validation for constraint: array
        if ('' !== ($pluralAbbreviationArrayErrorMessage = self::validatePluralAbbreviationForArrayConstraintsFromSetPluralAbbreviation($pluralAbbreviation))) {
            throw new \InvalidArgumentException($pluralAbbreviationArrayErrorMessage, __LINE__);
        }
        $this->pluralAbbreviation = $pluralAbbreviation;
        return $this;
    }
    /**
     * Add item to pluralAbbreviation value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function addToPluralAbbreviation(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The pluralAbbreviation property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->pluralAbbreviation[] = $item;
        return $this;
    }
    /**
     * Get pluralName value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getPluralName()
    {
        return $this->pluralName;
    }
    /**
     * This method is responsible for validating the values passed to the setPluralName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPluralName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePluralNameForArrayConstraintsFromSetPluralName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitsTypeSearchRowBasicPluralNameItem) {
            // validation for constraint: itemType
            if (!$unitsTypeSearchRowBasicPluralNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($unitsTypeSearchRowBasicPluralNameItem) ? get_class($unitsTypeSearchRowBasicPluralNameItem) : sprintf('%s(%s)', gettype($unitsTypeSearchRowBasicPluralNameItem), var_export($unitsTypeSearchRowBasicPluralNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The pluralName property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set pluralName value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $pluralName
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function setPluralName(array $pluralName = array())
    {
        // validation for constraint: array
        if ('' !== ($pluralNameArrayErrorMessage = self::validatePluralNameForArrayConstraintsFromSetPluralName($pluralName))) {
            throw new \InvalidArgumentException($pluralNameArrayErrorMessage, __LINE__);
        }
        $this->pluralName = $pluralName;
        return $this;
    }
    /**
     * Add item to pluralName value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function addToPluralName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The pluralName property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->pluralName[] = $item;
        return $this;
    }
    /**
     * Get unitName value
     * @return \StructType\SearchColumnStringField[]|null
     */
    public function getUnitName()
    {
        return $this->unitName;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitNameForArrayConstraintsFromSetUnitName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitsTypeSearchRowBasicUnitNameItem) {
            // validation for constraint: itemType
            if (!$unitsTypeSearchRowBasicUnitNameItem instanceof \StructType\SearchColumnStringField) {
                $invalidValues[] = is_object($unitsTypeSearchRowBasicUnitNameItem) ? get_class($unitsTypeSearchRowBasicUnitNameItem) : sprintf('%s(%s)', gettype($unitsTypeSearchRowBasicUnitNameItem), var_export($unitsTypeSearchRowBasicUnitNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The unitName property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set unitName value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField[] $unitName
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function setUnitName(array $unitName = array())
    {
        // validation for constraint: array
        if ('' !== ($unitNameArrayErrorMessage = self::validateUnitNameForArrayConstraintsFromSetUnitName($unitName))) {
            throw new \InvalidArgumentException($unitNameArrayErrorMessage, __LINE__);
        }
        $this->unitName = $unitName;
        return $this;
    }
    /**
     * Add item to unitName value
     * @throws \InvalidArgumentException
     * @param \StructType\SearchColumnStringField $item
     * @return \StructType\UnitsTypeSearchRowBasic
     */
    public function addToUnitName(\StructType\SearchColumnStringField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SearchColumnStringField) {
            throw new \InvalidArgumentException(sprintf('The unitName property can only contain items of type \StructType\SearchColumnStringField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->unitName[] = $item;
        return $this;
    }
}
